/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.ChangeManagerBeanRepo;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;

public class ConfigurationTransactionHelper {
    private ConfigurationTransactionHelper() {
    }

    public static Response<Void> editConfiguration(InvocationContext ic, ConfigurationEditor editor) {
        BeanRepo beanRepo = ic.getPageRepo().getBeanRepo();
        if (!beanRepo.isChangeManagerBeanRepo()) {
            return editor.editConfiguration();
        }
        ChangeManagerBeanRepo changeManagerBeanRepo = beanRepo.asChangeManagerBeanRepo();
        boolean retainEarlierMessages = true;
        Response<Void> response = new Response<Void>();
        Response<Void> startResponse = changeManagerBeanRepo.startEdit(ic);
        if (!startResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(startResponse, retainEarlierMessages);
        }
        response.copyMessages(startResponse);
        Response<Void> editResponse = editor.editConfiguration();
        if (!editResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(editResponse, retainEarlierMessages);
        }
        response.copyMessages(editResponse);
        Response<Void> saveResponse = changeManagerBeanRepo.saveChanges(ic);
        if (!saveResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(saveResponse, retainEarlierMessages);
        }
        response.copyMessages(saveResponse);
        return response;
    }

    public static interface ConfigurationEditor {
        public Response<Void> editConfiguration();
    }
}

