/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.server.repo.BeanPropertyValue;
import weblogic.remoteconsole.server.repo.BeanPropertyValues;
import weblogic.remoteconsole.server.repo.BeanTreePath;

public class BeansPropertyValues {
    private BeanTreePath beanTreePath;
    private Map<String, BeanPropertyValues> beanTreePathToBeanPropertyValuesMap = new TreeMap<String, BeanPropertyValues>();

    public BeansPropertyValues(BeanTreePath beanTreePath) {
        this.beanTreePath = beanTreePath;
    }

    public void addPropertyValue(BeanPropertyValue propertyValue) {
        BeanPropertyDef propertyDef = propertyValue.getPropertyDef();
        BeanTreePath propertyBeanTreePath = this.beanTreePath;
        Path parentPath = propertyDef.getParentPath();
        if (!parentPath.isEmpty()) {
            propertyBeanTreePath = propertyBeanTreePath.childPath(parentPath);
            propertyDef = propertyBeanTreePath.getTypeDef().getPropertyDef(new Path(propertyDef.getPropertyName()), true);
        }
        BeanPropertyValues propertyValues = this.getPropertyValues(propertyBeanTreePath);
        propertyValues.addPropertyValue(new BeanPropertyValue(propertyDef, propertyValue.getValue()));
    }

    public void addBean(BeanTreePath beanTreePath) {
        this.getPropertyValues(beanTreePath);
    }

    private BeanPropertyValues getPropertyValues(BeanTreePath beanTreePath) {
        String key = beanTreePath.getPath().getDotSeparatedPath();
        if (!this.beanTreePathToBeanPropertyValuesMap.containsKey(key)) {
            this.beanTreePathToBeanPropertyValuesMap.put(key, new BeanPropertyValues(beanTreePath));
        }
        return this.beanTreePathToBeanPropertyValuesMap.get(key);
    }

    public List<BeanPropertyValues> getSortedBeansPropertyValues() {
        ArrayList<BeanPropertyValues> sortedValues = new ArrayList<BeanPropertyValues>();
        for (BeanPropertyValues beanPropertyValues : this.beanTreePathToBeanPropertyValuesMap.values()) {
            sortedValues.add(beanPropertyValues);
        }
        return sortedValues;
    }
}

