/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;

public class BeanTreePathTemplate {
    private Path pathTemplate;

    public BeanTreePathTemplate(String pathTemplate) {
        this.pathTemplate = new Path(pathTemplate.replaceAll("/", "."));
    }

    public Path expand(BeanTreePath values) {
        Path path = new Path();
        for (String templateComponent : this.pathTemplate.getComponents()) {
            String pathComponent = this.computePathComponentFromTemplate(templateComponent, values);
            if (pathComponent == null) {
                return null;
            }
            path.addComponent(pathComponent);
        }
        return path;
    }

    private String computePathComponentFromTemplate(String templateComponent, BeanTreePath values) {
        if (templateComponent.startsWith("<")) {
            if (!templateComponent.endsWith(">")) {
                throw new AssertionError((Object)("Template doesn't end with '>': " + templateComponent));
            }
            String typeInstanceName = templateComponent.substring(1, templateComponent.length() - 1);
            if (typeInstanceName.isEmpty()) {
                throw new AssertionError((Object)("Empty template: " + templateComponent));
            }
            for (BeanTreePathSegment segment : values.getSegments()) {
                BeanChildDef childDef = segment.getChildDef();
                if (!childDef.getChildTypeDef().getInstanceName().equals(typeInstanceName)) continue;
                if (childDef.isCollection()) {
                    if (segment.isKeySet()) {
                        return segment.getKey();
                    }
                    throw new AssertionError((Object)(templateComponent + " is a collection, not a collection child: " + childDef.getChildName() + " " + String.valueOf(values)));
                }
                return null;
            }
            return null;
        }
        return templateComponent;
    }
}

