/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.Value;

public class BeanTreePath
extends Value {
    private BeanRepo beanRepo;
    private boolean resolved;
    private Path path = new Path();
    private List<BeanTreePathSegment> segments = new ArrayList<BeanTreePathSegment>();
    public static final String ALL_COLLECTION_CHILDREN = "*";

    public static BeanTreePath create(BeanRepo beanRepo, Path path) {
        return new BeanTreePath(beanRepo, path, false);
    }

    public static BeanTreePath createAllowUnresolved(BeanRepo beanRepo, Path path) {
        BeanTreePath beanTreePath = new BeanTreePath(beanRepo, path, true);
        return beanTreePath.resolved ? beanTreePath : null;
    }

    public BeanTreePath childPath(String child) {
        return this.childPath(new Path(child));
    }

    public BeanTreePath childPath(Path childPath) {
        BeanTreePath beanTreePath = new BeanTreePath(this.beanRepo, this.path, false);
        beanTreePath.addPath(childPath, false);
        return beanTreePath;
    }

    public BeanRepo getBeanRepo() {
        return this.beanRepo;
    }

    public Path getPath() {
        return this.path;
    }

    public List<BeanTreePathSegment> getSegments() {
        return this.segments;
    }

    private BeanTreePath(BeanRepo beanRepo, Path path, boolean allowUnresolved) {
        this.beanRepo = beanRepo;
        this.resolved = this.addPath(path, allowUnresolved);
    }

    private boolean addPath(Path pathToAdd, boolean allowUnresolved) {
        if (this.isCollection() && !pathToAdd.isEmpty()) {
            this.path.addComponent(ALL_COLLECTION_CHILDREN);
        }
        BeanTypeDef typeDef = this.getSegments().isEmpty() ? this.getBeanRepo().getBeanRepoDef().getRootTypeDef() : this.getLastSegment().getChildDef().getChildTypeDef();
        List components = pathToAdd.getComponents();
        int i = 0;
        while (i < components.size()) {
            String childName = (String)components.get(i);
            BeanChildDef childDef = this.findChild(typeDef, childName);
            if (childDef == null) {
                if (allowUnresolved) {
                    return false;
                }
                throw new AssertionError((Object)(String.valueOf(this.path) + ": can't find " + childName + " in " + String.valueOf(typeDef)));
            }
            typeDef = childDef.getChildTypeDef();
            if (childDef.isCollection() && ++i < components.size()) {
                String childKey = (String)components.get(i);
                ++i;
                if (ALL_COLLECTION_CHILDREN.equals(childKey)) {
                    this.getSegments().add(new BeanTreePathSegment(this, childDef));
                    continue;
                }
                this.getSegments().add(new BeanTreePathSegment(this, childDef, childKey));
                continue;
            }
            this.getSegments().add(new BeanTreePathSegment(this, childDef));
        }
        this.path.addPath(pathToAdd);
        return true;
    }

    private BeanChildDef findChild(BeanTypeDef typeDef, String childName) {
        Path childPath = new Path(childName);
        boolean searchSubTypes = true;
        if (typeDef.hasChildDef(childPath, searchSubTypes)) {
            return typeDef.getChildDef(childPath, searchSubTypes);
        }
        return null;
    }

    public String toString() {
        return "BeanTreePath<" + UrlUtils.pathToRelativeUri(this.getPath()) + ">";
    }

    public boolean isRoot() {
        return this.getSegments().isEmpty();
    }

    public boolean isCollection() {
        if (this.isRoot()) {
            return false;
        }
        if (!this.getLastSegment().getChildDef().isCollection()) {
            return false;
        }
        return !this.getLastSegment().isKeySet();
    }

    public boolean isCollectionChild() {
        if (this.isRoot()) {
            return false;
        }
        if (!this.getLastSegment().getChildDef().isCollection()) {
            return false;
        }
        return this.getLastSegment().isKeySet();
    }

    public boolean isOptionalSingleton() {
        if (this.isRoot()) {
            return false;
        }
        return this.getLastSegment().getChildDef().isOptionalSingleton();
    }

    public boolean isMandatorySingleton() {
        if (this.isRoot()) {
            return false;
        }
        return this.getLastSegment().getChildDef().isMandatorySingleton();
    }

    public boolean isCreatable() {
        if (this.isRoot()) {
            return false;
        }
        if (this.isCollection() || this.isOptionalSingleton()) {
            return this.getLastSegment().getChildDef().isCreatable();
        }
        return false;
    }

    public boolean isAsyncCreate() {
        if (this.isRoot()) {
            return false;
        }
        if (this.isCollection() || this.isOptionalSingleton()) {
            return this.getLastSegment().getChildDef().isAsyncCreate();
        }
        return false;
    }

    public boolean isDeletable() {
        if (this.isRoot()) {
            return false;
        }
        return this.getLastSegment().getChildDef().isDeletable();
    }

    public boolean isAsyncDelete() {
        if (this.isRoot()) {
            return false;
        }
        if (this.isCollectionChild() || this.isOptionalSingleton()) {
            return this.getLastSegment().getChildDef().isAsyncDelete();
        }
        return false;
    }

    public boolean isEditable() {
        if (this.isRoot()) {
            return false;
        }
        if (this.isCollection()) {
            return false;
        }
        return this.getLastSegment().getChildDef().isEditable();
    }

    public BeanTypeDef getTypeDef() {
        if (this.isRoot()) {
            return this.getBeanRepo().getBeanRepoDef().getRootTypeDef();
        }
        return this.getLastSegment().getChildDef().getChildTypeDef();
    }

    public BeanTreePathSegment getLastSegment() {
        return this.isRoot() ? null : this.getSegments().get(this.getSegments().size() - 1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (BeanTreePath.class.isInstance(obj)) {
            BeanTreePath bp = (BeanTreePath)BeanTreePath.class.cast(obj);
            return this.getPath().equals((Object)bp.getPath());
        }
        return false;
    }
}

