/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.TreeMap;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.Value;

public interface BeanSearchResults {
    public BeanReaderRepoSearchResults getSearchResults();

    public BeanTreePath getBeanTreePath();

    public Value getUnsortedValue(BeanPropertyDef var1);

    default public Value getValue(BeanPropertyDef propertyDef) {
        Value unsorted = this.getUnsortedValue(propertyDef);
        if (unsorted == null) {
            return null;
        }
        if (!propertyDef.isArray() || !propertyDef.isReference()) {
            return unsorted;
        }
        if (propertyDef.isReferenceAsReferences()) {
            return unsorted;
        }
        Value unsortedValue = Value.unsettableValue(unsorted);
        if (unsortedValue.isUnknown()) {
            return unsorted;
        }
        if (unsortedValue.isModelToken()) {
            return unsorted;
        }
        ArrayValue unsortedArray = unsortedValue.asArray();
        if (unsortedArray.getValues().size() < 2) {
            return unsorted;
        }
        TreeMap<String, Value> sorter = new TreeMap<String, Value>();
        for (Value value : Value.unsettableValue(unsorted).asArray().getValues()) {
            String sortingKey = null;
            if (value.isBeanTreePath()) {
                sortingKey = value.asBeanTreePath().toString();
            } else if (value.isUnresolvedReference()) {
                sortingKey = value.asUnresolvedReference().getKey();
            } else if (value.isModelToken()) {
                sortingKey = value.asModelToken().getToken();
            } else if (value.isNullReference()) {
                sortingKey = "None";
            } else {
                throw new AssertionError((Object)("Array of references child is not a bean tree path, model token, unresolved or null reference: " + String.valueOf(propertyDef) + " " + String.valueOf(value)));
            }
            sorter.put(sortingKey, value);
        }
        ArrayList<Value> sortedRefs = new ArrayList<Value>();
        for (Value refValue : sorter.values()) {
            sortedRefs.add(refValue);
        }
        ArrayValue arrayValue = new ArrayValue(sortedRefs);
        if (unsorted.isSettable()) {
            return new SettableValue((Value)arrayValue, unsorted.asSettable().getState());
        }
        return arrayValue;
    }
}

