/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.server.repo.BeanActionArg;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.Value;

public interface BeanReaderRepo
extends BeanRepo {
    public BeanReaderRepoSearchBuilder createSearchBuilder(InvocationContext var1, boolean var2);

    default public Response<Value> invokeAction(InvocationContext ic, BeanTreePath beanPath, BeanActionDef actionDef, List<BeanActionArg> args) {
        throw new AssertionError((Object)("unsupported action: " + String.valueOf(actionDef)));
    }

    default public Response<Value> invokeAction(InvocationContext ic, BeanActionDef actionDef, List<BeanActionArg> args) {
        return this.invokeAction(ic, ic.getBeanTreePath(), actionDef, args);
    }

    default public Response<Void> verifyExists(InvocationContext ic, BeanTreePath beanPath) {
        Response<Void> response = new Response<Void>();
        Response<Boolean> existsResponse = this.exists(ic, beanPath);
        if (!existsResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(existsResponse);
        }
        boolean exists = existsResponse.getResults();
        if (!exists) {
            return response.setNotFound();
        }
        return response;
    }

    default public Response<Void> verifyDoesntExist(InvocationContext ic, BeanTreePath beanPath) {
        Response<Void> response = new Response<Void>();
        Response<Boolean> existsResponse = this.exists(ic, beanPath);
        if (!existsResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(existsResponse);
        }
        boolean exists = existsResponse.getResults();
        if (exists) {
            response.addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.BEAN_ALREADY_EXISTS, UrlUtils.pathToRelativeUri(beanPath.getPath())));
            return response.setUserBadRequest();
        }
        return response;
    }

    default public Response<Boolean> exists(InvocationContext ic, BeanTreePath beanPath) {
        if (beanPath.isCollection()) {
            beanPath = BeanTreePath.create(beanPath.getBeanRepo(), beanPath.getPath().getParent());
        }
        Response<Boolean> response = new Response<Boolean>();
        BeanReaderRepoSearchBuilder builder = this.createSearchBuilder(ic, false);
        builder.addProperty(beanPath, beanPath.getTypeDef().getIdentityPropertyDef());
        Response<BeanReaderRepoSearchResults> searchResponse = builder.search();
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        boolean exists = searchResponse.getResults().getBean(beanPath) != null;
        return response.setSuccess(exists);
    }

    default public Response<Map<String, Value>> getBeanProperties(InvocationContext ic, List<String> propertyNames, boolean includeIsSet) {
        Response response = new Response();
        HashMap<String, BeanPropertyDef> propToPropDef = new HashMap<String, BeanPropertyDef>();
        HashMap<String, Value> propToValue = new HashMap<String, Value>();
        BeanReaderRepoSearchBuilder builder = this.createSearchBuilder(ic, includeIsSet);
        BeanTreePath btp = ic.getBeanTreePath();
        for (String propertyName : propertyNames) {
            Path propertyPath = new Path(propertyName);
            BeanPropertyDef propDef = btp.getTypeDef().getPropertyDef(propertyPath, true);
            if (propDef == null) continue;
            propToPropDef.put(propertyName, propDef);
            builder.addProperty(btp, propDef);
        }
        Response<BeanReaderRepoSearchResults> searchResponse = builder.search();
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        BeanSearchResults beanResults = searchResponse.getResults().getBean(btp);
        if (beanResults == null) {
            return response.setNotFound();
        }
        BeanReaderRepoSearchResults searchResults = searchResponse.getResults();
        for (String propertyName : propertyNames) {
            Value value;
            BeanPropertyDef propDef = (BeanPropertyDef)propToPropDef.get(propertyName);
            if (propDef == null || beanResults == null || (value = beanResults.getValue(propDef)) == null) continue;
            propToValue.put(propertyName, value);
        }
        return response.setSuccess(propToValue);
    }
}

