/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.List;
import weblogic.remoteconsole.common.repodef.DeleteBeanCustomizerDef;
import weblogic.remoteconsole.common.utils.CustomizerInvocationUtils;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.ConfigurationTransactionHelper;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PageManager;
import weblogic.remoteconsole.server.repo.PageReader;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.ResponseException;

class BeanDeleter
extends PageManager {
    BeanDeleter(InvocationContext invocationContext) {
        super(invocationContext);
    }

    public Response<Void> delete() {
        return ConfigurationTransactionHelper.editConfiguration(this.getInvocationContext(), new ConfigurationTransactionHelper.ConfigurationEditor(){

            @Override
            public Response<Void> editConfiguration() {
                return BeanDeleter.this.doDelete();
            }
        });
    }

    Response<Void> doDelete() {
        DeleteBeanCustomizerDef customizerDef = this.getInvocationContext().getBeanTreePath().getTypeDef().getDeleteCustomizerDef();
        if (customizerDef != null) {
            return this.customDelete(customizerDef);
        }
        return this.getBeanRepo().asBeanEditorRepo().deleteBean(this.getInvocationContext(), this.getInvocationContext().getBeanTreePath());
    }

    private Response<Void> customDelete(DeleteBeanCustomizerDef customizerDef) {
        BeanTreePath beanPath = this.getBeanTreePath();
        boolean includeIsSet = false;
        PageReader reader = new PageReader(this.getInvocationContext());
        BeanReaderRepoSearchBuilder builder = this.getBeanRepo().asBeanReaderRepo().createSearchBuilder(this.getInvocationContext(), includeIsSet);
        reader.addParamsToSearch(builder, beanPath, customizerDef);
        builder.addProperty(beanPath, beanPath.getTypeDef().getIdentityPropertyDef());
        Response<BeanReaderRepoSearchResults> searchResponse = builder.search();
        if (!searchResponse.isSuccess()) {
            return new Response().copyUnsuccessfulResponse(searchResponse);
        }
        BeanReaderRepoSearchResults searchResults = searchResponse.getResults();
        BeanSearchResults beanResults = searchResults.getBean(beanPath);
        Response<List<Object>> argsResponse = reader.getArguments(customizerDef, beanResults, searchResults, includeIsSet);
        if (!argsResponse.isSuccess()) {
            Response errorResponse = new Response();
            return errorResponse.copyUnsuccessfulResponse(argsResponse);
        }
        Response customizerResponse = new Response();
        try {
            Object rtn = CustomizerInvocationUtils.invokeMethod(customizerDef.getMethod(), argsResponse.getResults());
            return customizerResponse.setSuccess(null);
        }
        catch (ResponseException e) {
            return customizerResponse.copyUnsuccessfulResponse(e.getResponse());
        }
    }
}

