/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.utils.CustomizerInvocationUtils;
import weblogic.remoteconsole.server.repo.BeanActionArg;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.ConfigurationTransactionHelper;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PageReader;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.ResponseException;
import weblogic.remoteconsole.server.repo.Value;

class ActionInvoker
extends PageReader {
    private PageActionDef pageActionDef;
    private List<FormProperty> formProperties;
    private static final Type CUSTOMIZER_RESULTS_RETURN_TYPE = new TypeReference<Value>(){}.getType();
    private static final Type CUSTOMIZER_RESPONSE_RETURN_TYPE = new TypeReference<Response<Value>>(){}.getType();
    private static final Type FORM_PROPERTIES_TYPE = new TypeReference<List<FormProperty>>(){}.getType();

    ActionInvoker(InvocationContext invocationContext, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        super(invocationContext);
        this.pageActionDef = pageActionDef;
        this.formProperties = formProperties;
    }

    Response<Void> invokeAction() {
        String impact = this.pageActionDef.getImpact();
        if ("action".equals(impact) || "action_info".equals(impact)) {
            return ConfigurationTransactionHelper.editConfiguration(this.getInvocationContext(), new ConfigurationTransactionHelper.ConfigurationEditor(){

                @Override
                public Response<Void> editConfiguration() {
                    return ActionInvoker.this.doInvokeAction();
                }
            });
        }
        return this.doInvokeAction();
    }

    private Response<Void> doInvokeAction() {
        Response<Void> response = new Response<Void>();
        Response<Value> invokeResponse = null;
        Response<PageDef> pageDefResponse = this.getPageDef();
        if (!pageDefResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(pageDefResponse);
        }
        PageDef pageDef = pageDefResponse.getResults();
        invokeResponse = StringUtils.isEmpty((String)this.pageActionDef.getActionMethod()) ? this.standardInvokeAction() : this.customInvokeAction();
        if (!invokeResponse.isSuccess()) {
            this.addFailureMessage(response);
            response.copyUnsuccessfulResponse(invokeResponse, true);
            return response;
        }
        this.addSuccessMessage(response);
        response.copyMessages(invokeResponse);
        return response;
    }

    private void addFailureMessage(Response response) {
        LocalizableString message = this.pageActionDef.getFailureMessage();
        if (message == null) {
            return;
        }
        response.addFailureMessage(this.getInvocationContext().getLocalizer().localizeString(message, this.getBeanName()));
    }

    private void addSuccessMessage(Response response) {
        LocalizableString message = this.pageActionDef.getSuccessMessage();
        if (message == null) {
            return;
        }
        response.addSuccessMessage(this.getInvocationContext().getLocalizer().localizeString(message, this.getBeanName()));
    }

    private String getBeanName() {
        BeanTreePath btp = this.getInvocationContext().getBeanTreePath();
        List<BeanTreePathSegment> segments = btp.getSegments();
        for (int i = segments.size() - 1; i >= 0; --i) {
            BeanTreePathSegment segment = segments.get(i);
            if (!segment.isKeySet()) continue;
            return segment.getKey();
        }
        return "";
    }

    private Response<Value> standardInvokeAction() {
        ArrayList<BeanActionArg> args = new ArrayList<BeanActionArg>();
        for (FormProperty formProperty : this.formProperties) {
            args.add(new BeanActionArg(formProperty.getFieldDef().asBeanActionParamDef(), formProperty.getValue().asSettable().getValue()));
        }
        return this.getInvocationContext().getPageRepo().getBeanRepo().asBeanReaderRepo().invokeAction(this.getInvocationContext(), this.pageActionDef, args);
    }

    private Response<Value> customInvokeAction() {
        Method method;
        boolean returnsResponse = CustomizerInvocationUtils.isReturnType(method = CustomizerInvocationUtils.getMethod(this.pageActionDef.getActionMethod()), CUSTOMIZER_RESPONSE_RETURN_TYPE);
        CustomizerInvocationUtils.checkSignature(method, returnsResponse ? CUSTOMIZER_RESPONSE_RETURN_TYPE : CUSTOMIZER_RESULTS_RETURN_TYPE, new Type[]{InvocationContext.class, PageActionDef.class, FORM_PROPERTIES_TYPE});
        Response response = new Response();
        try {
            Object rtn = CustomizerInvocationUtils.invokeMethod(method, List.of(this.getInvocationContext(), this.pageActionDef, this.formProperties));
            if (returnsResponse) {
                response = (Response)rtn;
            } else {
                Value results = (Value)rtn;
                response.setSuccess(results);
            }
            return response;
        }
        catch (ResponseException re) {
            return response.copyUnsuccessfulResponse(re.getResponse());
        }
    }
}

