/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.providers;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.yaml.snakeyaml.Yaml;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersions;
import weblogic.remoteconsole.common.utils.WebLogicVersion;
import weblogic.remoteconsole.common.utils.WebLogicVersions;
import weblogic.remoteconsole.server.providers.PropertyListDataProvider;
import weblogic.remoteconsole.server.providers.ProviderManager;
import weblogic.remoteconsole.server.providers.Root;
import weblogic.remoteconsole.server.providers.WDTModelDataProvider;
import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.DownloadBeanRepo;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PageRepo;
import weblogic.remoteconsole.server.repo.weblogic.WDTCapabilities;
import weblogic.remoteconsole.server.repo.weblogic.WDTModelBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WDTModelSchema;
import weblogic.remoteconsole.server.repo.weblogic.WDTPageRepo;
import weblogic.remoteconsole.server.webapp.FailedRequestException;

public class WDTModelDataProviderImpl
implements WDTModelDataProvider {
    private static final Logger LOGGER = Logger.getLogger(WDTModelDataProviderImpl.class.getName());
    public static final String TYPE_NAME = "WDTModel";
    private String name;
    private String label;
    private String lastMessage = null;
    private Map<String, Object> model = null;
    private Map<String, Root> roots = new HashMap<String, Root>();
    private Root editRoot;
    private boolean isJson = false;
    private List<String> propertyListNames = null;
    private ProviderManager pm = null;

    public WDTModelDataProviderImpl(String name, String label) {
        this.name = name;
        this.label = label;
        this.editRoot = new Root(this, "edit", "DomainConfiguration", Root.EDIT_LABEL, false, "navtree", "simpleSearch", "download");
        this.roots.put("edit", this.editRoot);
    }

    @Override
    public void parseModel(InputStream is, boolean isJson, InvocationContext ic) {
        try {
            this.isJson = isJson;
            Object parsedModel = new Yaml().load(is);
            this.model = this.getAcceptableModel(parsedModel, ic);
            this.test(ic);
        }
        catch (FailedRequestException fre) {
            throw fre;
        }
        catch (Exception e) {
            Throwable walk = e;
            while (walk.getCause() != null) {
                walk = walk.getCause();
            }
            this.lastMessage = walk.getMessage();
            if (this.lastMessage == null) {
                System.err.println("The exception " + String.valueOf(walk) + "(" + String.valueOf(walk.getClass()) + ") has no message");
            }
            throw new FailedRequestException(this.toJSON(ic));
        }
        if (this.model == null) {
            throw new FailedRequestException(this.toJSON(ic));
        }
    }

    @Override
    public Map<String, Object> getModel(InvocationContext ic) {
        PageRepo pageRepo = this.editRoot.getPageRepo();
        if (pageRepo == null) {
            return this.model;
        }
        BeanRepo beanRepo = pageRepo.getBeanRepo();
        if (!(beanRepo instanceof DownloadBeanRepo)) {
            return this.model;
        }
        return ((DownloadBeanRepo)((Object)beanRepo)).getContent(ic);
    }

    @Override
    public void setPropertyListProviders(List<String> propertyListNames, ProviderManager pm) {
        this.pm = pm;
        this.propertyListNames = propertyListNames;
    }

    @Override
    public List<WDTModelDataProvider.PropertySource> getPropertySources() {
        if (this.propertyListNames == null) {
            return null;
        }
        ArrayList dataProviders = new ArrayList(this.propertyListNames.size());
        this.propertyListNames.forEach(name -> {
            boolean added;
            PropertyListDataProvider dataProvider = (PropertyListDataProvider)this.pm.getProvider((String)name, "PropertyList");
            boolean bl = added = dataProvider != null ? dataProviders.add(dataProvider) : false;
            if (!added) {
                LOGGER.finest("WDTModelDataProviderImpl unable to find Property List provider: " + name);
            }
        });
        if (dataProviders.isEmpty()) {
            return null;
        }
        ArrayList<WDTModelDataProvider.PropertySource> propertySources = new ArrayList<WDTModelDataProvider.PropertySource>(dataProviders.size());
        dataProviders.forEach(provider -> propertySources.add(new PropertySourceImpl(provider.getName(), provider.getResourceData(), provider.getProperties())));
        LOGGER.finest("WDTModelDataProviderImpl obtained Property Sources from: " + String.valueOf(this.propertyListNames));
        return propertySources;
    }

    @Override
    public boolean isJson() {
        return this.isJson;
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    private static JsonObject makeHelpClause(InvocationContext ic, LocalizableString summary, LocalizableString detail) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("helpSummaryHTML", ic.getLocalizer().localizeString(summary, new Object[0]));
        ret.add("helpDetailHTML", ic.getLocalizer().localizeString(detail, new Object[0]));
        return ret.build();
    }

    public static JsonObject getHelp(InvocationContext ic) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("name", (JsonValue)WDTModelDataProviderImpl.makeHelpClause(ic, LocalizedConstants.DATA_PROVIDER_HELP_NAME_SUMMARY, LocalizedConstants.DATA_PROVIDER_HELP_NAME_DETAIL));
        ret.add("file", (JsonValue)WDTModelDataProviderImpl.makeHelpClause(ic, LocalizedConstants.WDT_PROVIDER_HELP_FILE_SUMMARY, LocalizedConstants.WDT_PROVIDER_HELP_FILE_DETAIL));
        return ret.build();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void terminate() {
    }

    @Override
    public void test(InvocationContext ic) {
        this.start(ic);
    }

    @Override
    public boolean start(InvocationContext ic) {
        ic.setProvider(this);
        if (this.editRoot.getPageRepo() == null) {
            if (this.model == null) {
                throw new FailedRequestException(this.getNoModelMessage(ic));
            }
            WebLogicVersion weblogicVersion = WebLogicVersions.getLatestVersion();
            this.editRoot.setPageRepo(new WDTPageRepo(WebLogicMBeansVersions.getVersion(weblogicVersion, WDTCapabilities.getCapabilities(weblogicVersion)), this.model, ic));
            this.lastMessage = null;
        }
        return true;
    }

    private Map<String, Object> getAcceptableModel(Object parsedModel, InvocationContext ic) {
        Map result = null;
        if (parsedModel instanceof Map) {
            Map parsed = (Map)parsedModel;
            boolean validModel = parsed.entrySet().stream().anyMatch(entry -> WDTModelSchema.KNOWN_SECTIONS.contains(entry.getKey()));
            Map map = result = validModel ? parsed : null;
        }
        if (result == null) {
            this.lastMessage = this.getNoModelMessage(ic);
        }
        return result;
    }

    private String getNoModelMessage(InvocationContext ic) {
        return this.lastMessage != null ? this.lastMessage : ic.getLocalizer().localizeString(LocalizedConstants.MODEL_INVALID, WDTModelSchema.KNOWN_SECTIONS);
    }

    @Override
    public Map<String, Root> getRoots() {
        return this.roots;
    }

    @Override
    public JsonObject toJSON(InvocationContext ic) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("name", this.getName());
        if (this.getLabel() != null && !this.getName().equals(this.getLabel())) {
            ret.add("label", this.getLabel());
        }
        ret.add("providerType", this.getType());
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Root root : this.getRoots().values()) {
            builder.add((JsonValue)root.toJSON(ic));
        }
        ret.add("roots", builder);
        ret.add("mode", "standalone");
        if (this.propertyListNames != null) {
            JsonArrayBuilder props = Json.createArrayBuilder();
            this.propertyListNames.forEach(arg_0 -> ((JsonArrayBuilder)props).add(arg_0));
            ret.add("propertyLists", props);
        }
        if (this.lastMessage != null) {
            ret.add("messages", this.createMessages(this.lastMessage));
        }
        return ret.build();
    }

    @Override
    public boolean isValidPath(String path) {
        return WDTModelBuilder.isValidPath(path);
    }

    private class PropertySourceImpl
    implements WDTModelDataProvider.PropertySource {
        private String name;
        private String resoruceData;
        private Properties properties;

        private PropertySourceImpl(String name, String resoruceData, Properties properties) {
            this.name = name;
            this.resoruceData = resoruceData;
            this.properties = properties;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getResourceData() {
            return this.resoruceData;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }
    }
}

