/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersions;
import weblogic.remoteconsole.common.utils.WebLogicVersion;
import weblogic.remoteconsole.common.utils.WebLogicVersions;
import weblogic.remoteconsole.server.providers.ProviderManager;
import weblogic.remoteconsole.server.providers.Root;
import weblogic.remoteconsole.server.providers.WDTCompositeDataProvider;
import weblogic.remoteconsole.server.providers.WDTModelDataProvider;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.weblogic.WDTCapabilities;
import weblogic.remoteconsole.server.repo.weblogic.WDTCompositePageRepo;
import weblogic.remoteconsole.server.repo.weblogic.WDTModelBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WDTModelSchema;
import weblogic.remoteconsole.server.webapp.FailedRequestException;

public class WDTCompositeDataProviderImpl
implements WDTCompositeDataProvider {
    private static final Logger LOGGER = Logger.getLogger(WDTCompositeDataProviderImpl.class.getName());
    public static final String TYPE_NAME = "WDTCompositeModel";
    private String name;
    private String label;
    private List<String> modelNames;
    private ProviderManager pm;
    private String lastMessage = null;
    private String lastProviderNoModel = null;
    private List<Map<String, Object>> models = null;
    private Map<String, Root> roots = new HashMap<String, Root>();
    private Root viewRoot;

    public WDTCompositeDataProviderImpl(String name, String label, List<String> modelNames, ProviderManager pm) {
        this.name = name;
        this.label = label;
        this.modelNames = modelNames;
        this.pm = pm;
        this.viewRoot = new Root(this, "compositeConfig", "DomainConfiguration", Root.COMPOSITE_CONFIGURATION_LABEL, true, "navtree", "simpleSearch");
        this.roots.put("compositeConfig", this.viewRoot);
    }

    @Override
    public void checkModels(InvocationContext ic) {
        this.lastProviderNoModel = null;
        this.models = this.getCurrentModels(ic);
        if (this.lastProviderNoModel != null) {
            this.models = null;
            throw new FailedRequestException(this.getNoModelMessage(ic));
        }
    }

    @Override
    public List<Map<String, Object>> getModels() {
        return this.models;
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    private static JsonObject makeHelpClause(InvocationContext ic, LocalizableString summary, LocalizableString detail) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("helpSummaryHTML", ic.getLocalizer().localizeString(summary, new Object[0]));
        ret.add("helpDetailHTML", ic.getLocalizer().localizeString(detail, new Object[0]));
        return ret.build();
    }

    public static JsonObject getHelp(InvocationContext ic) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("name", (JsonValue)WDTCompositeDataProviderImpl.makeHelpClause(ic, LocalizedConstants.DATA_PROVIDER_HELP_NAME_SUMMARY, LocalizedConstants.DATA_PROVIDER_HELP_NAME_DETAIL));
        ret.add("file", (JsonValue)WDTCompositeDataProviderImpl.makeHelpClause(ic, LocalizedConstants.WDT_COMPOSITE_PROVIDER_HELP_MODELS_SUMMARY, LocalizedConstants.WDT_COMPOSITE_PROVIDER_HELP_MODELS_DETAIL));
        return ret.build();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void terminate() {
    }

    @Override
    public void test(InvocationContext ic) {
        this.start(ic);
    }

    @Override
    public boolean start(InvocationContext ic) {
        boolean sameLength;
        ic.setProvider(this);
        if (this.models == null) {
            throw new FailedRequestException(this.getNoModelMessage(ic));
        }
        List<Map<String, Object>> currentModels = this.getCurrentModels(ic);
        boolean bl = sameLength = this.models.size() == currentModels.size();
        if (!sameLength || !IntStream.range(0, this.models.size()).allMatch(i -> this.models.get(i) == currentModels.get(i))) {
            LOGGER.fine("WDTCompositeDataProvider: WDT models updated for the WDT composite: " + this.name);
            this.models = currentModels;
            this.setPageRepo(ic);
            return true;
        }
        if (this.viewRoot.getPageRepo() == null) {
            this.setPageRepo(ic);
        }
        return true;
    }

    private void setPageRepo(InvocationContext ic) {
        WebLogicVersion weblogicVersion = WebLogicVersions.getLatestVersion();
        this.viewRoot.setPageRepo(new WDTCompositePageRepo(WebLogicMBeansVersions.getVersion(weblogicVersion, WDTCapabilities.getCapabilities(weblogicVersion)), this.models, ic));
    }

    private List<Map<String, Object>> getCurrentModels(InvocationContext ic) {
        ArrayList wdtProviders = new ArrayList(this.modelNames.size());
        this.modelNames.forEach(name -> {
            boolean added;
            WDTModelDataProvider provider = (WDTModelDataProvider)this.pm.getProvider((String)name, "WDTModel");
            boolean bl = added = provider != null ? wdtProviders.add(provider) : false;
            if (!added) {
                LOGGER.finest("WDTCompositeDataProvider unable to find WDT model provider: " + name);
                this.lastProviderNoModel = " (" + name + ")";
            }
        });
        ArrayList<Map<String, Object>> wdtModels = new ArrayList<Map<String, Object>>(wdtProviders.size());
        wdtProviders.forEach(provider -> {
            boolean added;
            Map<String, Object> model = provider.getModel(ic);
            boolean bl = added = model != null ? wdtModels.add(model) : false;
            if (!added) {
                LOGGER.finest("WDTCompositeDataProvider unable to get WDT model: " + provider.getName());
                this.lastProviderNoModel = " (" + provider.getName() + ")";
            }
        });
        return wdtModels;
    }

    private String getNoModelMessage(InvocationContext ic) {
        Object result = ic.getLocalizer().localizeString(LocalizedConstants.MODEL_INVALID, WDTModelSchema.KNOWN_SECTIONS);
        this.lastMessage = result = (String)result + (this.lastProviderNoModel != null ? this.lastProviderNoModel : "");
        return result;
    }

    @Override
    public Map<String, Root> getRoots() {
        return this.roots;
    }

    @Override
    public JsonObject toJSON(InvocationContext ic) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("name", this.getName());
        if (this.getLabel() != null && !this.getName().equals(this.getLabel())) {
            ret.add("label", this.getLabel());
        }
        ret.add("providerType", this.getType());
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Root root : this.getRoots().values()) {
            builder.add((JsonValue)root.toJSON(ic));
        }
        ret.add("roots", builder);
        ret.add("mode", "standalone");
        if (this.modelNames != null) {
            JsonArrayBuilder models = Json.createArrayBuilder();
            this.modelNames.forEach(arg_0 -> ((JsonArrayBuilder)models).add(arg_0));
            ret.add("modelNames", models);
        }
        if (this.lastMessage != null) {
            ret.add("messages", this.createMessages(this.lastMessage));
        }
        return ret.build();
    }

    @Override
    public boolean isValidPath(String path) {
        return WDTModelBuilder.isValidPath(path);
    }
}

