/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceContext;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.server.ConsoleBackendRuntime;
import weblogic.remoteconsole.server.PersistenceManager;
import weblogic.remoteconsole.server.providers.AdminServerDataProvider;
import weblogic.remoteconsole.server.providers.AdminServerDataProviderImpl;
import weblogic.remoteconsole.server.providers.PropertyListDataProvider;
import weblogic.remoteconsole.server.providers.PropertyListDataProviderImpl;
import weblogic.remoteconsole.server.providers.Provider;
import weblogic.remoteconsole.server.providers.WDTCompositeDataProvider;
import weblogic.remoteconsole.server.providers.WDTCompositeDataProviderImpl;
import weblogic.remoteconsole.server.providers.WDTModelDataProvider;
import weblogic.remoteconsole.server.providers.WDTModelDataProviderImpl;
import weblogic.remoteconsole.server.repo.Frontend;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.token.SsoTokenManager;

public class ProviderManager {
    private static final Logger LOGGER = Logger.getLogger(ProviderManager.class.getName());
    private static final SsoTokenManager SSO_TOKEN_MANAGER = ConsoleBackendRuntime.INSTANCE.getSsoTokenManager();
    private Map<String, Provider> providers = new ConcurrentHashMap<String, Provider>();
    private List<Provider> orderedList = new LinkedList<Provider>();

    public AdminServerDataProvider createAdminServerDataProvider(String name, String label, String url, String authorizationHeader, boolean useSso, boolean local) {
        LOGGER.finest("Create AdminServerDataProvider " + name + " " + label);
        String auth = useSso ? null : authorizationHeader;
        AdminServerDataProviderImpl ret = new AdminServerDataProviderImpl(this, name, label, url, auth, local);
        ret.setSsoTokenId(useSso ? SSO_TOKEN_MANAGER.add(ret) : null);
        this.putProvider(name, ret);
        return ret;
    }

    private void putProvider(String name, Provider provider) {
        if (this.providers.put(name, provider) == null) {
            this.orderedList.add(provider);
        }
    }

    private void removeProvider(String name) {
        this.orderedList.remove(this.providers.remove(name));
    }

    public PropertyListDataProvider createPropertyListDataProvider(String name, String label) {
        LOGGER.finest("Create PropertyListDataProvider " + name + " " + label);
        PropertyListDataProviderImpl ret = new PropertyListDataProviderImpl(name, label);
        this.putProvider(name, ret);
        return ret;
    }

    public WDTModelDataProvider createWDTModelDataProvider(String name, String label) {
        LOGGER.finest("Create WDTModelDataProvider " + name + " " + label);
        WDTModelDataProviderImpl ret = new WDTModelDataProviderImpl(name, label);
        this.putProvider(name, ret);
        return ret;
    }

    public WDTCompositeDataProvider createWDTCompositeDataProvider(String name, String label, List<String> models) {
        LOGGER.finest("Create WDTCompositeDataProvider" + name + " " + label);
        WDTCompositeDataProviderImpl ret = new WDTCompositeDataProviderImpl(name, label, models, this);
        this.putProvider(name, ret);
        return ret;
    }

    public boolean hasProvider(String name) {
        return this.providers.containsKey(name);
    }

    public boolean hasProvider(String name, String type) {
        return this.providers.containsKey(name) ? this.providers.get(name).getType().equals(type) : false;
    }

    public Provider getProvider(String name, String type) {
        Provider provider = this.providers.get(name);
        return provider != null && provider.getType().equals(type) ? provider : null;
    }

    public void terminate() {
        this.terminateAllProviders();
    }

    public void terminateAllProviders() {
        for (Provider prov : this.providers.values()) {
            prov.terminate();
        }
        this.providers.clear();
        this.orderedList.clear();
    }

    public void deleteProvider(String name) {
        LOGGER.finest("Delete provider " + name + this.providers.get(name).getLabel());
        this.removeSsoToken(name);
        this.terminateProvider(name);
        this.removeProvider(name);
    }

    public void terminateProvider(String name) {
        LOGGER.finest("Terminate provider " + name + this.providers.get(name).getLabel());
        this.providers.get(name).terminate();
    }

    public void testProvider(String name, InvocationContext ic) {
        this.providers.get(name).test(ic);
    }

    public boolean startProvider(String name, InvocationContext ic) {
        Provider provider = this.providers.get(name);
        boolean connected = this.isProviderConnected(provider);
        boolean started = provider.start(ic);
        if (started && !connected) {
            this.removeSsoToken(name);
        }
        return started;
    }

    public void removeSsoToken(String name) {
        AdminServerDataProvider provider = (AdminServerDataProvider)this.getProvider(name, "AdminServerConnection");
        if (provider != null) {
            SSO_TOKEN_MANAGER.remove(provider);
        }
    }

    private boolean isProviderConnected(Provider provider) {
        boolean result = true;
        if (provider instanceof AdminServerDataProvider) {
            result = ((AdminServerDataProvider)provider).isConnected();
        }
        return result;
    }

    public static ProviderManager getFromContext(ResourceContext context) {
        return Frontend.getFromContext((ContainerRequestContext)context.getResource(ContainerRequestContext.class)).getProviderManager();
    }

    public Collection<Provider> getAll() {
        return this.orderedList;
    }

    public static JsonArray getAllHelp(InvocationContext ic) {
        JsonArrayBuilder ret = Json.createArrayBuilder();
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("type", "AdminServerConnection");
        objectBuilder.add("help", (JsonValue)AdminServerDataProviderImpl.getHelp(ic));
        ret.add((JsonValue)objectBuilder.build());
        objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("type", "WDTModel");
        objectBuilder.add("help", (JsonValue)WDTModelDataProviderImpl.getHelp(ic));
        ret.add((JsonValue)objectBuilder.build());
        objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("type", "WDTCompositeModel");
        objectBuilder.add("help", (JsonValue)WDTCompositeDataProviderImpl.getHelp(ic));
        ret.add((JsonValue)objectBuilder.build());
        objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("type", "PropertyList");
        objectBuilder.add("help", (JsonValue)PropertyListDataProviderImpl.getHelp(ic));
        ret.add((JsonValue)objectBuilder.build());
        return ret.build();
    }

    public JsonObject getJSON(String name, InvocationContext ic) {
        return this.providers.get(name).toJSON(ic);
    }

    private static JsonObject genDefaultProvider(InvocationContext ic) {
        JsonObjectBuilder provBuilder = Json.createObjectBuilder();
        provBuilder.add("name", ic.getLocalizer().localizeString(LocalizedConstants.DEFAULT_HOSTED_PROVIDER_NAME, new Object[0]));
        provBuilder.add("type", "adminserver");
        provBuilder.add("url", ic.getUriInfo().getRequestUri().getScheme() + "://" + ic.getUriInfo().getRequestUri().getHost() + ":" + ic.getUriInfo().getRequestUri().getPort());
        JsonObjectBuilder settingsBuilder = Json.createObjectBuilder();
        settingsBuilder.add("local", true);
        provBuilder.add("settings", (JsonValue)settingsBuilder.build());
        return provBuilder.build();
    }

    public static JsonObject genDefaultProject(InvocationContext ic) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("name", "Hosted WebLogic Remote Console");
        JsonArrayBuilder childrenBuilder = Json.createArrayBuilder();
        childrenBuilder.add((JsonValue)ProviderManager.genDefaultProvider(ic));
        JsonArray otherProviders = ProviderManager.loadOtherProviders(ic);
        if (otherProviders != null) {
            for (JsonValue walk : otherProviders) {
                childrenBuilder.add(walk);
            }
        }
        builder.add("dataProviders", (JsonValue)childrenBuilder.build());
        builder.add("current", true);
        return builder.build();
    }

    private static JsonObject convertToPersistenceFormat(Provider prov, InvocationContext ic) {
        JsonObject settings;
        JsonObject provJSON = prov.toJSON(ic);
        JsonObjectBuilder provBuilder = Json.createObjectBuilder();
        if (provJSON.get((Object)"label") != null) {
            provBuilder.add("name", provJSON.getString("label"));
        } else {
            provBuilder.add("name", provJSON.getString("name"));
        }
        if ("AdminServerConnection".equals(provJSON.getString("providerType"))) {
            provBuilder.add("type", "adminserver");
        } else if ("WDTModel".equals(provJSON.getString("providerType"))) {
            provBuilder.add("type", "model");
        } else if ("WDTCompositeModel".equals(provJSON.getString("providerType"))) {
            provBuilder.add("type", "composite");
        } else if ("PropertyList".equals(provJSON.getString("providerType"))) {
            provBuilder.add("type", "properties");
        } else {
            provBuilder.add("type", provJSON.getString("providerType"));
        }
        if (provJSON.get((Object)"domainUrl") != null) {
            provBuilder.add("url", provJSON.getString("domainUrl"));
        }
        if (provJSON.get((Object)"username") != null) {
            provBuilder.add("username", provJSON.getString("username"));
        }
        if (provJSON.get((Object)"file") != null) {
            provBuilder.add("file", provJSON.getString("file"));
        }
        if (provJSON.get((Object)"models") != null) {
            JsonArrayBuilder modelBuilder = Json.createArrayBuilder();
            for (JsonString walk : provJSON.getJsonArray("models").getValuesAs(JsonString.class)) {
                modelBuilder.add(walk.getString());
            }
            provBuilder.add("models", (JsonValue)modelBuilder.build());
        }
        if (provJSON.get((Object)"propertyLists") != null) {
            JsonArrayBuilder propertyListBuilder = Json.createArrayBuilder();
            for (JsonString walk : provJSON.getJsonArray("propertyLists").getValuesAs(JsonString.class)) {
                propertyListBuilder.add(walk.getString());
            }
            provBuilder.add("propertyLists", (JsonValue)propertyListBuilder.build());
        }
        JsonObjectBuilder settingsBuilder = Json.createObjectBuilder();
        if (provJSON.get((Object)"sso") != null) {
            settingsBuilder.add("sso", provJSON.getBoolean("sso"));
        }
        if (provJSON.get((Object)"local") != null) {
            settingsBuilder.add("local", provJSON.getBoolean("local"));
        }
        if (provJSON.get((Object)"insecure") != null) {
            settingsBuilder.add("insecure", provJSON.getBoolean("insecure"));
        }
        if (provJSON.get((Object)"proxyOverride") != null) {
            settingsBuilder.add("proxyOverride", provJSON.getString("proxyOverride"));
        }
        if (!(settings = settingsBuilder.build()).isEmpty()) {
            provBuilder.add("settings", (JsonValue)settings);
        }
        return provBuilder.build();
    }

    private static boolean isProviderLocal(Provider prov) {
        if (prov instanceof AdminServerDataProvider) {
            return ((AdminServerDataProvider)prov).isLocal();
        }
        return false;
    }

    private JsonArray getJSONOtherConfiguredProviders(InvocationContext ic) {
        JsonArrayBuilder childrenBuilder = Json.createArrayBuilder();
        boolean foundOne = false;
        for (Provider prov : this.orderedList) {
            if (ProviderManager.isProviderLocal(prov)) continue;
            foundOne = true;
            childrenBuilder.add((JsonValue)ProviderManager.convertToPersistenceFormat(prov, ic));
        }
        if (!foundOne) {
            return null;
        }
        return childrenBuilder.build();
    }

    public void save(InvocationContext ic) {
        if (!PersistenceManager.shouldIPersistProjects(ic)) {
            return;
        }
        String path = PersistenceManager.getPersistenceFilePath(ic);
        if (path == null) {
            return;
        }
        String fullPath = path + "/user-projects.json";
        JsonArray other = this.getJSONOtherConfiguredProviders(ic);
        if (other == null) {
            new File(fullPath).delete();
            return;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("name", "Hosted WebLogic Remote Console");
        builder.add("label", "Hosted WebLogic Remote Console");
        builder.add("dataProviders", (JsonValue)other);
        builder.add("current", true);
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writerWithDefaultPrettyPrinter().writeValue(new File(fullPath), mapper.readValue(builder.build().toString(), Object.class));
        }
        catch (Throwable t) {
            LOGGER.severe("Problem writing " + fullPath + ": " + t.getMessage());
        }
    }

    private static JsonArray loadOtherProviders(InvocationContext ic) {
        JsonArray jsonArray;
        String path = PersistenceManager.getPersistenceFilePath(ic);
        if (path == null) {
            return null;
        }
        String fullPath = path + "/user-projects.json";
        if (!new File(fullPath).exists()) {
            return null;
        }
        FileInputStream is = new FileInputStream(fullPath);
        try {
            JsonObject in = Json.createReader((InputStream)is).readObject();
            jsonArray = in.getJsonArray("dataProviders");
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                LOGGER.severe("Problem reading " + fullPath + ": " + t.getMessage());
                return null;
            }
        }
        is.close();
        return jsonArray;
    }
}

