/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.providers;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.server.providers.PropertyListDataProvider;
import weblogic.remoteconsole.server.providers.Root;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.webapp.FailedRequestException;

public class PropertyListDataProviderImpl
implements PropertyListDataProvider {
    public static final String TYPE_NAME = "PropertyList";
    private String name;
    private String label;
    private String pageDescription;
    private String resourceData;
    private String lastMessage = null;
    private Properties properties = new Properties();
    private Map<String, Root> roots = new HashMap<String, Root>();
    private Root editRoot;

    public PropertyListDataProviderImpl(String name, String label) {
        this.name = name;
        this.label = label;
        this.editRoot = new Root(this, "propertyList", "DomainConfiguration", Root.PROPERTY_LIST_CONFIGURATION_LABEL, false, "navtree", "download");
        this.roots.put("propertyList", this.editRoot);
        this.resourceData = "/api/" + UrlUtils.urlEncode(name) + "/propertyList/data/Properties";
        this.pageDescription = "/api/" + UrlUtils.urlEncode(name) + "/propertyList/pages/Properties";
    }

    @Override
    public String getPageDescription() {
        return this.pageDescription;
    }

    @Override
    public String getResourceData() {
        return this.resourceData;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void parse(InputStream is, InvocationContext ic) {
        try {
            this.properties.load(is);
        }
        catch (Exception e) {
            Throwable walk = e;
            while (walk.getCause() != null) {
                walk = walk.getCause();
            }
            this.lastMessage = walk.getMessage();
            if (this.lastMessage == null) {
                System.err.println("The exception " + String.valueOf(walk) + "(" + String.valueOf(walk.getClass()) + ") has no message");
            }
            throw new FailedRequestException(this.toJSON(ic));
        }
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    private static JsonObject makeHelpClause(InvocationContext ic, LocalizableString summary, LocalizableString detail) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("helpSummaryHTML", ic.getLocalizer().localizeString(summary, new Object[0]));
        ret.add("helpDetailHTML", ic.getLocalizer().localizeString(detail, new Object[0]));
        return ret.build();
    }

    public static JsonObject getHelp(InvocationContext ic) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("name", (JsonValue)PropertyListDataProviderImpl.makeHelpClause(ic, LocalizedConstants.DATA_PROVIDER_HELP_NAME_SUMMARY, LocalizedConstants.DATA_PROVIDER_HELP_NAME_DETAIL));
        ret.add("file", (JsonValue)PropertyListDataProviderImpl.makeHelpClause(ic, LocalizedConstants.PROPERTY_LIST_PROVIDER_HELP_FILE_SUMMARY, LocalizedConstants.PROPERTY_LIST_PROVIDER_HELP_FILE_DETAIL));
        return ret.build();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void terminate() {
    }

    @Override
    public void test(InvocationContext ic) {
        this.start(ic);
    }

    @Override
    public boolean start(InvocationContext ic) {
        ic.setProvider(this);
        if (this.editRoot.getPageRepo() == null) {
            this.lastMessage = null;
        }
        return true;
    }

    @Override
    public Map<String, Root> getRoots() {
        return this.roots;
    }

    @Override
    public JsonObject toJSON(InvocationContext ic) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("name", this.getName());
        if (this.getLabel() != null && !this.getName().equals(this.getLabel())) {
            ret.add("label", this.getLabel());
        }
        ret.add("providerType", this.getType());
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Root root : this.getRoots().values()) {
            builder.add((JsonValue)root.toJSON(ic));
        }
        ret.add("roots", builder);
        ret.add("mode", "standalone");
        if (this.lastMessage != null) {
            ret.add("messages", this.createMessages(this.lastMessage));
        }
        return ret.build();
    }

    @Override
    public boolean isValidPath(String path) {
        return true;
    }
}

