/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.providers;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.core.Response;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersion;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersions;
import weblogic.remoteconsole.server.ConsoleBackendRuntime;
import weblogic.remoteconsole.server.ConsoleBackendRuntimeConfig;
import weblogic.remoteconsole.server.connection.Connection;
import weblogic.remoteconsole.server.connection.ConnectionManager;
import weblogic.remoteconsole.server.filter.ClientAuthHeader;
import weblogic.remoteconsole.server.providers.AdminServerDataProvider;
import weblogic.remoteconsole.server.providers.Provider;
import weblogic.remoteconsole.server.providers.ProviderManager;
import weblogic.remoteconsole.server.providers.Root;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PageRepo;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestDomainRuntimePageRepo;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestEditPageRepo;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestSecurityDataPageRepo;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestServerConfigPageRepo;
import weblogic.remoteconsole.server.utils.ResponseHelper;
import weblogic.remoteconsole.server.utils.WebLogicRestClient;
import weblogic.remoteconsole.server.utils.WebLogicRestRequest;
import weblogic.remoteconsole.server.webapp.FailedRequestException;

public class AdminServerDataProviderImpl
implements AdminServerDataProvider {
    public static final String TYPE_NAME = "AdminServerConnection";
    private static final ConnectionManager CONNECTION_MANAGER = ConsoleBackendRuntime.INSTANCE.getConnectionManager();
    private static final Logger LOGGER = Logger.getLogger(AdminServerDataProviderImpl.class.getName());
    private static final int MAX_STALE_PROVIDERS = 3;
    private String connectionId;
    private ProviderManager providerManager;
    private String name;
    private String label;
    private String url;
    private String urlOrigin = null;
    private String ssoDomainLoginUri = null;
    private String ssoTokenId;
    private String authorizationHeader;
    private boolean local;
    private long ssoTokenExpires;
    private boolean isDisabledHostnameVerification = false;
    private boolean isInsecureConnection = false;
    private String proxyOverride = null;
    private String connectionWarning;
    private String lastMessage;
    private boolean isLastConnectionAttemptSuccessful;
    private boolean isAnyConnectionAttemptSuccessful;
    private Map<String, Root> roots = new HashMap<String, Root>();
    private Root editRoot;
    private Root viewRoot;
    private Root monitoringRoot;
    private Root securityDataRoot;
    private Timer localConnectionTimer = null;
    private volatile ClientAuthHeader clientAuthHeader = null;
    private Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private static Object reposInitializationLock = new Object();
    private boolean reposInitialized = false;
    private static long lastTimeDiscardedStaleRepos = System.currentTimeMillis();
    private static long DISCARD_STALE_REPO_INTERVAL = 10000L;
    private long lastUsed;
    private static LocalConnectionInfoFetcher localConnectionInfoFetcher;

    public AdminServerDataProviderImpl(ProviderManager providerManager, String name, String label, String url, String authorizationHeader, boolean local) {
        this.providerManager = providerManager;
        this.name = name;
        this.label = label;
        this.url = url;
        this.authorizationHeader = authorizationHeader;
        this.local = local;
        this.editRoot = new Root(this, "edit", "DomainConfiguration", Root.EDIT_LABEL, false, "navtree", "simpleSearch", "changeManager");
        this.viewRoot = new Root(this, "serverConfig", "DomainConfiguration", Root.CONFIGURATION_LABEL, true, "navtree", "simpleSearch");
        this.monitoringRoot = new Root(this, "domainRuntime", "DomainRuntimeMonitoring", Root.MONITORING_LABEL, true, "navtree", "simpleSearch");
        this.securityDataRoot = new Root(this, "securityData", "SecurityData", Root.SECURITY_DATA_LABEL, false, "navtree", "simpleSearch");
        this.updateLastUsed();
    }

    public static void setLocalConnectionInfoFetcher(LocalConnectionInfoFetcher localConnectionInfoFetcher) {
        AdminServerDataProviderImpl.localConnectionInfoFetcher = localConnectionInfoFetcher;
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    private static JsonObject makeHelpClause(InvocationContext ic, LocalizableString summary, LocalizableString detail) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("helpSummaryHTML", ic.getLocalizer().localizeString(summary, new Object[0]));
        ret.add("helpDetailHTML", ic.getLocalizer().localizeString(detail, new Object[0]));
        return ret.build();
    }

    public static JsonObject getHelp(InvocationContext ic) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("name", (JsonValue)AdminServerDataProviderImpl.makeHelpClause(ic, LocalizedConstants.DATA_PROVIDER_HELP_NAME_SUMMARY, LocalizedConstants.DATA_PROVIDER_HELP_NAME_DETAIL));
        ret.add("url", (JsonValue)AdminServerDataProviderImpl.makeHelpClause(ic, LocalizedConstants.ADMIN_SERVER_HELP_URL_SUMMARY, LocalizedConstants.ADMIN_SERVER_HELP_URL_DETAIL));
        ret.add("settings.proxyOverride", (JsonValue)AdminServerDataProviderImpl.makeHelpClause(ic, LocalizedConstants.ADMIN_SERVER_HELP_PROXY_SUMMARY, LocalizedConstants.ADMIN_SERVER_HELP_PROXY_DETAIL));
        ret.add("username", (JsonValue)AdminServerDataProviderImpl.makeHelpClause(ic, LocalizedConstants.ADMIN_SERVER_HELP_USERNAME_SUMMARY, LocalizedConstants.ADMIN_SERVER_HELP_USERNAME_DETAIL));
        ret.add("password", (JsonValue)AdminServerDataProviderImpl.makeHelpClause(ic, LocalizedConstants.ADMIN_SERVER_HELP_PASSWORD_SUMMARY, LocalizedConstants.ADMIN_SERVER_HELP_PASSWORD_DETAIL));
        ret.add("settings.insecure", (JsonValue)AdminServerDataProviderImpl.makeHelpClause(ic, LocalizedConstants.ADMIN_SERVER_HELP_INSECURE_SUMMARY, LocalizedConstants.ADMIN_SERVER_HELP_INSECURE_DETAIL));
        ret.add("settings.sso", (JsonValue)AdminServerDataProviderImpl.makeHelpClause(ic, LocalizedConstants.ADMIN_SERVER_HELP_SSO_SUMMARY, LocalizedConstants.ADMIN_SERVER_HELP_SSO_DETAIL));
        return ret.build();
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public synchronized String getURLOrigin() {
        if (this.urlOrigin == null) {
            try {
                URL origin = new URI(this.url).toURL();
                this.urlOrigin = new URI(origin.getProtocol(), origin.getAuthority(), null, null, null).toString();
            }
            catch (Exception e) {
                this.urlOrigin = this.url;
            }
        }
        return this.urlOrigin;
    }

    @Override
    public boolean isSsoTokenAvailable() {
        return this.ssoTokenId != null && this.authorizationHeader != null;
    }

    @Override
    public long getSsoTokenExpires() {
        return this.ssoTokenExpires;
    }

    @Override
    public void setSsoTokenId(String value) {
        this.ssoTokenId = value;
        this.ssoDomainLoginUri = ConsoleBackendRuntimeConfig.getSsoDomainLoginUri();
    }

    @Override
    public String getSsoTokenId() {
        return this.ssoTokenId;
    }

    @Override
    public boolean setSsoToken(String token, String domain, long expires) {
        if (this.getURLOrigin().equalsIgnoreCase(domain)) {
            this.authorizationHeader = token != null ? "Bearer " + token : null;
            this.ssoTokenExpires = expires > 0L ? expires : 0L;
        }
        return this.authorizationHeader != null;
    }

    @Override
    public String getSsoDomainLoginUri() {
        return this.ssoDomainLoginUri;
    }

    @Override
    public long getConnectTimeout() {
        Connection connection = CONNECTION_MANAGER.getConnection(this.connectionId);
        if (connection != null) {
            return connection.getConnectTimeout();
        }
        return -1L;
    }

    @Override
    public long getReadTimeout() {
        Connection connection = CONNECTION_MANAGER.getConnection(this.connectionId);
        if (connection != null) {
            return connection.getReadTimeout();
        }
        return -1L;
    }

    @Override
    public boolean isDisabledHostnameVerification() {
        return this.isInsecureConnection ? true : this.isDisabledHostnameVerification;
    }

    @Override
    public void setInsecureConnection(boolean value) {
        this.isInsecureConnection = value;
    }

    @Override
    public boolean isInsecureConnection() {
        return this.isInsecureConnection;
    }

    @Override
    public void setProxyOverride(String value) {
        this.proxyOverride = value;
    }

    @Override
    public String getProxyOverride() {
        if (this.proxyOverride != null && this.proxyOverride.length() != 0) {
            return this.proxyOverride;
        }
        return ConsoleBackendRuntimeConfig.getProxy();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isLastConnectionAttemptSuccessful() {
        return this.isLastConnectionAttemptSuccessful;
    }

    @Override
    public boolean isAnyConnectionAttemptSuccessful() {
        return this.isAnyConnectionAttemptSuccessful;
    }

    @Override
    public boolean isConnected() {
        return this.connectionId != null;
    }

    @Override
    public void test(InvocationContext ic) {
        this.start(ic);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized boolean start(InvocationContext ic) {
        ic.setProvider(this);
        Connection connection = null;
        if (this.connectionId == null) {
            if (this.isLocal() && localConnectionInfoFetcher != null) {
                this.url = localConnectionInfoFetcher.fetchURL();
                String token = localConnectionInfoFetcher.fetchToken();
                if (token == null || token.isBlank()) {
                    throw new FailedRequestException(Response.Status.UNAUTHORIZED.getStatusCode(), this.getTokenUnavailable(ic));
                }
                this.authorizationHeader = "Bearer " + token;
            }
            if (this.getSsoTokenId() != null && !this.isSsoTokenAvailable()) {
                throw new FailedRequestException(Response.Status.UNAUTHORIZED.getStatusCode(), this.getTokenUnavailable(ic));
            }
            ClientAuthHeader authHeader = new ClientAuthHeader(this.authorizationHeader);
            ConnectionManager.ConnectionResponse result = CONNECTION_MANAGER.tryConnection(this.url, authHeader, ic.getLocales(), this.isInsecureConnection, this.getProxyOverride());
            if (!result.isSuccess()) {
                this.isLastConnectionAttemptSuccessful = false;
                this.lastMessage = result.getMessage();
                ic.setConnection(null);
                throw new FailedRequestException(result.getStatus().getStatusCode(), this.toJSON(ic));
            }
            this.clientAuthHeader = authHeader;
            if (this.isLocal()) {
                this.startLocalConnectionTimer();
            }
            this.isLastConnectionAttemptSuccessful = true;
            this.isAnyConnectionAttemptSuccessful = true;
            this.connectionId = result.getConnectionId();
            connection = CONNECTION_MANAGER.getConnection(this.connectionId);
            CONNECTION_MANAGER.initializeConnectionUserRoles(connection);
            this.roots.clear();
            this.roots.put(this.viewRoot.getName(), this.viewRoot);
            this.roots.put(this.monitoringRoot.getName(), this.monitoringRoot);
            Set<String> roles = connection.getRoles();
            if (WebLogicMBeansVersion.isAccessAllowed(roles, Set.of("Admin", "Deployer"))) {
                this.roots.put(this.editRoot.getName(), this.editRoot);
            }
            if (connection.getCapabilities().contains("RealmsSecurityData") && WebLogicMBeansVersion.isAccessAllowed(roles, Set.of("Admin"))) {
                this.roots.put(this.securityDataRoot.getName(), this.securityDataRoot);
            }
            this.lastMessage = null;
        } else {
            connection = CONNECTION_MANAGER.getConnection(this.connectionId);
        }
        this.initializeRepos(connection);
        ic.setConnection(connection);
        this.discardStaleRepos(ic);
        return true;
    }

    private boolean isReposInitialized() {
        return this.reposInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeRepos(Connection connection) {
        Object object = reposInitializationLock;
        synchronized (object) {
            if (this.reposInitialized) {
                return;
            }
            LOGGER.finest("Initialize repos " + this.getName() + " " + this.getLabel());
            WebLogicMBeansVersion mbeansVersion = WebLogicMBeansVersions.getVersion(connection);
            this.editRoot.setPageRepo(new WebLogicRestEditPageRepo(mbeansVersion));
            this.viewRoot.setPageRepo(new WebLogicRestServerConfigPageRepo(mbeansVersion));
            this.monitoringRoot.setPageRepo(new WebLogicRestDomainRuntimePageRepo(mbeansVersion));
            if (connection.getCapabilities().contains("RealmsSecurityData") && mbeansVersion.isAccessAllowed(Set.of("Admin"))) {
                this.securityDataRoot.setPageRepo(new WebLogicRestSecurityDataPageRepo(mbeansVersion));
            }
            this.reposInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardStaleRepos(InvocationContext ic) {
        if (System.currentTimeMillis() < lastTimeDiscardedStaleRepos + DISCARD_STALE_REPO_INTERVAL) {
            return;
        }
        Object object = reposInitializationLock;
        synchronized (object) {
            if (System.currentTimeMillis() < lastTimeDiscardedStaleRepos + DISCARD_STALE_REPO_INTERVAL) {
                return;
            }
            TreeMap<Long, AdminServerDataProviderImpl> sortedLastUsedToStaleProvider = new TreeMap<Long, AdminServerDataProviderImpl>();
            for (Provider provider : this.providerManager.getAll()) {
                AdminServerDataProviderImpl adminProvider;
                if (provider == this || !(provider instanceof AdminServerDataProviderImpl) || !(adminProvider = (AdminServerDataProviderImpl)provider).isReposInitialized()) continue;
                sortedLastUsedToStaleProvider.put(adminProvider.getLastUsed(), adminProvider);
            }
            ArrayList candidateStaleProviders = new ArrayList(sortedLastUsedToStaleProvider.values());
            for (int i = 0; i < candidateStaleProviders.size() - 3; ++i) {
                ((AdminServerDataProviderImpl)candidateStaleProviders.get(i)).discardRepos(ic);
            }
            lastTimeDiscardedStaleRepos = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardRepos(InvocationContext ic) {
        Object object = reposInitializationLock;
        synchronized (object) {
            if (!this.reposInitialized) {
                return;
            }
            LOGGER.finest("Discard repos " + this.getName() + " " + this.getLabel());
            this.discardRepos(ic, this.editRoot);
            this.discardRepos(ic, this.viewRoot);
            this.discardRepos(ic, this.monitoringRoot);
            this.discardRepos(ic, this.securityDataRoot);
            this.reposInitialized = false;
        }
    }

    private void discardRepos(InvocationContext ic, Root root) {
        PageRepo pageRepo = root.getPageRepo();
        if (pageRepo != null) {
            pageRepo.prepareForRemoval(ic);
            root.setPageRepo(null);
        }
    }

    @Override
    public void terminate() {
        if (this.connectionId != null) {
            CONNECTION_MANAGER.removeConnection(this.connectionId);
            this.connectionId = null;
        }
        this.clientAuthHeader = null;
        if (this.isLocal()) {
            this.cancelLocalConnectionTimer();
        }
    }

    private JsonObject getTokenUnavailable(InvocationContext ic) {
        this.isLastConnectionAttemptSuccessful = false;
        this.lastMessage = ic.getLocalizer().localizeString(LocalizedConstants.SSO_TOKEN_UNAVAILABLE, new Object[0]);
        return this.toJSON(ic);
    }

    @Override
    public Map<String, Root> getRoots() {
        return this.roots;
    }

    @Override
    public JsonObject toJSON(InvocationContext ic) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        ret.add("name", this.getName());
        if (this.getLabel() != null && !this.getName().equals(this.getLabel())) {
            ret.add("label", this.getLabel());
        }
        ret.add("providerType", this.getType());
        ret.add("domainUrl", this.getURL());
        if (this.isInsecureConnection()) {
            ret.add("insecure", true);
        }
        if (this.proxyOverride != null) {
            ret.add("proxyOverride", this.proxyOverride);
        }
        if (this.getSsoTokenId() != null) {
            ret.add("sso", true);
            if (this.authorizationHeader == null) {
                ret.add("ssoid", this.getSsoTokenId());
            }
            if (this.getSsoDomainLoginUri() != null) {
                ret.add("ssologin", this.getSsoDomainLoginUri());
            }
        }
        ret.add("mode", "standalone");
        if (this.isLocal()) {
            ret.add("local", true);
        }
        ret.add("anyConnectionAttemptSuccessful", this.isAnyConnectionAttemptSuccessful());
        ret.add("lastConnectionAttemptSuccessful", this.isLastConnectionAttemptSuccessful());
        Connection connection = null;
        if (this.isLastConnectionAttemptSuccessful()) {
            String consoleExtensionVersion;
            ret.add("state", "connected");
            connection = CONNECTION_MANAGER.getConnection(this.connectionId);
            ret.add("connectTimeout", this.getConnectTimeout());
            ret.add("readTimeout", this.getReadTimeout());
            ret.add("domainVersion", connection.getWebLogicVersion().getDomainVersion());
            ret.add("domainName", connection.getDomainName());
            JsonArrayBuilder capabilities = Json.createArrayBuilder();
            for (String capability : new TreeSet<String>(connection.getCapabilities())) {
                capabilities.add(capability);
            }
            ret.add("capabilities", capabilities);
            if (this.connectionWarning != null) {
                ret.add("connectionWarning", this.connectionWarning);
            }
            if (StringUtils.isEmpty((String)(consoleExtensionVersion = connection.getConsoleExtensionVersion()))) {
                consoleExtensionVersion = ic.getLocalizer().localizeString(LocalizedConstants.CONSOLE_REST_EXTENSION_NOT_INSTALLED, new Object[0]);
            }
            ret.add("consoleExtensionVersion", consoleExtensionVersion);
        } else {
            ret.add("state", "disconnected");
            if (this.lastMessage != null) {
                ret.add("messages", this.createMessages(this.lastMessage));
            }
        }
        this.addStatusToJSON(ret);
        this.addRootsToJSON(ret, connection, ic);
        this.addRolesToJSON(ret, connection);
        return ret.build();
    }

    private void addRootsToJSON(JsonObjectBuilder jsonBuilder, Connection connection, InvocationContext ic) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        if (connection != null) {
            for (Root root : this.getRoots().values()) {
                builder.add((JsonValue)root.toJSON(ic));
            }
        }
        jsonBuilder.add("roots", builder);
    }

    private void addRolesToJSON(JsonObjectBuilder jsonBuilder, Connection connection) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        if (connection != null && connection.getRoles() != null) {
            for (String role : connection.getRoles()) {
                builder.add(role);
            }
        }
        jsonBuilder.add("roles", builder);
    }

    private void addStatusToJSON(JsonObjectBuilder jsonBuilder) {
        JsonObjectBuilder statusBuilder = Json.createObjectBuilder();
        String resourceData = "/api/" + UrlUtils.urlEncode(this.getName()) + "/domainStatus";
        statusBuilder.add("resourceData", resourceData);
        statusBuilder.add("refreshSeconds", 15);
        jsonBuilder.add("domainStatus", statusBuilder);
    }

    @Override
    public JsonObject getStatus(InvocationContext ic) {
        Connection connection = this.isLastConnectionAttemptSuccessful() ? CONNECTION_MANAGER.getConnection(this.connectionId) : null;
        return new DomainStatusGetter(connection, ic).getDomainStatus();
    }

    @Override
    public boolean isValidPath(String path) {
        return true;
    }

    @Override
    public Map<String, Object> getCache() {
        return this.cache;
    }

    @Override
    public void updateLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    private boolean refreshLocalConnectionToken() {
        ClientAuthHeader localAuthHeader = this.clientAuthHeader;
        if (this.isLocal() && localConnectionInfoFetcher != null && localAuthHeader != null) {
            String token = localConnectionInfoFetcher.fetchToken();
            if (token == null || token.isBlank()) {
                LOGGER.fine("Unable to refreshed local connection token - unavailable!");
                return false;
            }
            this.authorizationHeader = "Bearer " + token;
            localAuthHeader.setAuthHeader(this.authorizationHeader);
            LOGGER.fine("Refreshed local connection token!");
            return true;
        }
        return false;
    }

    private synchronized void startLocalConnectionTimer() {
        if (this.isLocal() && localConnectionInfoFetcher != null) {
            int timeoutMins = localConnectionInfoFetcher.fetchTokenTimeoutMins();
            long timeoutMillis = (long)(timeoutMins < 5 ? timeoutMins : timeoutMins - 3) * 60000L;
            this.cancelLocalConnectionTimer();
            this.localConnectionTimer = new Timer("WRCLocalConnectionTimer", true);
            this.localConnectionTimer.schedule((TimerTask)new LocalConnectionTimer(), timeoutMillis);
            LOGGER.fine("Started local connection timer with interval millis: " + timeoutMillis);
        }
    }

    private synchronized void cancelLocalConnectionTimer() {
        if (this.isLocal() && this.localConnectionTimer != null) {
            this.localConnectionTimer.cancel();
            this.localConnectionTimer = null;
            LOGGER.fine("Canceled local connection timer!");
        }
    }

    public static interface LocalConnectionInfoFetcher {
        public int fetchTokenTimeoutMins();

        public String fetchToken();

        public String fetchURL();
    }

    private class DomainStatusGetter {
        private JsonObjectBuilder builder = Json.createObjectBuilder();
        private Connection connection;
        private InvocationContext ic;
        private boolean connectFailed;
        private LocalizableString messageLabel;
        private String severity;
        private LocalizableString linkLabel;
        private String linkHref;
        private String linkResourceData;
        private LocalizableString detailsLabel;
        private String detailsMessage;

        private DomainStatusGetter(Connection connection, InvocationContext ic) {
            this.connection = connection;
            this.ic = ic;
        }

        private JsonObject getDomainStatus() {
            this.testWebLogicRestDelegation();
            this.getNeedServerRestart();
            this.getSecurityWarnings();
            if (this.connectFailed) {
                this.messageLabel = LocalizedConstants.CANT_CONNECT_TO_ADMIN_SERVER;
                this.linkLabel = null;
                this.severity = "warning";
            }
            if (this.messageLabel != null) {
                this.builder.add("messageHTML", this.ic.getLocalizer().localizeString(this.messageLabel, new Object[0]));
                this.builder.add("severity", this.severity);
                if (this.linkLabel != null) {
                    JsonObjectBuilder linkBuilder = Json.createObjectBuilder().add("label", this.ic.getLocalizer().localizeString(this.linkLabel, new Object[0]));
                    if (this.linkHref != null) {
                        linkBuilder.add("href", this.linkHref);
                    } else {
                        linkBuilder.add("resourceData", this.linkResourceData);
                    }
                    this.builder.add("link", linkBuilder);
                }
                if (this.detailsLabel != null && this.detailsMessage != null) {
                    JsonObjectBuilder detailsBuilder = Json.createObjectBuilder().add("label", this.ic.getLocalizer().localizeString(this.detailsLabel, new Object[0]));
                    detailsBuilder.add("message", this.detailsMessage);
                    this.builder.add("messageDetails", detailsBuilder);
                }
            }
            return this.builder.build();
        }

        private void testWebLogicRestDelegation() {
            if (this.connectFailed || this.messageLabel != null) {
                return;
            }
            this.testWebLogicRestDelegation(this.getAdminServerName());
        }

        private void testWebLogicRestDelegation(String adminServerName) {
            if (this.connectFailed || this.messageLabel != null) {
                return;
            }
            WebLogicRestRequest request = WebLogicRestRequest.builder().connection(this.connection).path("/domainRuntime/serverRuntimes/" + adminServerName).queryParam("links", "none").queryParam("fields", "name").build();
            try (Response response = WebLogicRestClient.get(request);){
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    return;
                }
                JsonObject entityAsJson = ResponseHelper.getEntityAsJson(response);
                LOGGER.finest("testWebLogicRestDelegation failed: " + response.getStatus() + " " + (entityAsJson != null ? entityAsJson.toString() : ResponseHelper.getEntityAsString(response)));
                this.severity = "error";
                this.messageLabel = LocalizedConstants.WEBLOGIC_REST_DELEGATION_NOT_WORKING_MESSAGE;
                this.setExternalLink(LocalizedConstants.WEBLOGIC_REST_DELEGATION_NOT_WORKING_LINK, ConsoleBackendRuntimeConfig.getDocumentationSite() + "/troubleshoot-weblogic-remote-console/#GUID-2EF5267E-FE34-4D74-BF2F-3F318E47062A");
                this.setMessageDetails(LocalizedConstants.WEBLOGIC_REST_DELEGATION_NOT_WORKING_DETAILS_LABEL, entityAsJson);
                this.detailsMessage = "<ul><li>" + this.detailsMessage + "</li><li>" + this.ic.getLocalizer().localizeString(LocalizedConstants.SUGGEST_RESTART_SERVER_MESSAGE, new Object[0]) + "</li></ul>";
                return;
            }
            catch (Exception exc) {
                LOGGER.log(Level.FINEST, "testWebLogicRestDelegation failed: " + exc.toString(), exc);
                this.connectFailed = true;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getAdminServerName() {
            if (this.connectFailed) return null;
            if (this.messageLabel != null) {
                return null;
            }
            WebLogicRestRequest request = WebLogicRestRequest.builder().connection(this.connection).path("/domainConfig").queryParam("links", "none").queryParam("fields", "adminServerName").build();
            try (Response response = WebLogicRestClient.get(request);){
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    String string = ResponseHelper.getEntityAsJson(response).getString("adminServerName");
                    return string;
                }
                LOGGER.finest("getAdminServerName failed: " + response.getStatus() + " " + ResponseHelper.getEntityAsString(response));
            }
            catch (Exception exc) {
                LOGGER.log(Level.FINEST, "getAdminServerName failed: " + exc.toString(), exc);
            }
            this.connectFailed = true;
            return null;
        }

        private void getNeedServerRestart() {
            if (this.connectFailed || this.messageLabel != null) {
                return;
            }
            WebLogicRestRequest request = WebLogicRestRequest.builder().connection(this.connection).path("/domainRuntime/serverRuntimes").queryParam("links", "none").queryParam("fields", "restartRequired").build();
            try (Response response = WebLogicRestClient.get(request);){
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    boolean needRestart = false;
                    JsonArray items = ResponseHelper.getEntityAsJson(response).getJsonArray("items");
                    for (int i = 0; !needRestart && i < items.size(); ++i) {
                        boolean serverNeedsRestart = items.getJsonObject(i).getBoolean("restartRequired", false);
                        if (!serverNeedsRestart) continue;
                        needRestart = true;
                    }
                    if (needRestart) {
                        this.messageLabel = LocalizedConstants.NEED_SERVER_RESTART_LABEL;
                        this.severity = "warning";
                        this.setPageLink(LocalizedConstants.SERVER_RESTART_LINK_LABEL, "domainRuntime/data/DomainRuntime/CombinedServerRuntimes");
                    }
                    return;
                }
                LOGGER.finest("getNeedServerRestart failed: " + response.getStatus() + " " + ResponseHelper.getEntityAsString(response));
            }
            catch (Exception exc) {
                LOGGER.log(Level.FINEST, "getNeedServerRestart failed: " + exc.toString(), exc);
            }
            this.connectFailed = false;
        }

        private void getSecurityWarnings() {
            if (this.connectFailed || this.messageLabel != null) {
                return;
            }
            WebLogicRestRequest request = WebLogicRestRequest.builder().connection(this.connection).path("/domainRuntime/domainSecurityRuntime/hasSecurityValidationWarnings").build();
            JsonObject requestBody = Json.createObjectBuilder().build();
            try (Response response = WebLogicRestClient.post(request, requestBody);){
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    this.setPageLink(LocalizedConstants.SECURITY_VALIDATION_WARNINGS_LINK_LABEL, "domainRuntime/data/DomainRuntime/DomainSecurityRuntime?slice=SecurityWarnings");
                    boolean hasWarnings = ResponseHelper.getEntityAsJson(response).getBoolean("return");
                    this.messageLabel = hasWarnings ? LocalizedConstants.HAVE_SECURITY_VALIDATION_WARNINGS_LABEL : LocalizedConstants.NO_SECURITY_VALIDATION_WARNINGS_LABEL;
                    this.severity = hasWarnings ? "error" : "info";
                    return;
                }
                if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                    return;
                }
                if (response.getStatus() == Response.Status.FORBIDDEN.getStatusCode()) {
                    return;
                }
                LOGGER.finest("getSecurityWarnings failed: " + response.getStatus() + " " + ResponseHelper.getEntityAsString(response));
            }
            catch (Exception exc) {
                LOGGER.log(Level.FINEST, "getSecurityWarnings failed: " + exc.toString(), exc);
            }
            this.connectFailed = true;
        }

        private void setPageLink(LocalizableString label, String path) {
            this.linkLabel = label;
            this.linkResourceData = "/api/" + UrlUtils.urlEncode(AdminServerDataProviderImpl.this.getName()) + "/" + path;
            this.linkHref = null;
        }

        private void setExternalLink(LocalizableString label, String href) {
            this.linkLabel = label;
            this.linkHref = href;
            this.linkResourceData = null;
        }

        private void setMessageDetails(LocalizableString label, JsonObject entityAsJson) {
            JsonArray messagesJson;
            if (entityAsJson != null && entityAsJson.containsKey((Object)"messages") && (messagesJson = entityAsJson.getJsonArray("messages")) != null) {
                Object details = "";
                boolean firstMessage = true;
                for (int i = 0; i < messagesJson.size(); ++i) {
                    String message;
                    JsonObject messageJson = messagesJson.getJsonObject(i);
                    if (messageJson == null || !messageJson.containsKey((Object)"message") || (message = messageJson.getString("message")) == null || message.isBlank()) continue;
                    if (!firstMessage) {
                        details = (String)details + " - ";
                    } else {
                        firstMessage = false;
                    }
                    details = (String)details + message;
                }
                if (!((String)details).isEmpty()) {
                    this.detailsLabel = label;
                    this.detailsMessage = details;
                }
            }
        }
    }

    private class LocalConnectionTimer
    extends TimerTask {
        private LocalConnectionTimer() {
        }

        @Override
        public void run() {
            LOGGER.fine("LocalConnectionTimer executing...");
            if (AdminServerDataProviderImpl.this.refreshLocalConnectionToken()) {
                AdminServerDataProviderImpl.this.startLocalConnectionTimer();
                LOGGER.fine("LocalConnectionTimer complete!");
            }
        }
    }
}

