/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.filter;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.server.providers.ProviderManager;
import weblogic.remoteconsole.server.repo.Frontend;
import weblogic.remoteconsole.server.repo.FrontendManager;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.token.SsoTokenManager;
import weblogic.remoteconsole.server.webapp.WebAppUtils;

@Provider
@PreMatching
public class SessionFilter
implements ContainerRequestFilter {
    @Context
    private HttpServletRequest requestServletContext;
    private static boolean inputOutputTrace = System.getenv("BACKEND_FRONTEND_INPUT_OUTPUT_TRACE") != null;
    private static final Logger LOGGER = Logger.getLogger(SessionFilter.class.getName());

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (inputOutputTrace) {
            LOGGER.info("Entering SessionFilter " + requestContext.getRequest().toString() + " with " + String.valueOf(requestContext.getUriInfo().getRequestUri()));
        }
        List segs = requestContext.getUriInfo().getPathSegments(false);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Request uri=" + String.valueOf(requestContext.getUriInfo().getRequestUri()) + " method=" + requestContext.getMethod() + " cookies=" + String.valueOf(requestContext.getCookies()) + " headers=" + String.valueOf(requestContext.getHeaders()) + " and UserPrincipal of " + String.valueOf(requestContext.getSecurityContext().getUserPrincipal()));
        }
        if (segs.size() == 0 || !((PathSegment)segs.get(0)).getPath().equals("api")) {
            LOGGER.fine("Ignoring request NOT for Console Backend JAX-RS resource!");
            return;
        }
        if (segs.size() > 1 && ((PathSegment)segs.get(1)).getPath().equals("token")) {
            LOGGER.fine("Setup SsoTokenManager for request!");
            SsoTokenManager.setInRequestContext(requestContext);
            return;
        }
        Frontend frontend = null;
        String windowId = requestContext.getHeaderString("Unique-Id");
        if (this.requestServletContext != null) {
            frontend = FrontendManager.find(this.requestServletContext.getSession().getId(), windowId);
            if (frontend == null) {
                frontend = FrontendManager.create(this.requestServletContext.getSession().getId(), windowId);
            }
        } else {
            String header;
            Cookie sessionId = (Cookie)requestContext.getCookies().get("WebLogicRemoteConsoleSessionID");
            if (sessionId == null && (header = requestContext.getHeaderString("X-Session-Token")) != null) {
                sessionId = new Cookie("whocares", header);
            }
            if (sessionId == null) {
                LOGGER.fine("Creating a new frontend, because the session id is null");
                frontend = FrontendManager.create(UUID.randomUUID().toString(), windowId);
                WebAppUtils.storeCookieInContext(requestContext, frontend);
            } else {
                frontend = FrontendManager.find(sessionId.getValue(), windowId);
                if (frontend == null) {
                    LOGGER.fine("Creating a new frontend, because we can't find the sessionId/windowId combo");
                    frontend = FrontendManager.create(sessionId.getValue(), windowId);
                }
            }
        }
        frontend.storeInRequestContext(requestContext);
        frontend.setLastRequestTime();
        InvocationContext ic = new InvocationContext();
        ic.setFrontend(frontend);
        WebAppUtils.storeInvocationContextInRequestContext(requestContext, ic);
        ic.setLocales(requestContext.getAcceptableLanguages());
        ic.setUriInfo(requestContext.getUriInfo());
        if (requestContext.getSecurityContext().getUserPrincipal() != null) {
            ic.setUser(requestContext.getSecurityContext().getUserPrincipal().getName());
        }
        if (SessionFilter.isProviderBasedPath(requestContext)) {
            SessionFilter.setupConnectionAndRewriteURL(requestContext, frontend, ic);
        }
    }

    private static boolean isProviderBasedPath(ContainerRequestContext requestContext) {
        List segs = requestContext.getUriInfo().getPathSegments(false);
        if (segs.size() < 3) {
            return false;
        }
        if (((PathSegment)segs.get(1)).getPath().equals("providers")) {
            return false;
        }
        return !((PathSegment)segs.get(0)).getPath().equals("about");
    }

    private static void setupConnectionAndRewriteURL(ContainerRequestContext requestContext, Frontend frontend, InvocationContext ic) {
        String provider;
        List segs = requestContext.getUriInfo().getPathSegments(false);
        ProviderManager pm = frontend.getProviderManager();
        if (!pm.hasProvider(provider = UrlUtils.urlDecode(((PathSegment)segs.get(1)).getPath()))) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
            LOGGER.fine("Aborted Console Backend request due to bad provider: " + provider + " with frontend: " + frontend.getID());
            return;
        }
        if (!pm.startProvider(provider, ic)) {
            LOGGER.fine("Aborted Console Backend request due to failed provider!");
            requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
            return;
        }
        StringBuilder newPath = new StringBuilder();
        newPath.append(requestContext.getUriInfo().getBaseUri().getPath());
        newPath.append("api");
        for (PathSegment seg : segs.subList(2, segs.size())) {
            newPath.append("/");
            newPath.append(seg.getPath());
        }
        requestContext.setRequestUri(requestContext.getUriInfo().getRequestUriBuilder().replacePath(newPath.toString()).build(new Object[0]));
    }
}

