/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.filter;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import weblogic.remoteconsole.server.token.SsoTokenManager;

@Provider
public class CorsFilter
implements ContainerResponseFilter {
    private static boolean inputOutputTrace = System.getenv("BACKEND_FRONTEND_INPUT_OUTPUT_TRACE") != null;
    private static final Logger LOGGER = Logger.getLogger(CorsFilter.class.getName());
    private static final String ORIGIN_LOCALHOST_8000 = "http://localhost:8000";

    public void filter(ContainerRequestContext req, ContainerResponseContext res) throws IOException {
        List origin = (List)req.getHeaders().get((Object)"Origin");
        if (origin != null && !origin.isEmpty()) {
            String allowOrigin = (String)origin.get(0);
            if (!ORIGIN_LOCALHOST_8000.equals(allowOrigin)) {
                LOGGER.fine("Origin=" + allowOrigin);
                SsoTokenManager ssoTokenManager = SsoTokenManager.getFromRequestContext(req);
                if (ssoTokenManager != null && ssoTokenManager.isAllowedOrigin(allowOrigin)) {
                    res.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)allowOrigin);
                    res.getHeaders().add((Object)"Access-Control-Request-Private-Network", (Object)"true");
                    res.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)"content-type, accept, origin");
                    res.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"POST, GET, OPTIONS");
                    if (req.getMethod().equals("OPTIONS")) {
                        res.setStatusInfo((Response.StatusType)Response.Status.OK);
                    }
                }
            } else {
                res.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)allowOrigin);
                res.getHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)"true");
                res.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)"origin, content-type, accept, authorization, x-session-token, unique-id");
                res.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS, HEAD");
                if (req.getMethod().equals("OPTIONS")) {
                    res.setStatus(200);
                }
            }
            res.getHeaders().add((Object)"Access-Control-Expose-Headers", (Object)"x-session-token");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Response status=" + res.getStatus() + " headers=" + String.valueOf(res.getStringHeaders()) + " for Request uri=" + String.valueOf(req.getUriInfo().getRequestUri()) + " method=" + req.getMethod());
        }
        if (inputOutputTrace) {
            Logger.getLogger(CorsFilter.class.getName()).info("Exiting CorsFilter " + req.getRequest().toString() + " with " + String.valueOf(req.getUriInfo().getRequestUri()));
        }
    }
}

