/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.connection;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.jar.JarFile;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.utils.RemoteConsoleExtension;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.server.connection.Connection;
import weblogic.remoteconsole.server.utils.WebLogicRestClient;
import weblogic.remoteconsole.server.utils.WebLogicRestRequest;

class RemoteConsoleExtensionImpl
implements RemoteConsoleExtension {
    private String name;
    private String version;
    private Connection connection;
    private boolean initializedJarFile = false;
    private JarFile jarFile = null;

    public RemoteConsoleExtensionImpl(String name, String version) {
        this.name = name;
        this.version = version;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public synchronized JarFile getJarFile() {
        if (!this.initializedJarFile) {
            Path path = new Path("domainRuntime.consoleBackend.extensions");
            path.addComponent(this.getName());
            path.addComponent("download");
            WebLogicRestRequest request = WebLogicRestRequest.builder().root("/management/weblogic/12.2.1.0.0").connection(this.connection).path(UrlUtils.pathToRelativeUri(path)).build();
            try (InputStream is = WebLogicRestClient.getAsInputStream(request, "application/octet-stream");){
                File temp = File.createTempFile(this.getName(), ".jar");
                temp.deleteOnExit();
                Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.jarFile = new JarFile(temp);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.initializedJarFile = true;
            }
        }
        return this.jarFile;
    }
}

