/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.connection;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.utils.WebLogicRoles;
import weblogic.remoteconsole.common.utils.WebLogicVersion;
import weblogic.remoteconsole.common.utils.WebLogicVersions;
import weblogic.remoteconsole.server.ConsoleBackendRuntimeConfig;
import weblogic.remoteconsole.server.connection.Connection;
import weblogic.remoteconsole.server.connection.ConnectionImpl;
import weblogic.remoteconsole.server.connection.RemoteConsoleExtensionImpl;
import weblogic.remoteconsole.server.filter.ClientAuthFeature;
import weblogic.remoteconsole.server.filter.ClientAuthHeader;
import weblogic.remoteconsole.server.utils.ResponseHelper;
import weblogic.remoteconsole.server.utils.WebLogicRestClient;
import weblogic.remoteconsole.server.utils.WebLogicRestRequest;

public class ConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(ConnectionManager.class.getName());
    private static final String NAME = "name";
    private static final String ADMIN_SERVER_NAME = "adminServerName";
    private static final String WEBLOGIC_VERSION = "weblogicVersion";
    private static final String RETURN = "return";
    private static final String CONSOLE_BACKEND = "consoleBackend";
    private static final String CONSOLE_EXTENSION_VERSION = "version";
    private static final String CONSOLE_EXTENSION_CAPABILITIES = "capabilities";
    private static final String CONSOLE_EXTENSION_EXTENSIONS = "extensions";
    private static final String CONSOLE_EXTENSION_V1 = "1";
    public static final String DEFAULT_USERNAME_UNKNOWN = "<unknown>";
    private static HostnameVerifier defaultHNV = HttpsURLConnection.getDefaultHostnameVerifier();
    private ConcurrentHashMap<String, Connection> connections = new ConcurrentHashMap();

    private static long getConnectTimeout() {
        return ConsoleBackendRuntimeConfig.getConnectTimeout();
    }

    private static long getReadTimeout() {
        return ConsoleBackendRuntimeConfig.getReadTimeout();
    }

    private static void maybeDisableHostnameVerification() {
        if (ConsoleBackendRuntimeConfig.isHostnameVerificationDisabled()) {
            LOGGER.info("Hostname verification for SSL/TLS connections has been disabled!");
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession sslSession) {
                    return true;
                }
            });
        } else {
            HttpsURLConnection.setDefaultHostnameVerifier(defaultHNV);
        }
    }

    private static void setInsecureConnection(ClientBuilder builder) throws Exception {
        builder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String host, SSLSession ssl) {
                return true;
            }
        });
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String type) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String type) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }}, null);
        builder.sslContext(context);
    }

    private static void setProxyOverride(ClientBuilder builder, String proxyString) throws Exception {
        Proxy proxy;
        if (proxyString == null || proxyString.length() == 0 || proxyString.equalsIgnoreCase("direct")) {
            proxy = Proxy.NO_PROXY;
        } else {
            if (!proxyString.contains("://")) {
                throw new Exception("Bad proxy string format");
            }
            String protocol = proxyString.substring(0, proxyString.indexOf("://"));
            String host = proxyString.substring(proxyString.indexOf("://") + 3, proxyString.lastIndexOf(":"));
            String portString = proxyString.substring(proxyString.lastIndexOf(":") + 1);
            int port = Integer.parseInt(portString);
            if (protocol.equals("http")) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
            } else if (protocol.startsWith("socks")) {
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port));
            } else {
                throw new Exception("Unrecognized protocol in proxy string");
            }
        }
        ((ClientConfig)builder.getConfiguration()).connectorProvider((ConnectorProvider)new HttpUrlConnectorProvider().connectionFactory(url -> (HttpURLConnection)url.openConnection(proxy)));
    }

    private static String getUUID() {
        return UUID.randomUUID().toString();
    }

    Connection newConnection(String domainUrl, String domainName, String adminServerName, WebLogicVersion weblogicVersion, String consoleExtensionVersion, Set<String> capabilities, List<RemoteConsoleExtensionImpl> extensionImpls, String username, Client client) {
        ConnectionImpl result = null;
        String id = ConnectionManager.getUUID();
        result = new ConnectionImpl(id, domainUrl, domainName, adminServerName, weblogicVersion, consoleExtensionVersion, capabilities, extensionImpls, username, client, ConnectionManager.getConnectTimeout(), ConnectionManager.getReadTimeout());
        this.connections.put(id, result);
        return result;
    }

    public Connection makeConnection(String domainUrl, String username, String password) {
        Connection result = null;
        ConnectionManager.maybeDisableHostnameVerification();
        ConnectionResponse response = this.tryConnection(domainUrl, username, password);
        if (response.isSuccess()) {
            result = this.getConnection(response.getConnectionId());
        }
        return result;
    }

    public ConnectionResponse tryConnection(String domainUrl, ClientAuthHeader auth, List<Locale> locales, boolean insecure, String proxyOverride) {
        ConnectionManager.maybeDisableHostnameVerification();
        ClientBuilder builder = (ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().connectTimeout(ConnectionManager.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(ConnectionManager.getReadTimeout(), TimeUnit.MILLISECONDS).register(JacksonJsonProvider.class)).register(MultiPartFeature.class)).register((Object)ClientAuthFeature.authorization(auth));
        if (insecure) {
            try {
                ConnectionManager.setInsecureConnection(builder);
            }
            catch (Exception exc) {
                LOGGER.log(Level.FINEST, "Failure setting insecure connection: " + exc.toString(), exc);
                return this.newConnectionResponse(Response.Status.INTERNAL_SERVER_ERROR, null, "Unable to setup insecure connection");
            }
        }
        if (proxyOverride != null && proxyOverride.length() > 0) {
            try {
                ConnectionManager.setProxyOverride(builder, proxyOverride);
            }
            catch (Exception e) {
                return this.newConnectionResponse(Response.Status.BAD_REQUEST, null, "Unable to setup proxy");
            }
        }
        Client client = builder.build();
        String username = this.getUsernameFromHeader(auth.getAuthHeader());
        if (username == null) {
            username = DEFAULT_USERNAME_UNKNOWN;
        }
        ConnectionResponse result = this.connect(domainUrl, username, client, locales);
        if (insecure && result.isSuccess()) {
            Connection connection = this.getConnection(result.getConnectionId());
            String domainName = connection != null ? connection.getDomainName() : "";
            LOGGER.warning(">>>> Insecure connection was established for WebLogic Domain '" + domainName + "' <<<<");
        }
        return result;
    }

    public ConnectionResponse tryConnection(String domainUrl, String username, String password) {
        Client client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().connectTimeout(ConnectionManager.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(ConnectionManager.getReadTimeout(), TimeUnit.MILLISECONDS).register(JacksonJsonProvider.class)).register(MultiPartFeature.class)).register((Object)HttpAuthenticationFeature.basic((String)username, (String)password))).build();
        return this.connect(domainUrl, username, client, null);
    }

    public void initializeConnectionUserRoles(Connection connection) {
        ((ConnectionImpl)connection).setRoles(this.getConnectionUserRoles(connection));
    }

    private Set<String> getConnectionUserRoles(Connection connection) {
        TreeSet<String> result = new TreeSet<String>();
        Boolean inRole = this.isConnectionUserInRole(connection, "Admin");
        if (inRole == null) {
            return null;
        }
        if (inRole.booleanValue()) {
            return WebLogicRoles.ADMIN_ROLES;
        }
        for (String roleName : WebLogicRoles.ALL) {
            if ("Admin".equals(roleName)) continue;
            Boolean inRole2 = this.isConnectionUserInRole(connection, roleName);
            if (inRole2 == null) {
                return null;
            }
            if (!inRole2.booleanValue()) continue;
            result.add(roleName);
        }
        return result;
    }

    private Boolean isConnectionUserInRole(Connection connection, String roleName) {
        Boolean result = null;
        WebLogicRestRequest webLogicRestRequest = WebLogicRestRequest.builder().connection(connection).path("/serverRuntime/serverSecurityRuntime/checkRole").build();
        JsonObject postData = Json.createObjectBuilder().add("roleName", roleName).build();
        try (Response response = WebLogicRestClient.post(webLogicRestRequest, postData);){
            JsonObject entity;
            LOGGER.finest("Response from checking role: " + response.toString());
            if (Response.Status.OK.getStatusCode() == response.getStatus() && (entity = ResponseHelper.getEntityAsJson(response)) != null && entity.containsKey((Object)RETURN)) {
                LOGGER.fine("Check role result for role '" + roleName + "' and user '" + connection.getUsername() + "' is: " + entity.toString());
                result = entity.getBoolean(RETURN, true);
            }
        }
        catch (Exception exc) {
            LOGGER.finest("Unable to check role using '" + connection.getDomainUrl() + "' because " + exc.toString());
            LOGGER.log(Level.FINEST, "Failure when checking role: " + exc.toString(), exc);
        }
        return result;
    }

    private ConnectionResponse connect(String domainUrl, String username, Client client, List<Locale> locales) {
        ConnectionResponse domainConfigResponse = this.doConnectAndReportProblems(domainUrl, client, "domainConfig", this.getDomainConfigQuery());
        JsonObject domainConfigEntity = domainConfigResponse.getEntity();
        if (domainConfigEntity == null) {
            return domainConfigResponse;
        }
        String domainName = domainConfigEntity.getString(NAME, null);
        if (domainName == null) {
            LOGGER.info("Unexpected response from WebLogic Domain: No name found!");
            return this.newConnectionResponse(Response.Status.INTERNAL_SERVER_ERROR, client, "Missing name");
        }
        String adminServerName = domainConfigEntity.getString(ADMIN_SERVER_NAME, null);
        if (adminServerName == null) {
            LOGGER.info("Unexpected response from WebLogic Domain: No adminServer found!");
            return this.newConnectionResponse(Response.Status.INTERNAL_SERVER_ERROR, client, "Missing adminServerName");
        }
        String consoleExtensionVersion = this.getConsoleExtensionVersion(domainConfigEntity);
        Set<String> capabilities = this.getCapabilities(domainUrl, client, domainConfigEntity);
        List<RemoteConsoleExtensionImpl> extensionImpls = this.getExtensionImpls(domainConfigEntity);
        if (consoleExtensionVersion != null) {
            LOGGER.info("The domain has version '" + consoleExtensionVersion + "' of the WebLogic Remote Console Extension installed.");
        } else {
            LOGGER.info("The domain does not have the WebLogic Remote Console Extension installed.");
        }
        ConnectionResponse serverRuntimeResponse = this.doConnectAndReportProblems(domainUrl, client, "serverRuntime", this.getServerRuntimeQuery());
        JsonObject serverRuntimeEntity = serverRuntimeResponse.getEntity();
        if (serverRuntimeEntity == null) {
            return serverRuntimeResponse;
        }
        String wlsVersion = serverRuntimeEntity.getString(WEBLOGIC_VERSION, null);
        if (wlsVersion == null) {
            LOGGER.info("Unexpected response from WebLogic Domain: No weblogicVersion found!");
            return this.newConnectionResponse(Response.Status.INTERNAL_SERVER_ERROR, client, "Missing weblogicVersion");
        }
        String domainVersion = this.computeDomainVersion(wlsVersion);
        if (domainVersion == null) {
            LOGGER.info("Unexpected response from WebLogic Domain: cannot parse weblogicVersion: " + wlsVersion);
            return this.newConnectionResponse(Response.Status.INTERNAL_SERVER_ERROR, client, "Cannot parse weblogicVersion");
        }
        if (!WebLogicVersions.isSupportedVersion(domainVersion)) {
            LocalizableString message = LocalizedConstants.UNSUPPORTED_DOMAIN_VERSION;
            LOGGER.info(message.getEnglishText(new Object[0]));
            return this.newConnectionResponse(Response.Status.NOT_IMPLEMENTED, client, message.getEnglishText(new Object[0]));
        }
        WebLogicVersion weblogicVersion = WebLogicVersions.getVersion(domainVersion);
        capabilities.addAll(WebLogicVersions.getVersionCapabilities(weblogicVersion));
        StringBuilder sb = new StringBuilder();
        sb.append(">>>> Connected to the WebLogic Domain '").append(domainName).append("' with version '").append(weblogicVersion).append("' <<<<");
        LOGGER.info(sb.toString());
        return this.newConnectionResponse(this.newConnection(domainUrl, domainName, adminServerName, weblogicVersion, consoleExtensionVersion, capabilities, extensionImpls, username, client));
    }

    private String computeDomainVersion(String weblogicVersion) {
        String prefix = "WebLogic Server ";
        int idx1 = weblogicVersion.indexOf(prefix);
        if (idx1 != -1) {
            int start = idx1 + prefix.length();
            int idx2 = weblogicVersion.indexOf(" ", start);
            if (idx2 == -1) {
                idx2 = weblogicVersion.indexOf("\n", start);
            }
            if (idx2 == -1) {
                idx2 = weblogicVersion.length();
            }
            return weblogicVersion.substring(start, idx2);
        }
        return null;
    }

    private JsonObject getConsoleBackend(JsonObject entity) {
        return entity.getJsonObject(CONSOLE_BACKEND);
    }

    private String getConsoleExtensionVersion(JsonObject entity) {
        String version;
        JsonObject consoleBackend = this.getConsoleBackend(entity);
        String string = version = consoleBackend != null ? consoleBackend.getString(CONSOLE_EXTENSION_VERSION, null) : null;
        if ("CBE_WLS_REST_EXTENSION_V1".equals(version)) {
            version = CONSOLE_EXTENSION_V1;
        }
        return version;
    }

    private Set<String> getCapabilities(String domainUrl, Client client, JsonObject entity) {
        Set<String> consoleExtensionCapabilities = this.getConsoleExtensionCapabilities(entity);
        Set<String> beanCapabilities = this.getBeanCapabilities(domainUrl, client, consoleExtensionCapabilities);
        HashSet<String> capabilities = new HashSet<String>(consoleExtensionCapabilities);
        capabilities.addAll(beanCapabilities);
        capabilities.add("AdminServerConnection");
        return capabilities;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> getBeanCapabilities(String domainUrl, Client client, Set<String> consoleExtensionCapabilities) {
        if (!consoleExtensionCapabilities.contains("BeansSupport")) return Set.of();
        WebLogicRestRequest webLogicRestRequest = WebLogicRestRequest.builder().path("/domainConfig/consoleBackend/beansSupport").serverUrl(domainUrl).client(client).build();
        JsonObject capabilityToBeanFeature = this.getCapabilityToBeanFeature();
        try (Response response = WebLogicRestClient.post(webLogicRestRequest, capabilityToBeanFeature);){
            LOGGER.finest("Response from beansSupport: " + response.toString());
            if (Response.Status.OK.getStatusCode() != response.getStatus()) return Set.of();
            JsonObject entity = ResponseHelper.getEntityAsJson(response);
            if (entity == null) return Set.of();
            LOGGER.finest("Entity from beansSupport: " + String.valueOf(entity));
            HashSet<String> beanCapabilities = new HashSet<String>();
            for (String beanCapability : capabilityToBeanFeature.keySet()) {
                if (!entity.getBoolean(beanCapability, false)) continue;
                beanCapabilities.add(beanCapability);
            }
            HashSet<String> hashSet = beanCapabilities;
            return hashSet;
        }
        catch (Exception exc) {
            LOGGER.finest("Unable to determine bean capabilities '" + domainUrl + "' because " + exc.toString());
            LOGGER.log(Level.FINEST, "Failure when getting bean capabilities: " + exc.toString(), exc);
        }
        return Set.of();
    }

    private JsonObject getCapabilityToBeanFeature() {
        return Json.createObjectBuilder().add("JMSMessages", Json.createObjectBuilder().add("type", "weblogic.management.runtime.JMSMessageManagementRuntimeMBean").add("action", "getJMSMessages").add("params", Json.createArrayBuilder().add("selector").add("max").add("sortOn").add("ascending"))).add("JTATransactions", Json.createObjectBuilder().add("type", "weblogic.management.runtime.JTARuntimeMBean").add("action", "currentTransactions")).add("JRFSecurityProviders", Json.createObjectBuilder().add("type", "oracle.security.wls.oam.providers.authenticator.OAMAuthenticatorMBean")).add("AllowList", Json.createObjectBuilder().add("type", "weblogic.management.configuration.AllowListMBean")).add("GarbageCollection", Json.createObjectBuilder().add("type", "weblogic.management.runtime.JVMRuntimeMBean").add("action", "runGC")).add("OIDCIdentityAsserter", Json.createObjectBuilder().add("type", "weblogic.security.providers.authentication.OIDCIdentityAsserterMBean")).add("OracleVirtualDirectoryAuthenticator", Json.createObjectBuilder().add("type", "weblogic.security.providers.authentication.OracleVirtualDirectoryAuthenticatorMBean")).add("IPlanetAuthenticator", Json.createObjectBuilder().add("type", "weblogic.security.providers.authentication.IPlanetAuthenticatorMBean")).add("NovellAuthenticator", Json.createObjectBuilder().add("type", "weblogic.security.providers.authentication.NovellAuthenticatorMBean")).add("CertificateManagement", Json.createObjectBuilder().add("type", "weblogic.management.configuration.CertificateManagementMBean")).build();
    }

    private Set<String> getConsoleExtensionCapabilities(JsonObject entity) {
        String version = this.getConsoleExtensionVersion(entity);
        if (version == null) {
            return Set.of();
        }
        JsonArray capabilities = this.getConsoleBackend(entity).getJsonArray(CONSOLE_EXTENSION_CAPABILITIES);
        if (capabilities != null) {
            HashSet<String> rtn = new HashSet<String>();
            for (int i = 0; i < capabilities.size(); ++i) {
                rtn.add(capabilities.getString(i));
            }
            return rtn;
        }
        if (CONSOLE_EXTENSION_V1.equals(version)) {
            return Set.of("ConfigurationChanges", "SecurityProviderType");
        }
        LOGGER.warning("Version '" + version + "' of the WebLogic Remote Console Extension is installed the domain but did not return a list of its capabilities. The WebLogic Remote Console will not support any extended capabilities.");
        return Set.of();
    }

    private List<RemoteConsoleExtensionImpl> getExtensionImpls(JsonObject entity) {
        ArrayList<RemoteConsoleExtensionImpl> rtn = new ArrayList<RemoteConsoleExtensionImpl>();
        JsonObject cbe = this.getConsoleBackend(entity);
        if (cbe != null) {
            JsonArray extensions = cbe.getJsonArray(CONSOLE_EXTENSION_EXTENSIONS);
            for (int i = 0; extensions != null && i < extensions.size(); ++i) {
                JsonObject extension = extensions.getJsonObject(i);
                rtn.add(new RemoteConsoleExtensionImpl(extension.getString(NAME), extension.getString(CONSOLE_EXTENSION_VERSION)));
            }
        }
        return rtn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConnectionResponse doConnect(String domainUrl, Client client, String tree, JsonObject query) {
        WebLogicRestRequest webLogicRestRequest = WebLogicRestRequest.builder().path("/" + tree + "/search").serverUrl(domainUrl).client(client).build();
        try (Response response = WebLogicRestClient.post(webLogicRestRequest, query);){
            LOGGER.info("Connection response from WebLogic Domain: " + response.toString());
            Response.Status respStatus = response.getStatusInfo().toEnum();
            if (respStatus == Response.Status.INTERNAL_SERVER_ERROR) {
                ConnectionResponse connectionResponse = this.newConnectionResponse(Response.Status.NOT_FOUND, client, "Not able to connect");
                return connectionResponse;
            }
            if (respStatus != Response.Status.OK) {
                String message;
                block18: {
                    String defaultMessage;
                    message = defaultMessage = response.getStatusInfo().getReasonPhrase();
                    JsonObject entity = (JsonObject)response.getEntity();
                    if (entity != null) {
                        try {
                            message = entity.getJsonArray("messages").getJsonObject(0).getString("message");
                            if (message.contains("Exception: ")) {
                                message = message.substring(message.indexOf("Exception: ") + "Exception: ".length());
                            }
                            if (message.contains("require-admin-traffic") && respStatus == Response.Status.FORBIDDEN) {
                                respStatus = Response.Status.NOT_FOUND;
                                message = LocalizedConstants.USE_ADMIN_PORT.getEnglishText(new Object[0]);
                                break block18;
                            }
                            if (message.length() > 80 || message.toLowerCase().contains("</html")) {
                                message = defaultMessage;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ConnectionResponse connectionResponse = this.newConnectionResponse(respStatus, client, message);
                return connectionResponse;
            }
            JsonObject entity = ResponseHelper.getEntityAsJson(response);
            ConnectionResponse connectionResponse = new ConnectionResponse(entity);
            return connectionResponse;
        }
        catch (Exception exc) {
            LOGGER.info("Unable to contact WebLogic Domain '" + domainUrl + "' because " + exc.toString());
            LOGGER.log(Level.FINE, "Connection attempt failed with exception: " + exc.toString(), exc);
            return this.newConnectionResponse(Response.Status.NOT_FOUND, client, "Not able to connect");
        }
    }

    private ConnectionResponse doConnectAndReportProblems(String domainUrl, Client client, String tree, JsonObject query) {
        ConnectionResponse response = this.doConnect(domainUrl, client, tree, query);
        if (response.getEntity() == null) {
            LOGGER.finest("Entity is null on connection attempt to " + domainUrl + ", status is " + String.valueOf(response.getStatus()) + "(" + response.getStatus().getStatusCode() + ")");
            if (domainUrl.endsWith("/console")) {
                return this.newConnectionResponse(Response.Status.NOT_FOUND, client, LocalizedConstants.TAKE_OFF_THE_SLASH_CONSOLE.getEnglishText(new Object[0]));
            }
            if (domainUrl.endsWith("/management")) {
                return this.newConnectionResponse(Response.Status.NOT_FOUND, client, LocalizedConstants.TAKE_OFF_THE_SLASH_MANAGEMENT.getEnglishText(new Object[0]));
            }
            if (Response.Status.OK.getStatusCode() == response.getStatus().getStatusCode()) {
                return this.newConnectionResponse(Response.Status.NOT_FOUND, client, LocalizedConstants.BAD_PATH_GOOD_CONNECTION.getEnglishText(new Object[0]));
            }
        }
        return response;
    }

    private JsonObject getDomainConfigQuery() {
        BeanQueryBuilder builder = new BeanQueryBuilder();
        builder.addField(NAME);
        builder.addField(ADMIN_SERVER_NAME);
        BeanQueryBuilder consoleBackendBuilder = builder.getChild(CONSOLE_BACKEND);
        consoleBackendBuilder.addField(CONSOLE_EXTENSION_VERSION);
        consoleBackendBuilder.addField(CONSOLE_EXTENSION_CAPABILITIES);
        consoleBackendBuilder.addField(CONSOLE_EXTENSION_EXTENSIONS);
        JsonObject query = builder.toJson().build();
        return query;
    }

    private JsonObject getServerRuntimeQuery() {
        BeanQueryBuilder builder = new BeanQueryBuilder();
        builder.addField(WEBLOGIC_VERSION);
        JsonObject query = builder.toJson().build();
        return query;
    }

    public boolean isValidConnection(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return false;
        }
        return this.connections.containsKey(id);
    }

    public Connection getConnection(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return this.connections.get(id);
    }

    public void removeConnection(String id) {
        Connection connection;
        if (!StringUtils.isEmpty((String)id) && (connection = this.connections.remove(id)) != null) {
            connection.close();
        }
    }

    private String getUsernameFromHeader(String authorization) {
        int hidx;
        String result = null;
        String header = authorization.trim();
        if (!StringUtils.isEmpty((String)header) && (hidx = header.indexOf(32)) != -1) {
            String decoded;
            int didx;
            String scheme = header.substring(0, hidx).trim();
            String token = header.substring(hidx + 1).trim();
            if (!StringUtils.isEmpty((String)token) && "Basic".equalsIgnoreCase(scheme) && (didx = (decoded = new String(Base64.getDecoder().decode(token), StandardCharsets.ISO_8859_1)).indexOf(58)) != -1) {
                result = decoded.substring(0, didx);
            }
        }
        return result;
    }

    private ConnectionResponse newConnectionResponse(Connection connection) {
        String id = connection != null ? connection.getId() : null;
        return new ConnectionResponse(id);
    }

    private ConnectionResponse newConnectionResponse(Response.Status status, Client client, String message) {
        if (client != null) {
            client.close();
        }
        return new ConnectionResponse(status, message);
    }

    public class ConnectionResponse {
        private Response.Status status = Response.Status.OK;
        private String connectionId;
        private String message;
        private JsonObject entity;

        ConnectionResponse(String connectionId) {
            this.connectionId = connectionId;
        }

        ConnectionResponse(Response.Status status, String message) {
            this.status = status;
            this.message = message;
        }

        ConnectionResponse(JsonObject entity) {
            this.entity = entity;
        }

        public boolean isSuccess() {
            return this.status != null ? this.status.getFamily() == Response.Status.Family.SUCCESSFUL : false;
        }

        public Response.Status getStatus() {
            return this.status;
        }

        public String getConnectionId() {
            return this.connectionId;
        }

        public String getMessage() {
            return this.message;
        }

        JsonObject getEntity() {
            return this.entity;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Status = " + (this.status != null ? this.status.toString() : "NULL"));
            if (this.connectionId != null) {
                buffer.append("; Connection ID = " + this.connectionId);
            }
            if (this.message != null) {
                buffer.append("; Message = " + this.message);
            }
            return buffer.toString();
        }
    }

    private static class BeanQueryBuilder {
        private Set<String> fields = new HashSet<String>();
        private Map<String, BeanQueryBuilder> children = new HashMap<String, BeanQueryBuilder>();

        private BeanQueryBuilder() {
        }

        private void addField(String field) {
            this.fields.add(field);
        }

        private BeanQueryBuilder getChild(String name) {
            return this.children.computeIfAbsent(name, k -> new BeanQueryBuilder());
        }

        private JsonObjectBuilder toJson() {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("links", Json.createArrayBuilder());
            JsonArrayBuilder fieldsBuilder = Json.createArrayBuilder();
            for (String field : this.fields) {
                fieldsBuilder.add(field);
            }
            builder.add("fields", fieldsBuilder);
            if (!this.children.isEmpty()) {
                JsonObjectBuilder childrenBuilder = Json.createObjectBuilder();
                for (Map.Entry<String, BeanQueryBuilder> childEntry : this.children.entrySet()) {
                    childrenBuilder.add(childEntry.getKey(), childEntry.getValue().toJson());
                }
                builder.add("children", childrenBuilder);
            }
            return builder;
        }
    }
}

