/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Client;
import weblogic.remoteconsole.common.utils.RemoteConsoleExtension;
import weblogic.remoteconsole.common.utils.WebLogicVersion;
import weblogic.remoteconsole.server.connection.Connection;
import weblogic.remoteconsole.server.connection.RemoteConsoleExtensionImpl;

public class ConnectionImpl
implements Connection {
    private String id;
    private String domainUrl;
    private String domainName;
    private String adminServerName;
    private WebLogicVersion weblogicVersion;
    private String consoleExtensionVersion;
    private Set<String> capabilities;
    private List<RemoteConsoleExtensionImpl> extensionImpls;
    private List<RemoteConsoleExtension> extensions;
    private String username;
    private Set<String> roles;
    private long connectTimeout;
    private long readTimeout;
    private Client client;

    ConnectionImpl(String id, String domainUrl, String domainName, String adminServerName, WebLogicVersion weblogicVersion, String consoleExtensionVersion, Set<String> capabilities, List<RemoteConsoleExtensionImpl> extensionImpls, String username, Client client, long connectTimeout, long readTimeout) {
        this.id = id;
        this.domainUrl = domainUrl;
        this.domainName = domainName;
        this.adminServerName = adminServerName;
        this.weblogicVersion = weblogicVersion;
        this.consoleExtensionVersion = consoleExtensionVersion;
        this.capabilities = capabilities;
        this.extensionImpls = extensionImpls;
        this.username = username;
        this.client = client;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        if (extensionImpls != null) {
            this.extensions = new ArrayList<RemoteConsoleExtension>();
            for (RemoteConsoleExtensionImpl extensionImpl : extensionImpls) {
                extensionImpl.setConnection(this);
                this.extensions.add(extensionImpl);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDomainUrl() {
        return this.domainUrl;
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public String getAdminServerName() {
        return this.adminServerName;
    }

    @Override
    public WebLogicVersion getWebLogicVersion() {
        return this.weblogicVersion;
    }

    @Override
    public String getConsoleExtensionVersion() {
        return this.consoleExtensionVersion;
    }

    @Override
    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public List<RemoteConsoleExtension> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public Set<String> getRoles() {
        return this.roles;
    }

    void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public long getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }
}

