/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import weblogic.remoteconsole.server.ConsoleBackendRuntimeConfig;

public final class PropertyFileHandler
implements Runnable {
    private File propertyFile;
    private Set<String> setSystemPropertyKeys = new HashSet<String>();
    private Map<String, String> cbeProperties = new HashMap<String, String>();
    private Set<Logger> configuredLoggers = new HashSet<Logger>();

    public PropertyFileHandler() {
        this.initCBEProperties();
    }

    public PropertyFileHandler(String file) throws IOException {
        this.propertyFile = new File(file);
        this.readPropertyFile();
        this.initCBEProperties();
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public void setProperty(String key, String value) {
        if (key.equals("weblogic.remote-console-logging")) {
            this.initializeLoggers(value);
        } else if (ConsoleBackendRuntimeConfig.isCBEProperty(key)) {
            this.cbeProperties.put(key, value);
        } else {
            this.setSystemPropertyKeys.add(key);
            System.setProperty(key, value);
        }
    }

    private void initializeLoggers(String loggingRules) {
        for (String rule : loggingRules.split(";")) {
            String loggerName = rule.substring(0, rule.indexOf(61));
            String levelString = rule.substring(rule.indexOf(61) + 1);
            try {
                Level level = Level.parse(levelString);
                Logger logger = Logger.getLogger(loggerName);
                logger.setLevel(level);
                this.configuredLoggers.add(logger);
            }
            catch (Exception e) {
                Logger thisLogger = Logger.getLogger(PropertyFileHandler.class.getName());
                thisLogger.warning("Bad logger level specified in weblogic.remote-console-logging - " + levelString);
            }
        }
    }

    public void clearProperties() {
        this.cbeProperties.clear();
        for (String key : this.setSystemPropertyKeys) {
            System.getProperties().remove(key);
        }
        this.resetLoggers();
    }

    public void initCBEProperties() {
        ConsoleBackendRuntimeConfig.init(this.cbeProperties);
    }

    private void resetLoggers() {
        for (Logger logger : this.configuredLoggers) {
            logger.setLevel(null);
        }
        this.configuredLoggers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPropertyFile() throws IOException {
        this.clearProperties();
        if (!this.propertyFile.exists()) {
            return;
        }
        FileReader reader = new FileReader(this.propertyFile);
        JsonReader jsReader = Json.createReader((Reader)reader);
        try {
            JsonObject obj = jsReader.readObject();
            for (String prop : obj.keySet()) {
                try {
                    this.setProperty(prop, obj.getString(prop));
                }
                catch (Exception e) {
                    this.setProperty(prop, ((JsonValue)obj.get((Object)prop)).toString());
                }
            }
        }
        finally {
            jsReader.close();
            reader.close();
        }
        Logger.getLogger(PropertyFileHandler.class.getName()).log(Level.FINEST, "System properties are now: " + String.valueOf(Arrays.asList(System.getProperties())));
    }

    @Override
    public void run() {
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            Path path = Paths.get(this.propertyFile.getParent(), new String[0]);
            Logger.getLogger(PropertyFileHandler.class.getName()).log(Level.FINEST, "Setting up watch on: " + String.valueOf(path));
            path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            while (true) {
                WatchKey key = watchService.take();
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (!event.context().toString().equals(this.propertyFile.getName())) continue;
                    Logger.getLogger(PropertyFileHandler.class.getName()).log(Level.FINEST, "File changed: " + event.context().toString());
                    int i = 0;
                    try {
                        this.readPropertyFile();
                        this.initCBEProperties();
                    }
                    catch (Exception e) {
                        if (++i == 3) {
                            throw e;
                        }
                        Thread.sleep(100L);
                    }
                    break;
                }
                key.reset();
            }
        }
        catch (Exception e) {
            Logger.getLogger(PropertyFileHandler.class.getName()).log(Level.WARNING, "Error reading config file", e);
            return;
        }
    }
}

