/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.util.logging.Logger;
import weblogic.remoteconsole.server.repo.InvocationContext;

public class PersistenceManager<T> {
    private static final Logger LOGGER = Logger.getLogger(PersistenceManager.class.getName());
    private static PersistenceConfigurator persistenceConfigurator;
    private static ObjectMapper mapper;
    private Class<T> clazz;
    private String key;
    private State state;

    public static void initialize(PersistenceConfigurator configurator) {
        persistenceConfigurator = configurator;
        if (configurator == null) {
            LOGGER.finest("Persistence not supported.");
            return;
        }
        mapper = new ObjectMapper().enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
    }

    public PersistenceManager(Class<T> clazz, String key) {
        this.clazz = clazz;
        this.key = key;
    }

    public State get(InvocationContext ic) {
        LOGGER.finest("get " + this.key);
        if (!this.isCurrent(ic)) {
            this.state = new State(this.readPersistedData(ic));
        }
        return this.state;
    }

    private boolean isCurrent(InvocationContext ic) {
        if (this.state == null) {
            return false;
        }
        if (!PersistenceManager.supportsPersistence(ic)) {
            return true;
        }
        File file = this.getPersistenceFile(ic);
        if (file.exists()) {
            return file.lastModified() <= this.state.getTimeStamp();
        }
        return this.state.getData() == null;
    }

    private T readPersistedData(InvocationContext ic) {
        if (!PersistenceManager.supportsPersistence(ic)) {
            return null;
        }
        File file = this.getPersistenceFile(ic);
        if (!file.exists()) {
            return null;
        }
        try {
            return (T)mapper.readValue(file, this.clazz);
        }
        catch (Throwable t) {
            LOGGER.severe("Problem reading " + file.getAbsolutePath() + " : " + t.getMessage());
            return null;
        }
    }

    public void reportBadFormat(InvocationContext ic, String problem) {
        LOGGER.severe("Bad format " + this.getPersistenceFile(ic).getAbsolutePath() + " : " + problem);
    }

    public void set(InvocationContext ic, T data) {
        LOGGER.finest("set " + this.key);
        this.state = new State(data);
        this.writePersistentData(ic, data);
    }

    private void writePersistentData(InvocationContext ic, T data) {
        if (!PersistenceManager.supportsPersistence(ic)) {
            return;
        }
        persistenceConfigurator.getDirectory(ic).mkdirs();
        File file = this.getPersistenceFile(ic);
        if (data == null) {
            if (file.exists()) {
                try {
                    file.delete();
                }
                catch (Throwable t) {
                    LOGGER.severe("Problem deleting " + file.getAbsolutePath() + " : " + t.getMessage());
                }
            }
        } else {
            try {
                mapper.writerWithDefaultPrettyPrinter().writeValue(file, data);
            }
            catch (Throwable t) {
                LOGGER.severe("Problem writing to " + file.getAbsolutePath() + " : " + t.getMessage());
            }
        }
    }

    private static boolean supportsPersistence(InvocationContext ic) {
        return persistenceConfigurator != null && persistenceConfigurator.getDirectory(ic) != null;
    }

    public static boolean shouldIPersistProjects(InvocationContext ic) {
        return persistenceConfigurator != null && persistenceConfigurator.shouldIPersistProjects(ic);
    }

    private File getPersistenceFile(InvocationContext ic) {
        return new File(persistenceConfigurator.getDirectory(ic), this.key + ".json");
    }

    public static String getPersistenceFilePath(InvocationContext ic) {
        return PersistenceManager.supportsPersistence(ic) ? persistenceConfigurator.getDirectory(ic).getPath() : null;
    }

    public static interface PersistenceConfigurator {
        public File getDirectory(InvocationContext var1);

        public boolean shouldIPersistProjects(InvocationContext var1);
    }

    public class State {
        private long timeStamp = System.currentTimeMillis();
        private T data;

        private State(T data) {
            this.data = data;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public T getData() {
            return this.data;
        }

        public String toString() {
            return "State<timeStamp=" + this.timeStamp + ", data=" + String.valueOf(this.data) + ">";
        }
    }
}

