/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server;

import java.util.logging.Logger;
import weblogic.remoteconsole.server.PersistenceManager;
import weblogic.remoteconsole.server.repo.InvocationContext;

public abstract class PersistableFeature<T> {
    private static final Logger LOGGER = Logger.getLogger(PersistableFeature.class.getName());
    private PersistenceManager.State state = null;

    protected void refresh(InvocationContext ic) {
        LOGGER.finest("refresh");
        PersistenceManager.State newState = this.getPersistenceManager().get(ic);
        if (newState != this.state) {
            LOGGER.finest("reloading");
            this.state = newState;
            try {
                this.fromPersistedData(ic, this.state.getData());
            }
            catch (BadFormatException e) {
                this.getPersistenceManager().reportBadFormat(ic, e.getMessage());
            }
        }
    }

    protected void update(InvocationContext ic) {
        LOGGER.finest("update");
        this.getPersistenceManager().set(ic, this.toPersistedData(ic));
    }

    protected abstract PersistenceManager<T> getPersistenceManager();

    protected abstract void fromPersistedData(InvocationContext var1, T var2);

    protected abstract T toPersistedData(InvocationContext var1);

    public static class BadFormatException
    extends RuntimeException {
        public BadFormatException(String message) {
            super(message);
        }
    }
}

