/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server;

import io.helidon.microprofile.server.Server;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import weblogic.remoteconsole.server.ConsoleBackendRuntimeConfig;
import weblogic.remoteconsole.server.PersistenceManager;
import weblogic.remoteconsole.server.PropertyFileHandler;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.webapp.WebAppUtils;

public final class Main {
    private static final String LOGGING_FILE = "logging.properties";
    private static PropertyFileHandler propertyFileHandler;
    public static final String WLS_CONSOLE_BACKEND = "WebLogic Console Backend";

    private static void readStandardInput() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        System.exit(0);
                    }
                    if (line.equals("START")) {
                        propertyFileHandler.clearProperties();
                        continue;
                    }
                    if (line.equals("END")) {
                        propertyFileHandler.initCBEProperties();
                        continue;
                    }
                    if (!line.contains("=")) continue;
                    propertyFileHandler.setProperty(line.substring(0, line.indexOf(61)), line.substring(line.indexOf(61) + 1));
                }
            }
            catch (IOException eof) {
                System.exit(0);
                continue;
            }
            break;
        }
    }

    private static void usage() {
        System.err.println("Usage: console.jar [-p port] [--stdin] [--useTokenNotCookie] [--showPort] [--properties <property-file-path>] [--persistenceDirectory <persistence-directory-path>]");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        boolean stdin = false;
        boolean showPortOnStdout = false;
        String persistenceDirectory = System.getenv("CBE_PERSISTENCE_DIRECTORY");
        boolean configInitialized = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-p")) {
                if (args.length == ++i) {
                    Main.usage();
                }
                System.setProperty("server.port", args[1]);
                continue;
            }
            if (args[i].equals("--stdin")) {
                stdin = true;
                continue;
            }
            if (args[i].equals("--useTokenNotCookie")) {
                WebAppUtils.setUseTokenNotCookie();
                continue;
            }
            if (args[i].equals("--showPort")) {
                showPortOnStdout = true;
                continue;
            }
            if (args[i].equals("--properties")) {
                if (args.length == ++i) {
                    Main.usage();
                }
                propertyFileHandler = new PropertyFileHandler(args[i]);
                configInitialized = true;
                continue;
            }
            if (!args[i].equals("--persistenceDirectory")) continue;
            if (args.length == ++i) {
                Main.usage();
            }
            persistenceDirectory = args[i];
        }
        if (!configInitialized) {
            if (stdin) {
                propertyFileHandler = new PropertyFileHandler();
            } else {
                ConsoleBackendRuntimeConfig.init(null);
            }
            configInitialized = true;
        }
        Main.configureLogging();
        if (persistenceDirectory != null) {
            PersistenceManager.initialize(new SimplePersistenceConfigurator(persistenceDirectory));
        } else {
            PersistenceManager.initialize(null);
        }
        Server server = Main.startServer();
        if (showPortOnStdout) {
            System.out.println("Port=" + server.port());
        }
        if (stdin) {
            Main.readStandardInput();
        }
    }

    private Main() {
    }

    private static Server startServer() {
        return Server.create().start();
    }

    private static Logger configureLogging() throws IOException {
        Object source;
        String configClass = System.getProperty("java.util.logging.config.class");
        String configPath = System.getProperty("java.util.logging.config.file");
        if (configClass != null) {
            source = "class: " + configClass;
        } else if (configPath != null) {
            Path path = Paths.get(configPath, new String[0]);
            File f = new File(configPath);
            if (f.exists()) {
                source = path.toAbsolutePath().toString();
            } else {
                System.getProperties().remove("java.util.logging.config.file");
                source = LOGGING_FILE;
            }
        } else {
            source = Main.findAndConfigureLogging();
        }
        Logger logger = Logger.getLogger(Main.class.getName());
        logger.info("Logging configured using " + (String)source);
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findAndConfigureLogging() throws IOException {
        BufferedInputStream logConfigStream;
        Object source = "defaults";
        Path path = Paths.get("", new String[0]).resolve(LOGGING_FILE);
        if (Files.exists(path, new LinkOption[0])) {
            logConfigStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            source = "file: " + String.valueOf(path.toAbsolutePath());
        } else {
            InputStream resourceStream = Main.class.getResourceAsStream("/logging.properties");
            if (null != resourceStream) {
                logConfigStream = new BufferedInputStream(resourceStream);
                source = "classpath: /logging.properties";
            } else {
                logConfigStream = null;
            }
        }
        if (null != logConfigStream) {
            try {
                LogManager.getLogManager().readConfiguration(logConfigStream);
            }
            finally {
                ((InputStream)logConfigStream).close();
            }
        }
        return source;
    }

    private static class SimplePersistenceConfigurator
    implements PersistenceManager.PersistenceConfigurator {
        private File file;

        private SimplePersistenceConfigurator(String path) {
            this.file = new File(path);
        }

        @Override
        public boolean shouldIPersistProjects(InvocationContext ic) {
            return false;
        }

        @Override
        public File getDirectory(InvocationContext ic) {
            return this.file;
        }
    }
}

