/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class ConsoleBackendRuntimeConfig {
    private static final Logger LOGGER = Logger.getLogger(ConsoleBackendRuntimeConfig.class.getName());
    public static final String CONFIG_FILE_PROPERTY = "weblogic.remote.console.config.file";
    public static final String CONFIG_RESOURCE_PROPERTY = "weblogic.remote.console.config.resource";
    private static final Map<String, String> defaultProperties = new HashMap<String, String>();
    private static final Properties configFileProperties = new Properties();
    private static final Map<String, String> deploymentProperties = new HashMap<String, String>();
    private static String name;
    private static long connectTimeoutMillis;
    private static long readTimeoutMillis;
    private static boolean disableHostnameVerification;
    private static boolean enableSameSiteCookieValue;
    private static String valueSameSiteCookie;
    private static long ssoTimerSeconds;
    private static long ssoTimeoutSeconds;
    private static String documentationSite;
    private static String ssoDomainLoginUri;
    private static String proxy;
    private static boolean restrictContentBasedOnRoles;

    private static void loadConfigFile() {
        configFileProperties.clear();
        InputStream is = null;
        String configFile = System.getProperty(CONFIG_RESOURCE_PROPERTY);
        if (configFile != null) {
            if (!new File(configFile).exists()) {
                return;
            }
            try {
                is = new FileInputStream(configFile);
            }
            catch (IOException ioe) {
                LOGGER.warning("Exception reading user-specified remote console config file " + configFile + ": " + String.valueOf(ioe));
                return;
            }
        } else {
            String configResource = System.getProperty(CONFIG_RESOURCE_PROPERTY, "weblogic-remote-console-config.properties");
            is = ConsoleBackendRuntimeConfig.class.getClassLoader().getResourceAsStream(configResource);
            if (is == null) {
                return;
            }
        }
        try {
            configFileProperties.load(is);
        }
        catch (IOException ioe) {
            LOGGER.warning("Exception reading remote console config : " + String.valueOf(ioe));
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isCBEProperty(String propertyName) {
        return defaultProperties.containsKey(propertyName);
    }

    private static String propGet(String key) {
        String ret = defaultProperties.get(key);
        if (configFileProperties.containsKey(key)) {
            ret = (String)configFileProperties.get(key);
        }
        if (deploymentProperties.containsKey(key)) {
            ret = deploymentProperties.get(key);
        }
        if (System.getProperty("console." + key) != null) {
            ret = System.getProperty("console." + key);
        }
        return ret;
    }

    public static void init(Map<String, String> deploymentPropertiesInit) {
        ConsoleBackendRuntimeConfig.loadConfigFile();
        deploymentProperties.clear();
        if (deploymentPropertiesInit != null) {
            deploymentProperties.putAll(deploymentPropertiesInit);
        }
        name = ConsoleBackendRuntimeConfig.propGet("name");
        connectTimeoutMillis = Integer.parseInt(ConsoleBackendRuntimeConfig.propGet("connectTimeoutMillis"));
        readTimeoutMillis = Integer.parseInt(ConsoleBackendRuntimeConfig.propGet("readTimeoutMillis"));
        disableHostnameVerification = Boolean.parseBoolean(ConsoleBackendRuntimeConfig.propGet("disableHostnameVerification"));
        enableSameSiteCookieValue = Boolean.parseBoolean(ConsoleBackendRuntimeConfig.propGet("enableSameSiteCookieValue"));
        valueSameSiteCookie = ConsoleBackendRuntimeConfig.propGet("valueSameSiteCookie");
        ssoTimerSeconds = Integer.parseInt(ConsoleBackendRuntimeConfig.propGet("ssoTimerSeconds"));
        ssoTimeoutSeconds = Integer.parseInt(ConsoleBackendRuntimeConfig.propGet("ssoTimeoutSeconds"));
        documentationSite = ConsoleBackendRuntimeConfig.propGet("documentationSite");
        ssoDomainLoginUri = ConsoleBackendRuntimeConfig.propGet("ssoDomainLoginUri");
        proxy = ConsoleBackendRuntimeConfig.propGet("proxy");
        restrictContentBasedOnRoles = Boolean.parseBoolean(ConsoleBackendRuntimeConfig.propGet("restrictContentBasedOnRoles"));
    }

    public static String getName() {
        return name;
    }

    public static long getConnectTimeout() {
        return connectTimeoutMillis;
    }

    public static long getReadTimeout() {
        return readTimeoutMillis;
    }

    public static boolean isSameSiteCookieEnabled() {
        return enableSameSiteCookieValue;
    }

    public static String getSameSiteCookieValue() {
        return valueSameSiteCookie;
    }

    public static boolean isHostnameVerificationDisabled() {
        return disableHostnameVerification;
    }

    public static long getSsoTimerSeconds() {
        return ssoTimerSeconds;
    }

    public static long getSsoTimeoutSeconds() {
        return ssoTimeoutSeconds;
    }

    public static String getDocumentationSite() {
        return documentationSite;
    }

    public static String getSsoDomainLoginUri() {
        return ssoDomainLoginUri;
    }

    public static String getVersion() {
        return "2.4.18";
    }

    public static String getProxy() {
        return proxy;
    }

    public static boolean isRestrictContentBasedOnRoles() {
        return restrictContentBasedOnRoles;
    }

    static {
        restrictContentBasedOnRoles = true;
        defaultProperties.put("name", "Oracle WebLogic Server Remote Console");
        defaultProperties.put("connectTimeoutMillis", "10000");
        defaultProperties.put("readTimeoutMillis", "20000");
        defaultProperties.put("disableHostnameVerification", "false");
        defaultProperties.put("enableSameSiteCookieValue", "false");
        defaultProperties.put("valueSameSiteCookie", "Lax");
        defaultProperties.put("ssoTimerSeconds", "30");
        defaultProperties.put("ssoTimeoutSeconds", "300");
        defaultProperties.put("ssoDomainLoginUri", null);
        defaultProperties.put("proxy", null);
        defaultProperties.put("restrictContentBasedOnRoles", "true");
    }
}

