/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.util.Properties;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoException;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelper;

public class TimesTenClientJDBC4DriverURLHelper
extends JDBCURLHelper {
    @Override
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        String dsn = null;
        String ttcServer = null;
        String tcpPort = null;
        String ttcServerDsn = null;
        if (this.isValid(this.getOtherAttribute("dsn", info))) {
            dsn = this.getOtherAttribute("dsn", info);
        }
        if (this.isValid(this.getOtherAttribute("ttc_server", info))) {
            ttcServer = this.getOtherAttribute("ttc_server", info);
        }
        if (this.isValid(this.getOtherAttribute("tcp_port", info))) {
            tcpPort = this.getOtherAttribute("tcp_port", info);
        }
        if (this.isValid(this.getOtherAttribute("ttc_server_dsn", info))) {
            ttcServerDsn = this.getOtherAttribute("ttc_server_dsn", info);
        }
        if (ttcServer != null || tcpPort != null || ttcServerDsn != null) {
            if (ttcServer == null) {
                throw new JDBCDriverInfoException("ttc_server");
            }
            if (tcpPort == null) {
                throw new JDBCDriverInfoException("tcp_port");
            }
            if (ttcServerDsn == null) {
                throw new JDBCDriverInfoException("ttc_server_dsn");
            }
            if (dsn != null) {
                throw new JDBCDriverInfoException("dsn");
            }
            return "jdbc:timesten:client:TTC_SERVER=" + ttcServer + ";TCP_PORT=" + tcpPort + ";TTC_SERVER_DSN=" + ttcServerDsn;
        }
        if (dsn == null) {
            throw new JDBCDriverInfoException("dsn");
        }
        return "jdbc:timesten:client:" + dsn;
    }

    @Override
    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        Properties props = new Properties();
        if (this.isValid(info.getUserName())) {
            props.put("user", info.getUserName());
        }
        return props;
    }
}

