/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.util.Properties;
import weblogic.remoteconsole.jdbc.common.internal.JDBCUtil;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoException;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelper;

public class SybaseJDBC4DriverURLHelper
extends JDBCURLHelper {
    @Override
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        if (!this.isValid(info.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(info.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        Object dbmsName = info.getDbmsName();
        dbmsName = !this.isValid((String)dbmsName) ? "" : "/" + (String)dbmsName;
        return "jdbc:sybase:Tds:" + info.getDbmsHost() + ":" + info.getDbmsPort() + (String)dbmsName;
    }

    @Override
    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        if (!this.isValid(info.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(info.getUserName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbUsernameReqd());
        }
        if (!this.isValid(info.getPassword())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPasswordReqd());
        }
        if (!this.isValid(info.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        Properties props = new Properties();
        props.put("networkProtocol", "Tds");
        props.put("serverName", info.getDbmsHost());
        props.put("portNumber", info.getDbmsPort());
        props.put("user", info.getUserName());
        props.put("userName", info.getUserName());
        if (this.isValid(info.getDbmsName())) {
            props.put("databaseName", info.getDbmsName());
        }
        props.put("url", this.getURL());
        return props;
    }
}

