/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.util.Map;
import java.util.Properties;
import weblogic.remoteconsole.jdbc.common.internal.JDBCUtil;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverAttribute;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoException;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelper;

public class OracleJDBC4TNSAliasExtensionURLHelper
extends JDBCURLHelper {
    @Override
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        if (!this.isValid(info.getDbmsName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbNameReqd());
        }
        StringBuffer buff = new StringBuffer("jdbc:oracle:thin:@");
        buff.append(info.getDbmsName());
        return buff.toString();
    }

    @Override
    public Properties getProperties() throws JDBCDriverInfoException {
        Map<String, JDBCDriverAttribute> otherAttributes;
        JDBCDriverInfo info = this.getJDBCInfo();
        Properties props = new Properties();
        String userName = info.getUserName();
        if (userName != null) {
            props.put("user", userName);
        }
        if ((otherAttributes = info.getUnknownDriverAttributes()) != null) {
            for (JDBCDriverAttribute att : otherAttributes.values()) {
                if (att.getName() == null || att.getValue() == null || att.getName().equals("AliasName")) continue;
                props.put(att.getName(), att.getValue());
            }
        }
        return props;
    }
}

