/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.util.Properties;
import weblogic.remoteconsole.jdbc.common.internal.JDBCUtil;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoException;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelper;

public abstract class OracleJDBC4DriverURLHelper
extends JDBCURLHelper {
    protected abstract String getSeparator();

    protected abstract String getInitial();

    @Override
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        if (!this.isValid(info.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(info.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        if (!this.isValid(info.getDbmsName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbNameReqd());
        }
        StringBuffer buff = new StringBuffer("jdbc:oracle:thin");
        buff.append(this.getInitial());
        buff.append(info.getDbmsHost());
        buff.append(":");
        buff.append(info.getDbmsPort());
        buff.append(this.getSeparator());
        buff.append(info.getDbmsName());
        String drcpConnectionClass = this.getOtherAttribute("DRCPConnectionClass", info);
        if (this.isValid(drcpConnectionClass)) {
            buff.append(":POOLED");
        }
        return buff.toString();
    }

    @Override
    public Properties getProperties() throws JDBCDriverInfoException {
        String drcpConnectionClass;
        JDBCDriverInfo info = this.getJDBCInfo();
        if (info.getDbmsName() == null) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().oracleUserIdReqd());
        }
        Properties props = new Properties();
        String userName = info.getUserName();
        if (userName != null) {
            props.put("user", userName);
        }
        if (this.isValid(drcpConnectionClass = this.getOtherAttribute("DRCPConnectionClass", info))) {
            props.put("oracle.jdbc.DRCPConnectionClass", drcpConnectionClass);
        }
        return props;
    }

    public static class ServiceHelper
    extends OracleJDBC4DriverURLHelper {
        @Override
        protected String getSeparator() {
            return "/";
        }

        @Override
        protected String getInitial() {
            return ":@//";
        }
    }

    public static class SIDHelper
    extends OracleJDBC4DriverURLHelper {
        @Override
        protected String getSeparator() {
            return ":";
        }

        @Override
        protected String getInitial() {
            return ":@";
        }
    }
}

