/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.util.Iterator;
import java.util.Properties;
import weblogic.remoteconsole.jdbc.common.internal.AddressList;
import weblogic.remoteconsole.jdbc.common.internal.JDBCUtil;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoException;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelper;

public class OracleJDBC4DescriptorURLHelper
extends JDBCURLHelper {
    public OracleJDBC4DescriptorURLHelper() {
    }

    public OracleJDBC4DescriptorURLHelper(JDBCDriverInfo info) {
        super(info);
    }

    @Override
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        AddressList hostPorts = info.getHostPorts();
        if (hostPorts == null || hostPorts.size() == 0) {
            if (!this.isValid(info.getDbmsHost())) {
                throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
            }
            if (!this.isValid(info.getDbmsPort())) {
                throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
            }
            hostPorts = new AddressList();
            hostPorts.add(info.getDbmsHost(), Integer.parseInt(info.getDbmsPort()));
        } else {
            Iterator<AddressList.HostPort> it = hostPorts.iterator();
            while (it.hasNext()) {
                AddressList.HostPort hp = it.next();
                if (!this.isValid(hp.host)) {
                    throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
                }
                if (hp.port > 0) continue;
                throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
            }
        }
        String protocol = this.getOtherAttribute("protocol", info);
        if (!this.isValid(protocol)) {
            protocol = "TCP";
        }
        String drcpConnectionClass = this.getOtherAttribute("DRCPConnectionClass", info);
        String serviceName = this.getOtherAttribute("servicename", info);
        if (!this.isValid(serviceName)) {
            throw new JDBCDriverInfoException("Service name required");
        }
        StringBuffer buff = new StringBuffer("jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS_LIST=");
        Iterator<AddressList.HostPort> it = hostPorts.iterator();
        boolean first = true;
        while (it.hasNext()) {
            AddressList.HostPort hp = it.next();
            if (first) {
                first = false;
                if (it.hasNext()) {
                    buff.append("(LOAD_BALANCE=on)");
                }
            }
            if (hp.protocol != null) {
                buff.append("(ADDRESS=(PROTOCOL=" + hp.protocol + ")(HOST=");
            } else {
                buff.append("(ADDRESS=(PROTOCOL=" + protocol + ")(HOST=");
            }
            buff.append(hp.host);
            buff.append(")(PORT=");
            buff.append(hp.port);
            buff.append("))");
        }
        buff.append(")");
        buff.append("(CONNECT_DATA=");
        buff.append("(SERVICE_NAME=");
        buff.append(serviceName);
        buff.append(")");
        if (this.isValid(drcpConnectionClass)) {
            buff.append("(SERVER=POOLED)");
        }
        buff.append(")");
        buff.append(")");
        return buff.toString();
    }

    @Override
    public Properties getProperties() throws JDBCDriverInfoException {
        String drcpConnectionClass;
        JDBCDriverInfo info = this.getJDBCInfo();
        Properties props = new Properties();
        String userName = info.getUserName();
        if (userName != null) {
            props.put("user", userName);
        }
        if (this.isValid(drcpConnectionClass = this.getOtherAttribute("DRCPConnectionClass", info))) {
            props.put("oracle.jdbc.DRCPConnectionClass", drcpConnectionClass);
        }
        return props;
    }
}

