/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.util.Map;
import java.util.Properties;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverAttribute;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoException;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelper;

public class OracleBIServerURLHelper
extends JDBCURLHelper {
    @Override
    public String getURL() throws JDBCDriverInfoException {
        String host = null;
        String port = null;
        JDBCDriverInfo info = this.getJDBCInfo();
        Map<String, JDBCDriverAttribute> otherAttributes = info.getUnknownDriverAttributes();
        if (otherAttributes != null) {
            for (JDBCDriverAttribute att : otherAttributes.values()) {
                if (att.getName() == null || att.getValue() == null) continue;
                if (att.getName().equals("ServerHost")) {
                    host = att.getValue();
                    continue;
                }
                if (!att.getName().equals("ServerPort")) continue;
                port = att.getValue();
                try {
                    Integer.parseInt(port);
                }
                catch (NumberFormatException e) {
                    throw new JDBCDriverInfoException("serverport");
                }
            }
        }
        Object ret = "jdbc:oraclebi:";
        if (host != null) {
            if (port == null) {
                port = "9703";
            }
            ret = (String)ret + "//" + host + ":" + port + "/";
        }
        if ((otherAttributes = info.getUnknownDriverAttributes()) != null) {
            for (JDBCDriverAttribute att : otherAttributes.values()) {
                if (att.getName() == null || att.getValue() == null) continue;
                if (att.getName().equals("Ssl")) {
                    if (!att.getValue().equals("True") && !att.getValue().equals("False")) {
                        throw new JDBCDriverInfoException("ssl");
                    }
                    if (att.getValue().equals("False")) {
                        continue;
                    }
                } else if (att.getName().equals("TrustAnyServer")) {
                    if (!att.getValue().equals("True") && !att.getValue().equals("False")) {
                        throw new JDBCDriverInfoException("trustanyserver");
                    }
                    if (att.getValue().equals("False")) continue;
                }
                if (att.getName().equals("PrimaryCcsPort")) {
                    try {
                        Integer.parseInt(att.getValue());
                    }
                    catch (NumberFormatException e) {
                        throw new JDBCDriverInfoException("primaryccsport");
                    }
                } else if (att.getName().equals("SecondaryCcsPort")) {
                    try {
                        Integer.parseInt(att.getValue());
                    }
                    catch (NumberFormatException e) {
                        throw new JDBCDriverInfoException("secondaryccsport");
                    }
                } else if (att.getName().equals("ServerHost") || att.getName().equals("ServerPort")) continue;
                ret = (String)ret + att.getName() + "=" + att.getValue() + ";";
            }
        }
        return ret;
    }

    @Override
    public Properties getProperties() throws JDBCDriverInfoException {
        Properties props = new Properties();
        JDBCDriverInfo info = this.getJDBCInfo();
        if (this.isValid(info.getUserName())) {
            props.put("user", info.getUserName());
        }
        return props;
    }
}

