/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.util.Properties;
import weblogic.remoteconsole.jdbc.common.internal.JDBCUtil;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoException;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelper;

public class NeonJDBCDriverURLHelper
extends JDBCURLHelper {
    @Override
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        String dataSource = this.getOtherAttribute("datasource", info);
        if (!this.isValid(dataSource)) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().neonDSNameReqd());
        }
        if (!this.isValid(info.getUserName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbUsernameReqd());
        }
        if (!this.isValid(info.getPassword())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPasswordReqd());
        }
        return "jdbc:neon:" + dataSource + ";UID=" + info.getUserName();
    }

    @Override
    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        if (!this.isValid(info.getPassword())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPasswordReqd());
        }
        Properties props = new Properties();
        return props;
    }
}

