/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.lang.reflect.InvocationTargetException;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelper;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelperException;

public class JDBCURLHelperFactory {
    private JDBCURLHelperFactory() {
    }

    public static JDBCURLHelperFactory newInstance() {
        return new JDBCURLHelperFactory();
    }

    public JDBCURLHelper getJDBCURLHelper(JDBCDriverInfo driverInfo) throws JDBCURLHelperException {
        if (driverInfo == null) {
            throw new IllegalArgumentException("JDBCDriverInfo can't be null");
        }
        String helperClassName = driverInfo.getURLHelperClassName();
        if (helperClassName == null || helperClassName.length() < 1) {
            throw new JDBCURLHelperException("URLHelperClassName is invalid for " + driverInfo.getDriverVendor() + "'s " + driverInfo.getDbmsVendor() + " driver");
        }
        try {
            JDBCURLHelper helper = (JDBCURLHelper)Class.forName(helperClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            helper.setJDBCDriverInfo(driverInfo);
            return helper;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException cce) {
            throw new JDBCURLHelperException("Exception instantiating JDBCURLHelperClass", cce);
        }
    }
}

