/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverAttribute;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoException;

public abstract class JDBCURLHelper {
    private JDBCDriverInfo info;

    public JDBCURLHelper() {
    }

    protected JDBCURLHelper(JDBCDriverInfo info) {
        this.info = info;
    }

    protected void setJDBCDriverInfo(JDBCDriverInfo info) {
        this.info = info;
    }

    public JDBCDriverInfo getJDBCInfo() {
        return this.info;
    }

    public abstract String getURL() throws JDBCDriverInfoException;

    public abstract Properties getProperties() throws JDBCDriverInfoException;

    public boolean isValid(String checkme) {
        return checkme != null && checkme.length() > 0;
    }

    public String getOtherAttribute(String name, JDBCDriverInfo info) {
        Map<String, JDBCDriverAttribute> otherAttributes = info.getUnknownDriverAttributes();
        String lcName = name.toLowerCase(Locale.ENGLISH);
        if (otherAttributes != null) {
            for (JDBCDriverAttribute att : otherAttributes.values()) {
                if (!att.getName().toLowerCase(Locale.ENGLISH).startsWith(lcName)) continue;
                if (att.getValue() == null) {
                    if (att.isRequired() && info.isFillRequired()) {
                        return att.getName();
                    }
                    return "";
                }
                return att.getValue();
            }
        }
        return "";
    }
}

