/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.MetaJDBCDriverInfo;

public final class JDBCDriverInfoFactory {
    private List<MetaJDBCDriverInfo> driverInfos = null;
    private String[] dbVendorNames;

    public JDBCDriverInfoFactory(List<MetaJDBCDriverInfo> listOfJDBCDriverInfos) {
        this.driverInfos = listOfJDBCDriverInfos;
    }

    public String[] getDBMSVendorNames() {
        if (this.driverInfos == null) {
            return null;
        }
        if (this.dbVendorNames == null) {
            HashSet<String> set = new HashSet<String>();
            for (MetaJDBCDriverInfo info : this.driverInfos) {
                set.add(info.getDbmsVendor());
            }
            this.dbVendorNames = new String[set.size()];
            this.dbVendorNames = set.toArray(this.dbVendorNames);
            Arrays.sort(this.dbVendorNames);
        }
        return this.dbVendorNames;
    }

    public JDBCDriverInfo[] getDriverInfos(String vendorName) throws Exception {
        TreeSet<JDBCDriverInfo> set = new TreeSet<JDBCDriverInfo>();
        for (MetaJDBCDriverInfo driverInfo : this.driverInfos) {
            if (driverInfo.getDescription() != null && (driverInfo.getDescription().contains("GridLink") || driverInfo.getDescription().contains("UCP")) || !driverInfo.getDbmsVendor().equals(vendorName)) continue;
            set.add(new JDBCDriverInfo(driverInfo));
        }
        Object[] vendorDriverInfos = new JDBCDriverInfo[set.size()];
        vendorDriverInfos = set.toArray(vendorDriverInfos);
        Arrays.sort(vendorDriverInfos);
        return vendorDriverInfos;
    }

    public JDBCDriverInfo[] getDriverInfos(OracleURLFormat urlFormat) throws Exception {
        TreeSet<JDBCDriverInfo> set = new TreeSet<JDBCDriverInfo>();
        for (MetaJDBCDriverInfo driverInfo : this.driverInfos) {
            if (!driverInfo.getDbmsVendor().equals("Oracle") || driverInfo.getDescription() != null && (driverInfo.getDescription().contains("GridLink") || driverInfo.getDescription().contains("UCP")) || driverInfo.getURLHelperClassName() == null || !driverInfo.getURLHelperClassName().equals(urlFormat.getURLHelper())) continue;
            set.add(new JDBCDriverInfo(driverInfo));
        }
        Object[] vendorDriverInfos = new JDBCDriverInfo[set.size()];
        vendorDriverInfos = set.toArray(vendorDriverInfos);
        Arrays.sort(vendorDriverInfos);
        return vendorDriverInfos;
    }

    public JDBCDriverInfo[] getGridLinkDriverInfos() throws Exception {
        TreeSet<JDBCDriverInfo> set = new TreeSet<JDBCDriverInfo>();
        for (MetaJDBCDriverInfo driverInfo : this.driverInfos) {
            if (driverInfo.getDescription() == null || !driverInfo.getDescription().contains("GridLink")) continue;
            set.add(new JDBCDriverInfo(driverInfo));
        }
        JDBCDriverInfo[] vendorDriverInfos = new JDBCDriverInfo[set.size()];
        vendorDriverInfos = set.toArray(vendorDriverInfos);
        return vendorDriverInfos;
    }

    public JDBCDriverInfo[] getUCPDriverInfos() throws Exception {
        TreeSet<JDBCDriverInfo> driverInfos = new TreeSet<JDBCDriverInfo>();
        for (MetaJDBCDriverInfo driverInfo : this.driverInfos) {
            if (driverInfo.getDescription() == null || !driverInfo.getDescription().contains("UCP")) continue;
            driverInfos.add(new JDBCDriverInfo(driverInfo));
        }
        JDBCDriverInfo[] vendorDriverInfos = new JDBCDriverInfo[driverInfos.size()];
        vendorDriverInfos = driverInfos.toArray(vendorDriverInfos);
        return vendorDriverInfos;
    }

    public JDBCDriverInfo getDriverInfo(String vendorName) {
        for (MetaJDBCDriverInfo metaInfo : this.driverInfos) {
            if (!metaInfo.toString().equals(vendorName)) continue;
            return new JDBCDriverInfo(metaInfo);
        }
        return null;
    }

    public JDBCDriverInfo getDriverInfoByClass(String driverClassName) {
        for (MetaJDBCDriverInfo metaInfo : this.driverInfos) {
            if (!metaInfo.getDriverClassName().equals(driverClassName)) continue;
            return new JDBCDriverInfo(metaInfo);
        }
        return null;
    }

    public JDBCDriverInfo getDriverInfoByClass(String driverClassName, boolean isForXA) {
        for (MetaJDBCDriverInfo metaInfo : this.driverInfos) {
            if (metaInfo.isForXA() != isForXA || !metaInfo.getDriverClassName().equals(driverClassName)) continue;
            return new JDBCDriverInfo(metaInfo);
        }
        return null;
    }

    public List<JDBCDriverInfo> getJDBCDriverInfos() {
        ArrayList<JDBCDriverInfo> newDriverInfoList = new ArrayList<JDBCDriverInfo>();
        for (MetaJDBCDriverInfo metaInfo : this.driverInfos) {
            if (metaInfo.getDescription() != null && (metaInfo.getDescription().contains("GridLink") || metaInfo.getDescription().contains("UCP"))) continue;
            newDriverInfoList.add(new JDBCDriverInfo(metaInfo));
        }
        return newDriverInfoList;
    }

    public static enum OracleURLFormat {
        SID("weblogic.remoteconsole.jdbc.utils.OracleJDBC4DriverURLHelper$SIDHelper"),
        Service("weblogic.remoteconsole.jdbc.utils.OracleJDBC4DriverURLHelper$ServiceHelper"),
        Descriptor("weblogic.remoteconsole.jdbc.utils.OracleJDBC4DescriptorURLHelper"),
        Alias("weblogic.remoteconsole.jdbc.utils.OracleJDBC4AliasURLHelper"),
        RACServiceInstance("weblogic.remoteconsole.jdbc.utils.OracleRACJDBC4DriverURLHelper");

        private String urlHelper;

        private OracleURLFormat(String urlHelper) {
            this.urlHelper = urlHelper;
        }

        String getURLHelper() {
            return this.urlHelper;
        }
    }
}

