/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.remoteconsole.jdbc.common.internal.AddressList;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverAttribute;
import weblogic.remoteconsole.jdbc.utils.MetaJDBCDriverInfo;

public class JDBCDriverInfo
implements Serializable,
Comparable {
    private static final long serialVersionUID = 6919106869180583924L;
    private static final boolean debug = false;
    private boolean triedToLoadDriver = false;
    private boolean driverLoaded = false;
    private Exception loadDriverException;
    private MetaJDBCDriverInfo metaInfo = null;
    private Map<String, JDBCDriverAttribute> myJDBCDriverAtributes = null;
    private Map<String, JDBCDriverAttribute> unknownDriverAttributes = null;
    private transient AddressList hostPorts = new AddressList();
    private boolean fillRequired = false;
    public static final String DB_HOST = "DbmsHost";
    public static final String DB_PORT = "DbmsPort";
    public static final String DB_SERVERNAME = "DbmsName";
    public static final String DB_USER = "DbmsUsername";
    public static final String DB_PASS = "DbmsPassword";
    static final String[] WELL_KNOWN_KEYS = new String[]{"DbmsHost", "DbmsPort", "DbmsName", "DbmsUsername", "DbmsPassword"};

    JDBCDriverInfo(MetaJDBCDriverInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public String getDriverPK() {
        return this.metaInfo.toString();
    }

    public List<? extends Object> getDbmsVersionList() {
        return this.metaInfo.getDbmsVersionList();
    }

    public String getDbmsVersion() {
        return this.metaInfo.getDbmsVersion();
    }

    public String getDbmsVendor() {
        return this.metaInfo.getDbmsVendor();
    }

    public String getDriverVendor() {
        return this.metaInfo.getDriverVendor();
    }

    public String getDriverClassName() {
        return this.metaInfo.getDriverClassName();
    }

    public String getURLHelperClassName() {
        return this.metaInfo.getURLHelperClassName();
    }

    public String getType() {
        return this.metaInfo.getType();
    }

    public String getTestSQL() {
        return this.metaInfo.getTestSQL();
    }

    public String getInstallURL() {
        return this.metaInfo.getInstallURL();
    }

    public String getDescription() {
        return this.metaInfo.getDescription();
    }

    public boolean isForXA() {
        return this.metaInfo.isForXA();
    }

    public boolean isCert() {
        return this.metaInfo.isCert();
    }

    public boolean isFillRequired() {
        return this.fillRequired;
    }

    public void setFillRequired(boolean fillRequired) {
        this.fillRequired = fillRequired;
    }

    public void setDbmsName(String dbmsName) {
        this.setWellKnownAttribute(DB_SERVERNAME, dbmsName);
    }

    public String getDbmsName() {
        return this.getWellKnownAttribute(DB_SERVERNAME);
    }

    public String getDbmsNameDefault() {
        return this.getDefaultFor(DB_SERVERNAME);
    }

    public void setDbmsHost(String host) {
        this.setWellKnownAttribute(DB_HOST, host);
    }

    public String getDbmsHost() {
        return this.getWellKnownAttribute(DB_HOST);
    }

    public String getDbmsHostDefault() {
        return this.getDefaultFor(DB_HOST);
    }

    public void setDbmsPort(String port) {
        this.setWellKnownAttribute(DB_PORT, port);
    }

    public String getDbmsPort() {
        return this.getWellKnownAttribute(DB_PORT);
    }

    public String getDbmsPortDefault() {
        return this.getDefaultFor(DB_PORT);
    }

    public void setPassword(String pass) {
        this.setWellKnownAttribute(DB_PASS, pass);
    }

    public String getPassword() {
        return this.getWellKnownAttribute(DB_PASS);
    }

    public void setUserName(String user) {
        this.setWellKnownAttribute(DB_USER, user);
    }

    public String getUserName() {
        return this.getWellKnownAttribute(DB_USER);
    }

    public void setUknownAttribute(String attributeName, String value) {
        this.setUnknownAttribute(attributeName, value);
    }

    public boolean isServerNameRequired() {
        return this.isAttributeRequired(DB_SERVERNAME);
    }

    public boolean isPortRequired() {
        return this.isAttributeRequired(DB_PORT);
    }

    public boolean isHostNameRequired() {
        return this.isAttributeRequired(DB_HOST);
    }

    public boolean isUserNameRequired() {
        return this.isAttributeRequired(DB_USER);
    }

    public boolean isPassWordRequired() {
        return this.isAttributeRequired(DB_PASS);
    }

    public void addHostPort(String host, int port) {
        this.hostPorts.add(host, port);
    }

    public void setHostPortAddressList(AddressList hostPortList) {
        this.hostPorts = hostPortList;
    }

    public boolean removeHostPort(String host, int port) {
        return this.hostPorts.remove(host, port);
    }

    public AddressList getHostPorts() {
        return this.hostPorts;
    }

    public Map<String, JDBCDriverAttribute> getUnknownDriverAttributes() {
        if (this.unknownDriverAttributes == null) {
            this.unknownDriverAttributes = new LinkedHashMap<String, JDBCDriverAttribute>(this.getUnknownDriverAttributesKeys().size());
            Set<String> keys = this.getUnknownDriverAttributesKeys();
            Iterator<String> i = keys.iterator();
            Map<String, JDBCDriverAttribute> driverAttributes = this.getDriverAttributes();
            while (i.hasNext()) {
                String key = i.next();
                this.unknownDriverAttributes.put(key, driverAttributes.get(key));
            }
        }
        return this.unknownDriverAttributes;
    }

    public Map<String, JDBCDriverAttribute> getDriverAttributes() {
        if (this.myJDBCDriverAtributes == null) {
            this.myJDBCDriverAtributes = this.metaInfo.getDriverAttributes();
        }
        return this.myJDBCDriverAtributes;
    }

    public Set<String> getUnknownDriverAttributesKeys() {
        return this.metaInfo.getUnknownDriverAttributesKeys();
    }

    public boolean isDriverInClasspath() {
        if (!this.triedToLoadDriver) {
            this.triedToLoadDriver = true;
            try {
                Class.forName(this.getDriverClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.driverLoaded = true;
            }
            catch (Exception e) {
                this.loadDriverException = e;
            }
        }
        return this.driverLoaded;
    }

    public Exception exceptionEncounteredLoadingDriver() {
        return this.loadDriverException;
    }

    public String displayString() {
        StringBuffer buff = new StringBuffer();
        if (this.isCert()) {
            buff.append("*");
        }
        buff.append(this.getDriverVendor());
        buff.append("'s ");
        if (!this.getDriverVendor().equals(this.getDbmsVendor())) {
            buff.append(this.getDbmsVendor() + " ");
        }
        buff.append("Type ");
        buff.append(this.getType());
        buff.append(" Driver ");
        if (this.isForXA()) {
            buff.append("for Distributed Transactions (XA) ");
        }
        buff.append(" - Versions : " + this.getDbmsVersion());
        return buff.toString();
    }

    public String toString() {
        return this.metaInfo.toString();
    }

    public String toVerboseString() {
        StringBuffer buff = new StringBuffer();
        buff.append("DBMS Vendor      :  " + (this.getDbmsVendor() == null ? "null" : this.getDbmsVendor()) + "\n");
        buff.append("Driver Vendor    :  " + (this.getDriverVendor() == null ? "null" : this.getDriverVendor()) + "\n");
        buff.append("Driver Type      :  " + (this.getType() == null ? "null" : this.getType()) + "\n");
        buff.append("Driver Class     :  " + (this.getDriverClassName() == null ? "null" : this.getDriverClassName()) + "\n");
        buff.append("XA ?             :  " + Boolean.valueOf(this.isForXA()).toString() + "\n");
        buff.append("URLHelperClass   :  " + (this.getURLHelperClassName() == null ? "null" : this.getURLHelperClassName()) + "\n");
        buff.append("DBMS Version     :  " + (this.getDbmsVersion() == null ? "null" : this.getDbmsVersion()) + "\n");
        buff.append("DBMS Name        :  " + (this.getDbmsName() == null ? "null" : this.getDbmsName()) + "\n");
        buff.append("DBMS Host        :  " + (this.getDbmsHost() == null ? "null" : this.getDbmsHost()) + "\n");
        buff.append("isHostRequired   :  " + Boolean.valueOf(this.isHostNameRequired()).toString() + "\n");
        buff.append("DBMS Port        :  " + (this.getDbmsPort() == null ? "null" : this.getDbmsPort()) + "\n");
        buff.append("isPortRequired   :  " + Boolean.valueOf(this.isPortRequired()).toString() + "\n");
        buff.append("DBMS password    :  " + (this.getPassword() == null ? "null" : this.getPassword()) + "\n");
        buff.append("DBMS user        :  " + (this.getUserName() == null ? "null" : this.getUserName()) + "\n");
        buff.append("DBMS test sql    :  " + (this.getTestSQL() == null ? "null" : this.getTestSQL()) + "\n");
        buff.append("Description      :  " + (this.getDescription() == null ? "null" : this.getDescription()) + "\n");
        return buff.toString();
    }

    private void setWellKnownAttribute(String attributeName, String attributeValue) {
        JDBCDriverAttribute prop = null;
        if (this.getDriverAttributes().containsKey(attributeName)) {
            prop = this.getDriverAttributes().get(attributeName);
        } else {
            prop = new JDBCDriverAttribute(this.metaInfo);
            prop.setName(attributeValue);
        }
        prop.setValue(attributeValue);
        this.getDriverAttributes().put(attributeName, prop);
    }

    private void setUnknownAttribute(String attributeName, String attributeValue) {
        if (!this.getDriverAttributes().containsKey(attributeName)) {
            throw new AssertionError((Object)("Trying to set a value '" + attributeValue + "' on an unknown attribute '" + attributeName + "'"));
        }
        JDBCDriverAttribute prop = this.getDriverAttributes().get(attributeName);
        prop.setValue(attributeValue);
        this.getDriverAttributes().put(attributeName, prop);
    }

    private String getWellKnownAttribute(String attributeName) {
        return this.getWellKnownAttribute(attributeName, false);
    }

    private String getWellKnownAttribute(String attributeName, boolean returnDefault) {
        if (this.getDriverAttributes().containsKey(attributeName)) {
            JDBCDriverAttribute prop = this.getDriverAttributes().get(attributeName);
            if (prop.getValue() != null) {
                if (this.fillRequired && prop.getValue().equals("")) {
                    return attributeName;
                }
                return prop.getValue();
            }
            if (returnDefault && prop.getDefaultValue() != null) {
                return prop.getDefaultValue();
            }
            if (this.fillRequired) {
                return attributeName;
            }
        }
        return null;
    }

    private String getDefaultFor(String attributeName) {
        if (this.getAttribute(attributeName) != null) {
            return this.getAttribute(attributeName).getDefaultValue();
        }
        return null;
    }

    private JDBCDriverAttribute getAttribute(String attributeName) {
        if (this.getDriverAttributes().containsKey(attributeName)) {
            return this.getDriverAttributes().get(attributeName);
        }
        return null;
    }

    private boolean isAttributeRequired(String attributeName) {
        if (this.getDriverAttributes().containsKey(attributeName)) {
            JDBCDriverAttribute prop = this.getDriverAttributes().get(attributeName);
            return prop.isRequired();
        }
        return false;
    }

    public int compareTo(Object o) throws ClassCastException {
        JDBCDriverInfo info1 = (JDBCDriverInfo)o;
        return this.getDriverPK().compareTo(info1.getDriverPK());
    }
}

