/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.util.Properties;
import weblogic.remoteconsole.jdbc.common.internal.JDBCUtil;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoException;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelper;

public class InformixJDBC4DriverURLHelper
extends JDBCURLHelper {
    @Override
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        if (!this.isValid(info.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(info.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        if (!this.isValid(info.getUserName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbUsernameReqd());
        }
        if (!this.isValid(info.getPassword())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPasswordReqd());
        }
        if (!this.isValid(info.getDbmsName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbNameReqd());
        }
        if (!this.isValid(this.getOtherAttribute("informixserver", info))) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().informixSvrNameReqd());
        }
        return "jdbc:informix-sqli://" + info.getDbmsHost() + ":" + info.getDbmsPort() + "/" + info.getDbmsName() + ":informixServer=" + this.getOtherAttribute("informixserver", info);
    }

    @Override
    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jdbcdriverinfo = this.getJDBCInfo();
        Properties properties = new Properties();
        properties.put("user", jdbcdriverinfo.getUserName());
        properties.put("url", this.getURL());
        properties.put("portNumber", jdbcdriverinfo.getDbmsPort());
        properties.put("databaseName", jdbcdriverinfo.getDbmsName());
        properties.put("ifxIFXHOST", jdbcdriverinfo.getDbmsHost());
        properties.put("serverName", this.getOtherAttribute("informixserver", jdbcdriverinfo));
        return properties;
    }
}

