/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.util.Properties;
import weblogic.remoteconsole.jdbc.common.internal.JDBCUtil;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoException;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelper;

public class InetMSSQLJDBC4DriverURLHelper
extends JDBCURLHelper {
    @Override
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        if (!this.isValid(info.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        String ret = "jdbc:inetdae7:" + info.getDbmsHost();
        if (info.getDbmsPort() != null) {
            ret = ret + ":" + info.getDbmsPort();
        }
        return ret;
    }

    @Override
    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        if (!this.isValid(info.getUserName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbUsernameReqd());
        }
        Properties props = new Properties();
        props.put("user", info.getUserName());
        if (this.isValid(info.getDbmsName())) {
            props.put("db", info.getDbmsName());
        }
        return props;
    }
}

