/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.jdbc.utils;

import java.util.Properties;
import weblogic.remoteconsole.jdbc.common.internal.JDBCUtil;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfo;
import weblogic.remoteconsole.jdbc.utils.JDBCDriverInfoException;
import weblogic.remoteconsole.jdbc.utils.JDBCURLHelper;

public class DDInformixJDBC4DriverURLHelper
extends JDBCURLHelper {
    @Override
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        if (!this.isValid(info.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(info.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        if (!this.isValid(info.getUserName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbUsernameReqd());
        }
        if (!this.isValid(info.getPassword())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPasswordReqd());
        }
        if (!this.isValid(info.getDbmsName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbNameReqd());
        }
        if (!this.isValid(this.getOtherAttribute("informixserver", info))) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().informixSvrNameReqd());
        }
        return "jdbc:datadirect:informix://" + info.getDbmsHost() + ":" + info.getDbmsPort() + ";informixServer=" + this.getOtherAttribute("informixserver", info) + ";databaseName=" + info.getDbmsName();
    }

    @Override
    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo info = this.getJDBCInfo();
        Properties props = new Properties();
        props.put("serverName", info.getDbmsHost());
        props.put("portNumber", info.getDbmsPort());
        props.put("user", info.getUserName());
        props.put("databaseName", info.getDbmsName());
        props.put("informixServer", this.getOtherAttribute("informixserver", info));
        return props;
    }
}

