/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import weblogic.remoteconsole.server.repo.DateAsLongValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableRow;

public class X509CertificateInfoVBeanUtils {
    private X509CertificateInfoVBeanUtils() {
    }

    public static List<TableRow> processCertificates(InvocationContext ic, JsonArray certificates) {
        TreeMap<String, TableRow> identifierToRow = new TreeMap<String, TableRow>();
        for (int i = 0; certificates != null && i < certificates.size(); ++i) {
            TableRow row = X509CertificateInfoVBeanUtils.processCertificate(ic, certificates.getJsonObject(i));
            String identifier = row.getIdentifier();
            identifierToRow.put(identifier, row);
        }
        return new ArrayList<TableRow>(identifierToRow.values());
    }

    private static TableRow processCertificate(InvocationContext ic, JsonObject certificateInfo) {
        TableRow row = new TableRow();
        String alias = X509CertificateInfoVBeanUtils.getStringField(certificateInfo, "alias");
        row.setIdentifier(alias);
        row.getCells().add(new TableCell("Alias", new StringValue(alias)));
        row.getCells().add(new TableCell("EntryType", new StringValue(X509CertificateInfoVBeanUtils.getStringField(certificateInfo, "entryType"))));
        row.getCells().add(new TableCell("Subject", new StringValue(X509CertificateInfoVBeanUtils.getStringField(certificateInfo, "subject"))));
        row.getCells().add(new TableCell("Issuer", new StringValue(X509CertificateInfoVBeanUtils.getStringField(certificateInfo, "issuer"))));
        row.getCells().add(new TableCell("SerialNumber", new StringValue(X509CertificateInfoVBeanUtils.getStringField(certificateInfo, "serialNumber"))));
        Long val = X509CertificateInfoVBeanUtils.getLongField(certificateInfo, "notBefore");
        if (val != null) {
            row.getCells().add(new TableCell("NotBefore", new DateAsLongValue(val)));
        }
        if ((val = X509CertificateInfoVBeanUtils.getLongField(certificateInfo, "notAfter")) != null) {
            row.getCells().add(new TableCell("NotAfter", new DateAsLongValue(val)));
        }
        return row;
    }

    private static String getStringField(JsonObject jo, String field) {
        if (jo.containsKey((Object)field) && !jo.isNull(field)) {
            return jo.getString(field);
        }
        return null;
    }

    private static Long getLongField(JsonObject jo, String field) {
        return jo.containsKey((Object)field) ? Long.valueOf(jo.getJsonNumber(field).longValueExact()) : null;
    }
}

