/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.utils.Message;
import weblogic.remoteconsole.customizers.CustomizerUtils;
import weblogic.remoteconsole.server.PersistenceManager;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.DateValue;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepo;
import weblogic.remoteconsole.server.utils.ResponseHelper;
import weblogic.remoteconsole.server.utils.WebLogicRestClient;
import weblogic.remoteconsole.server.utils.WebLogicRestClientException;
import weblogic.remoteconsole.server.utils.WebLogicRestClientHelper;
import weblogic.remoteconsole.server.utils.WebLogicRestRequest;

public class WLDFDataAccessRuntimeMBeanCustomizer {
    private static final Logger LOGGER = Logger.getLogger(WLDFDataAccessRuntimeMBeanCustomizer.class.getName());
    private static final long RECORD_LIMIT = Long.MAX_VALUE;
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");

    private WLDFDataAccessRuntimeMBeanCustomizer() {
    }

    public static void customizeDownloadLogsInputForm(InvocationContext ic, Page page) {
        StringValue logFileDirectoryValue = new StringValue(WLDFDataAccessRuntimeMBeanCustomizer.getDirectoryName(ic));
        List<FormProperty> oldProperties = page.asForm().getProperties();
        List<FormProperty> newProperties = null;
        Date sinceDate = WLDFDataAccessRuntimeMBeanCustomizer.getSinceDate(ic);
        Date untilDate = new Date(System.currentTimeMillis());
        newProperties = List.of(CustomizerUtils.createFormProperty("LogFileDirectory", oldProperties, logFileDirectoryValue), CustomizerUtils.createFormProperty("Since", oldProperties, new DateValue(sinceDate)), CustomizerUtils.createFormProperty("Until", oldProperties, new DateValue(untilDate)), CustomizerUtils.createFormProperty("MaxRecords", oldProperties, new LongValue(-1L)));
        oldProperties.clear();
        oldProperties.addAll(newProperties);
    }

    private static Date getSinceDate(InvocationContext ic) {
        String logFile = "";
        BeanTreePath beanTreePath = null;
        if (ic.getIdentifiers() != null) {
            if (ic.getIdentifiers().size() > 1) {
                return null;
            }
            logFile = ic.getBeanTreePath().getLastSegment().getKey();
            String serverName = ic.getIdentifiers().get(0);
            String path = "DomainRuntime.CombinedServerRuntimes." + serverName + ".ServerRuntime.WLDFRuntime.WLDFAccessRuntime.WLDFDataAccessRuntimes." + logFile;
            beanTreePath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path(path));
        } else {
            if (ic.getIdentities() != null) {
                if (ic.getIdentities().size() > 1) {
                    return null;
                }
                logFile = ic.getIdentities().get(0).getPath().getLastComponent();
            } else {
                logFile = ic.getBeanTreePath().getPath().getLastComponent();
            }
            beanTreePath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), ic.getBeanTreePath().getPath().childPath(logFile));
        }
        InvocationContext variableIC = new InvocationContext(ic, beanTreePath);
        BeanTypeDef typeDef = beanTreePath.getTypeDef();
        BeanPropertyDef earliestAvailableTimestampPropertyDef = typeDef.getPropertyDef(new Path("EarliestAvailableTimestamp"));
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(variableIC, false);
        builder.addProperty(beanTreePath, earliestAvailableTimestampPropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        BeanSearchResults beanResults = searchResults.getBean(beanTreePath);
        if (beanResults == null) {
            throw weblogic.remoteconsole.server.repo.Response.notFoundException();
        }
        long earliestAvailableTimestamp = beanResults.getValue(earliestAvailableTimestampPropertyDef).asLong().getValue();
        return new Date(earliestAvailableTimestamp);
    }

    private static String getFileNameToDownload(InvocationContext ic) {
        String serverName = "";
        String logFile = "";
        if (ic.getIdentifiers() != null) {
            logFile = ic.getBeanTreePath().getLastSegment().getKey();
            serverName = ic.getIdentifiers().get(0);
        } else if (ic.getIdentities() != null) {
            serverName = (String)ic.getIdentities().get(0).getPath().getComponents().get(2);
            logFile = ic.getIdentities().get(0).getPath().getLastComponent();
        } else {
            serverName = (String)ic.getBeanTreePath().getPath().getComponents().get(2);
            logFile = ic.getBeanTreePath().getPath().getLastComponent();
        }
        logFile = logFile.replace(File.separator, "_");
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        return serverName + "_" + logFile + "_" + simpleDateFormat.format(timestamp);
    }

    public static weblogic.remoteconsole.server.repo.Response<Value> downloadLogs(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        String logFileName = WLDFDataAccessRuntimeMBeanCustomizer.getFileNameToDownload(ic);
        return WLDFDataAccessRuntimeMBeanCustomizer.doDownload(ic, pageActionDef, formProperties, logFileName);
    }

    private static weblogic.remoteconsole.server.repo.Response<Value> doDownload(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties, String logFileName) {
        weblogic.remoteconsole.server.repo.Response<Value> response = new weblogic.remoteconsole.server.repo.Response<Value>();
        String fileFormat = WLDFDataAccessRuntimeMBeanCustomizer.getFormProperty(formProperties, "FileFormat");
        String extension = fileFormat.equals("JSON") ? ".json" : ".txt";
        String outputFormat = fileFormat.equals("JSON") ? "application/json" : "text/plain";
        String logFileDirectory = WLDFDataAccessRuntimeMBeanCustomizer.getFormProperty(formProperties, "LogFileDirectory");
        if (logFileName == null) {
            logFileName = WLDFDataAccessRuntimeMBeanCustomizer.getFormProperty(formProperties, "LogFileName");
        }
        String fullFilePath = logFileDirectory + File.separatorChar + logFileName + extension;
        File file = new File(fullFilePath);
        try {
            Files.createDirectories(Paths.get(logFileDirectory, new String[0]), new FileAttribute[0]);
        }
        catch (Exception ex) {
            response.setServiceNotAvailable();
            response.addMessage(new Message(Message.Severity.FAILURE, ic.getLocalizer().localizeString(LocalizedConstants.DOWNLOADLOGFILE_ERROR, new Object[0]) + file.toString()));
            return response;
        }
        String wlsSince = WLDFDataAccessRuntimeMBeanCustomizer.getDateTime("Since", formProperties);
        String wlsUntil = WLDFDataAccessRuntimeMBeanCustomizer.getDateTime("Until", formProperties);
        long wlsMaxRecords = WLDFDataAccessRuntimeMBeanCustomizer.getRecordLimit(formProperties, "MaxRecords");
        String serverName = (String)ic.getBeanTreePath().getPath().getComponents().get(2);
        String logFile = ic.getBeanTreePath().getPath().getLastComponent();
        BeanTreePath beanTreePath = BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), new Path("DomainRuntime.ServerRuntimes." + serverName + ".WLDFRuntime.WLDFAccessRuntime.WLDFDataAccessRuntimes." + logFile));
        try {
            new Thread(() -> WLDFDataAccessRuntimeMBeanCustomizer.customizerLogs(ic, file, outputFormat, wlsSince, wlsUntil, wlsMaxRecords, beanTreePath)).start();
            response.addMessage(new Message(Message.Severity.SUCCESS, file.toString()));
        }
        catch (Exception ex) {
            response.setServiceNotAvailable();
            response.addMessage(new Message(Message.Severity.FAILURE, ic.getLocalizer().localizeString(LocalizedConstants.DOWNLOADLOGFILE_ERROR, new Object[0]) + file.toString()));
        }
        return response;
    }

    private static String getFormProperty(List<FormProperty> formProperties, String propName) {
        FormProperty formProperty = CustomizerUtils.findOptionalFormProperty(propName, formProperties);
        if (formProperty != null) {
            return formProperty.getValue().asSettable().getValue().asString().getValue();
        }
        return "";
    }

    private static long getRecordLimit(List<FormProperty> formProperties, String propName) {
        FormProperty formProperty = CustomizerUtils.findOptionalFormProperty(propName, formProperties);
        if (formProperty != null) {
            long limit = formProperty.getValue().asSettable().getValue().asLong().getValue();
            if (limit < 0L) {
                return Long.MAX_VALUE;
            }
            return limit;
        }
        return Long.MAX_VALUE;
    }

    private static String getDirectoryName(InvocationContext ic) {
        String persistenceDirectoryPath = PersistenceManager.getPersistenceFilePath(ic);
        Object dirName = persistenceDirectoryPath == null ? System.getProperty("java.io.tmpdir") : persistenceDirectoryPath + "/downloads";
        return dirName;
    }

    private static Path getRestActionPath(InvocationContext ic, BeanTreePath beanPath, String actionName) {
        Path restActionPath = new Path("domainRuntime");
        restActionPath.addPath(WebLogicRestBeanRepo.getTreeRelativeRestPath(beanPath));
        restActionPath.addComponent(actionName);
        return WebLogicRestBeanRepo.shortcutAdminServerRuntimePath(ic, restActionPath);
    }

    private static String getDateTime(String propName, List<FormProperty> formProperties) {
        Date date;
        FormProperty dateFormProperty = CustomizerUtils.findOptionalFormProperty(propName, formProperties);
        if (dateFormProperty != null && (date = dateFormProperty.getValue().asSettable().getValue().asDate().getValue()) != null) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(date);
        }
        return null;
    }

    private static weblogic.remoteconsole.server.repo.Response<JsonObject> customizerLogs(InvocationContext ic, File file, String outputFormat, String since, String until, long maxRecords, BeanTreePath realPath) {
        weblogic.remoteconsole.server.repo.Response<JsonObject> response = new weblogic.remoteconsole.server.repo.Response<JsonObject>();
        JsonObject requestBody = null;
        requestBody = since != null ? (until != null ? Json.createObjectBuilder().add("since", (JsonValue)Json.createValue((String)since)).add("until", (JsonValue)Json.createValue((String)until)).add("limit", (JsonValue)Json.createValue((long)maxRecords)).build() : Json.createObjectBuilder().add("since", (JsonValue)Json.createValue((String)since)).add("limit", (JsonValue)Json.createValue((long)maxRecords)).build()) : (until != null ? Json.createObjectBuilder().add("until", (JsonValue)Json.createValue((String)until)).add("limit", (JsonValue)Json.createValue((long)maxRecords)).build() : Json.createObjectBuilder().add("limit", (JsonValue)Json.createValue((long)maxRecords)).build());
        Path restActionPath = WLDFDataAccessRuntimeMBeanCustomizer.getRestActionPath(ic, realPath, "search");
        try {
            LOGGER.fine("writing out to : " + file.getName());
            Response restResponse = WLDFDataAccessRuntimeMBeanCustomizer.webLogicRestInvoker_post(ic, restActionPath, requestBody, false, false, false, outputFormat);
            if (restResponse == null) {
                return response.setServiceNotAvailable();
            }
            int status = restResponse.getStatus();
            if (Response.Status.NOT_FOUND.getStatusCode() == status) {
                return response.setNotFound();
            }
            if (Response.Status.BAD_REQUEST.getStatusCode() == status) {
                return response.setUserBadRequest();
            }
            try (InputStream is = (InputStream)restResponse.readEntity(InputStream.class);
                 FileOutputStream os = new FileOutputStream(file, false);){
                is.transferTo(os);
            }
        }
        catch (IOException ex) {
            LOGGER.severe(ex.getLocalizedMessage());
            return response.setServiceNotAvailable();
        }
        response.setSuccess(null);
        return response;
    }

    private static Response webLogicRestInvoker_post(InvocationContext ic, Path path, JsonObject requestBody, boolean expandedValues, boolean saveChanges, boolean asynchronous, String acceptType) {
        WebLogicRestRequest.Builder builder = WebLogicRestRequest.builder();
        builder.root("/management/weblogic/12.2.1.0.0");
        try {
            Response restResponse = WLDFDataAccessRuntimeMBeanCustomizer.webLogicRestClient_post(builder.connection(ic.getConnection()).path(path.getComponents()).saveChanges(saveChanges).expandedValues(expandedValues).asynchronous(asynchronous).internal(true).build(), requestBody, acceptType);
            return restResponse;
        }
        catch (WebLogicRestClientException e) {
            LOGGER.log(Level.WARNING, "Unexpected WebLogic Rest exception", e);
            return null;
        }
    }

    public static Response webLogicRestClient_post(WebLogicRestRequest request, JsonObject data, String acceptType) throws WebLogicRestClientException {
        return WLDFDataAccessRuntimeMBeanCustomizer.webLogicRestClient_post2(request, (Entity<Object>)Entity.entity((Object)data, (String)"application/json"), acceptType);
    }

    public static Response webLogicRestClient_post2(WebLogicRestRequest request, Entity<Object> entity, String acceptType) throws WebLogicRestClientException {
        WebTarget webTarget = WebLogicRestClient.getWebTarget(request);
        MultivaluedMap<String, Object> headers = WebLogicRestClientHelper.createHeaders(request);
        Response response = null;
        try {
            response = (Response)webTarget.request().headers(headers).accept(new String[]{acceptType}).post(entity, Response.class);
            if (WebLogicRestClientHelper.isErrorResponse("POST", response.getStatus())) {
                response = WebLogicRestClientHelper.getWebLogicRestErrorMessages(response);
            }
        }
        catch (ProcessingException pe) {
            if (response != null) {
                response.close();
            }
            response = WebLogicRestClient.handleProcessingException(pe);
        }
        catch (Exception e) {
            if (response != null) {
                response.close();
            }
            e.printStackTrace();
            response = ResponseHelper.createExceptionResponse(e);
        }
        return response;
    }
}

