/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.CustomPagePropertyDef;
import weblogic.remoteconsole.common.repodef.CustomSliceFormDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.SliceFormDef;
import weblogic.remoteconsole.customizers.CustomizerUtils;
import weblogic.remoteconsole.customizers.Source;
import weblogic.remoteconsole.server.providers.AdminServerDataProvider;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableRow;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestInvoker;

public class UserGroupMBeanCustomizer {
    private static String FILTER_CACHE_LOCK = new String();
    private static final int MAX_USERS = 1000;
    private static final int MAX_GROUPS = 1000;
    private static FilterCache filterCache = new FilterCache();

    public static void customizeFilterActionInputForm(InvocationContext ic, Page page) {
        List<FormProperty> oldProperties = page.asForm().getProperties();
        List<FormProperty> newProperties = List.of(CustomizerUtils.createFormProperty("NameFilter", oldProperties, new StringValue(UserGroupMBeanCustomizer.getNameWildCard(ic))));
        oldProperties.clear();
        oldProperties.addAll(newProperties);
    }

    public static Response<Value> setTableFilter(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        String nameFilter = formProperties.get(0).getValue().asSettable().getValue().asString().getValue();
        if ("*".equals(nameFilter)) {
            nameFilter = null;
        }
        UserGroupMBeanCustomizer.recordFilter(ic, nameFilter);
        return new Response<Object>().setSuccess(null);
    }

    public static void customizeReflectingUsersTable(InvocationContext ic, Page page) {
        UserGroupMBeanCustomizer.customizeUsersTable(ic, page);
        AuthenticationProviderCapabilities capabilities = new AuthenticationProviderCapabilities(ic);
        if (!capabilities.isUserEditor()) {
            page.forceReadOnly();
        }
    }

    public static void customizeReflectingGroupsTable(InvocationContext ic, Page page) {
        UserGroupMBeanCustomizer.customizeUsersTable(ic, page);
        AuthenticationProviderCapabilities capabilities = new AuthenticationProviderCapabilities(ic);
        if (!capabilities.isGroupEditor()) {
            page.forceReadOnly();
        }
    }

    public static void customizeUsersTable(InvocationContext ic, Page page) {
        UserGroupMBeanCustomizer.customizeTable(ic, page, 1000, LocalizedConstants.LEGACY_TOO_MANY_USERS, LocalizedConstants.TOO_MANY_USERS, LocalizedConstants.USERS_FILTER);
    }

    public static void customizeGroupsTable(InvocationContext ic, Page page) {
        UserGroupMBeanCustomizer.customizeTable(ic, page, 1000, LocalizedConstants.LEGACY_TOO_MANY_GROUPS, LocalizedConstants.TOO_MANY_GROUPS, LocalizedConstants.GROUPS_FILTER);
    }

    private static void customizeTable(InvocationContext ic, Page page, int max, LocalizableString legacyTooMany, LocalizableString tooMany, LocalizableString filter) {
        String providerStatus;
        List<TableRow> rows;
        String nameFilter;
        StringBuilder sb = new StringBuilder();
        if (UserGroupMBeanCustomizer.supportsFiltering(ic) && (nameFilter = UserGroupMBeanCustomizer.getNameFilter(ic)) != null) {
            sb.append(ic.getLocalizer().localizeString(filter, nameFilter));
        }
        if ((rows = page.asTable().getRows()).size() > max) {
            while (rows.size() > max) {
                rows.remove(max);
            }
            if (UserGroupMBeanCustomizer.supportsFiltering(ic)) {
                sb.append(ic.getLocalizer().localizeString(tooMany, new Object[0]));
            } else {
                sb.append(ic.getLocalizer().localizeString(legacyTooMany, max));
            }
        } else if (rows.isEmpty() && (providerStatus = UserGroupMBeanCustomizer.getProviderStatus(ic)) != null) {
            sb.append(ic.getLocalizer().localizeString(LocalizedConstants.SECURITY_PROVIDER_DATA_NOT_AVAILABLE, providerStatus));
        }
        sb.append(ic.getLocalizer().localizeString(page.getPageDef().getIntroductionHTML(), new Object[0]));
        page.setLocalizedIntroductionHTML(sb.toString());
    }

    public static List<TableRow> getUsers(InvocationContext ic, BeanReaderRepoSearchResults searchResults) {
        return UserGroupMBeanCustomizer.getCollection(ic, 1000);
    }

    public static List<TableRow> getGroups(InvocationContext ic, BeanReaderRepoSearchResults searchResults) {
        return UserGroupMBeanCustomizer.getCollection(ic, 1000);
    }

    private static List<TableRow> getCollection(InvocationContext ic, int max) {
        TreeMap<String, TableRow> sortedRows = new TreeMap<String, TableRow>();
        JsonArray items = UserGroupMBeanCustomizer.getCollectionJson(ic, max);
        for (int i = 0; i < items.size(); ++i) {
            TableRow row = new TableRow();
            JsonObject item = items.getJsonObject(i);
            String name = CustomizerUtils.getStringField(item, "name");
            String description = CustomizerUtils.getStringField(item, "description");
            BeanTreePath collectionBTP = ic.getBeanTreePath();
            BeanTreePath itemBTP = BeanTreePath.create(collectionBTP.getBeanRepo(), collectionBTP.getPath().childPath(name));
            List<TableCell> cells = row.getCells();
            cells.add(new TableCell("identity", itemBTP));
            cells.add(new TableCell("Name", new StringValue(name)));
            cells.add(new TableCell("Description", new StringValue(description)));
            sortedRows.put(name, row);
        }
        return new ArrayList<TableRow>(sortedRows.values());
    }

    private static JsonArray getCollectionJson(InvocationContext ic, int max) {
        List components = ic.getBeanTreePath().getPath().getComponents();
        String realmName = (String)components.get(2);
        String providerName = (String)components.get(4);
        String collectionName = (String)components.get(5);
        JsonObject query = Json.createObjectBuilder().add("fields", Json.createArrayBuilder()).add("children", Json.createObjectBuilder().add("realmsSecurityData", Json.createObjectBuilder().add("fields", Json.createArrayBuilder()).add("name", Json.createArrayBuilder().add(realmName)).add("children", Json.createObjectBuilder().add("authenticationProviders", Json.createObjectBuilder().add("fields", Json.createArrayBuilder()).add("name", Json.createArrayBuilder().add(providerName)).add("children", Json.createObjectBuilder().add(StringUtils.getRestName((String)collectionName), Json.createObjectBuilder().add("fields", Json.createArrayBuilder().add("name").add("description")).add("nameWildCard", UserGroupMBeanCustomizer.getNameWildCard(ic)).add("maxToReturn", max))))))).build();
        JsonObject invokeResponse = WebLogicRestInvoker.post(ic, new Path("serverConfig.search"), query, false, false, false).getResults();
        JsonArray realms = UserGroupMBeanCustomizer.getCollectionJson(invokeResponse, "realmsSecurityData");
        JsonObject realm = UserGroupMBeanCustomizer.getChildJson(realms, realmName);
        JsonArray providers = UserGroupMBeanCustomizer.getCollectionJson(realm, "authenticationProviders");
        JsonObject provider = UserGroupMBeanCustomizer.getChildJson(providers, providerName);
        JsonArray items = UserGroupMBeanCustomizer.getCollectionJson(provider, StringUtils.getRestName((String)collectionName));
        if (items == null) {
            items = Json.createArrayBuilder().build();
        }
        return items;
    }

    private static JsonArray getCollectionJson(JsonObject parent, String collectionName) {
        if (parent == null) {
            return null;
        }
        if (!parent.containsKey((Object)collectionName)) {
            return null;
        }
        return parent.getJsonObject(collectionName).getJsonArray("items");
    }

    private static JsonObject getChildJson(JsonArray items, String childName) {
        if (items == null) {
            return null;
        }
        for (int i = 0; i < items.size(); ++i) {
            JsonObject child = items.getJsonObject(i);
            if (!childName.equals(CustomizerUtils.getStringField(child, "name"))) continue;
            return child;
        }
        return null;
    }

    public static SettableValue getStatus(InvocationContext ic, @Source(property="Status") SettableValue statusValue) {
        String status = statusValue.getValue().asString().getValue();
        if ("OK".equals(status)) {
            status = ic.getLocalizer().localizeString(LocalizedConstants.USER_GROUP_READER_STATUS_OK, new Object[0]);
        }
        return new SettableValue((Value)new StringValue(status), false);
    }

    public static PageDef customizeUserPageDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        AuthenticationProviderCapabilities capabilities = new AuthenticationProviderCapabilities(ic);
        SliceFormDef uncustomizedFormDef = uncustomizedPageDef.asSliceFormDef();
        CustomSliceFormDef customizedFormDef = new CustomSliceFormDef(uncustomizedFormDef);
        if (!capabilities.isMemberGroupLister()) {
            CustomizerUtils.removeSliceIfPresent(customizedFormDef, "Membership");
        }
        if (!capabilities.isPasswordEditor()) {
            CustomizerUtils.removeSliceIfPresent(customizedFormDef, "Password");
        }
        if (!capabilities.isUserEditor()) {
            UserGroupMBeanCustomizer.makePropertyReadOnlyIfPresent(customizedFormDef, "Description");
        }
        if (!capabilities.isGroupEditor()) {
            UserGroupMBeanCustomizer.makePropertyReadOnlyIfPresent(customizedFormDef, "Groups");
        }
        return customizedFormDef;
    }

    public static PageDef customizeGroupPageDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        AuthenticationProviderCapabilities capabilities = new AuthenticationProviderCapabilities(ic);
        SliceFormDef uncustomizedFormDef = uncustomizedPageDef.asSliceFormDef();
        CustomSliceFormDef customizedFormDef = new CustomSliceFormDef(uncustomizedFormDef);
        if (!capabilities.isMemberGroupLister()) {
            CustomizerUtils.removeSliceIfPresent(customizedFormDef, "Membership");
        }
        if (!capabilities.isGroupEditor()) {
            UserGroupMBeanCustomizer.makePropertyReadOnlyIfPresent(customizedFormDef, "Description");
            UserGroupMBeanCustomizer.makePropertyReadOnlyIfPresent(customizedFormDef, "Groups");
        }
        return customizedFormDef;
    }

    private static void makePropertyReadOnlyIfPresent(CustomSliceFormDef formDef, String property) {
        formDef.setPropertyDefs(UserGroupMBeanCustomizer.makePropertyReadOnlyIfPresent(formDef.getPropertyDefs(), property));
        formDef.setAdvancedPropertyDefs(UserGroupMBeanCustomizer.makePropertyReadOnlyIfPresent(formDef.getAdvancedPropertyDefs(), property));
    }

    private static List<PagePropertyDef> makePropertyReadOnlyIfPresent(List<PagePropertyDef> propertyDefs, String property) {
        ArrayList<PagePropertyDef> newPropertyDefs = new ArrayList<PagePropertyDef>();
        for (PagePropertyDef oldPropertyDef : propertyDefs) {
            if (property.equals(oldPropertyDef.getPropertyName())) {
                CustomPagePropertyDef newPropertyDef = new CustomPagePropertyDef(oldPropertyDef);
                newPropertyDef.setWritable(false);
                newPropertyDefs.add(newPropertyDef);
                continue;
            }
            newPropertyDefs.add(oldPropertyDef);
        }
        return newPropertyDefs;
    }

    private static String getProviderStatus(InvocationContext ic) {
        BeanTreePath collectionBTP = ic.getBeanTreePath();
        BeanTreePath providerBTP = BeanTreePath.create(collectionBTP.getBeanRepo(), collectionBTP.getPath().getParent());
        InvocationContext providerIC = new InvocationContext(ic, providerBTP);
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(providerIC, false);
        BeanPropertyDef statusPropertyDef = providerBTP.getTypeDef().getPropertyDef(new Path("Status"), true);
        if (statusPropertyDef != null) {
            String status;
            builder.addProperty(providerBTP, statusPropertyDef);
            Value statusValue = builder.search().getResults().getBean(providerBTP).getValue(statusPropertyDef);
            if (statusValue != null && !"OK".equals(status = statusValue.asString().getValue())) {
                return status;
            }
        }
        return null;
    }

    private static String getNameWildCard(InvocationContext ic) {
        String nameFilter = UserGroupMBeanCustomizer.supportsFiltering(ic) ? UserGroupMBeanCustomizer.getNameFilter(ic) : null;
        return nameFilter != null ? nameFilter : "*";
    }

    private static boolean supportsFiltering(InvocationContext ic) {
        return ic.getPageRepo().getBeanRepo().getBeanRepoDef().supportsCapabilities(List.of("UserGroupFiltering"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNameFilter(InvocationContext ic) {
        String string = FILTER_CACHE_LOCK;
        synchronized (string) {
            return UserGroupMBeanCustomizer.getFilterCache(ic).getNameFilter(ic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordFilter(InvocationContext ic, String nameFilter) {
        String string = FILTER_CACHE_LOCK;
        synchronized (string) {
            UserGroupMBeanCustomizer.getFilterCache(ic).setFilter(ic, nameFilter);
        }
    }

    private static FilterCache getFilterCache(InvocationContext ic) {
        String key = "USER_GROUP_FILTER_CACHE";
        Map<String, Object> providerCache = ((AdminServerDataProvider)ic.getProvider()).getCache();
        FilterCache filterCache = (FilterCache)providerCache.get(key);
        if (filterCache == null) {
            filterCache = new FilterCache();
            providerCache.put(key, filterCache);
        }
        return filterCache;
    }

    private static class AuthenticationProviderCapabilities {
        private static final String PROP_GROUP_EDITOR = "GroupEditor";
        private static final String PROP_MEMBER_GROUP_LISTER = "MemberGroupLister";
        private static final String PROP_PASSWORD_EDITOR = "PasswordEditor";
        private static final String PROP_USER_EDITOR = "UserEditor";
        private static final List<String> CAPABILITIES = List.of("GroupEditor", "MemberGroupLister", "PasswordEditor", "UserEditor");
        private Map<String, Boolean> capabilityToSupports = new HashMap<String, Boolean>();

        private AuthenticationProviderCapabilities(InvocationContext ic) {
            BeanTreePath btp = ic.getBeanTreePath();
            Path path = btp.getPath();
            Path providerPath = path.subPath(0, 5);
            BeanTreePath providerBTP = BeanTreePath.create(btp.getBeanRepo(), providerPath);
            InvocationContext providerIC = new InvocationContext(ic, providerBTP);
            BeanReaderRepoSearchBuilder builder = providerIC.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(providerIC, false);
            BeanTypeDef typeDef = btp.getBeanRepo().getBeanRepoDef().getTypeDef("ReflectingUserGroupAuthenticatorMBean");
            for (String capability : CAPABILITIES) {
                builder.addProperty(providerBTP, typeDef.getPropertyDef(new Path(capability)));
            }
            BeanReaderRepoSearchResults searchResults = builder.search().getResults();
            BeanSearchResults beanResults = searchResults.getBean(providerBTP);
            if (beanResults == null) {
                throw Response.notFoundException();
            }
            for (String capability : CAPABILITIES) {
                boolean val = false;
                Value value = beanResults.getValue(typeDef.getPropertyDef(new Path(capability)));
                val = value == null ? true : value.asBoolean().getValue();
                this.capabilityToSupports.put(capability, val);
            }
        }

        private boolean isGroupEditor() {
            return this.supports(PROP_GROUP_EDITOR);
        }

        private boolean isMemberGroupLister() {
            return this.supports(PROP_MEMBER_GROUP_LISTER);
        }

        private boolean isPasswordEditor() {
            return this.supports(PROP_PASSWORD_EDITOR);
        }

        private boolean isUserEditor() {
            return this.supports(PROP_USER_EDITOR);
        }

        private boolean supports(String capability) {
            return this.capabilityToSupports.containsKey(capability) ? this.capabilityToSupports.get(capability) : false;
        }
    }

    private static class FilterCache {
        private Map<String, String> keyToNameFilter = new HashMap<String, String>();

        private FilterCache() {
        }

        private void setFilter(InvocationContext ic, String nameFilter) {
            String key = this.getKey(ic);
            if (nameFilter == null) {
                this.keyToNameFilter.remove(key);
            } else {
                this.keyToNameFilter.put(key, nameFilter);
            }
        }

        private String getNameFilter(InvocationContext ic) {
            return this.keyToNameFilter.get(this.getKey(ic));
        }

        private String getKey(InvocationContext ic) {
            return ic.getBeanTreePath().getPath().toString();
        }
    }
}

