/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import weblogic.remoteconsole.customizers.Source;
import weblogic.remoteconsole.server.repo.IntValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.SettableValue;

public class ThreadPoolRuntimeMBeanCustomizer {
    private ThreadPoolRuntimeMBeanCustomizer() {
    }

    public static SettableValue getExecuteThreadActiveCount(InvocationContext ic, @Source(property="ExecuteThreadTotalCount") SettableValue total, @Source(property="ExecuteThreadIdleCount") SettableValue idle, @Source(property="StandbyThreadCount") SettableValue standby, @Source(property="StuckThreadCount") SettableValue stuck) {
        if (total == null) {
            return null;
        }
        int inactive = ThreadPoolRuntimeMBeanCustomizer.toInt(idle) + ThreadPoolRuntimeMBeanCustomizer.toInt(standby) + ThreadPoolRuntimeMBeanCustomizer.toInt(stuck);
        int active = ThreadPoolRuntimeMBeanCustomizer.toInt(total) - inactive;
        return new SettableValue(new IntValue(active));
    }

    private static int toInt(SettableValue value) {
        return value.getValue().asInt().getValue();
    }
}

