/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.common.repodef.BeanActionParamDef;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageActionParamDef;
import weblogic.remoteconsole.server.repo.BeanActionArg;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;

class SliceTableActionUtils {
    private SliceTableActionUtils() {
    }

    static Response<Value> invokeRowAction(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties, String beanActionName, String identifierParamName) {
        Response response = new Response();
        BeanTreePath btp = ic.getBeanTreePath();
        BeanActionDef beanActionDef = btp.getTypeDef().getActionDef(new Path(beanActionName));
        ArrayList<BeanActionArg> args = new ArrayList<BeanActionArg>();
        for (BeanActionParamDef beanParamDef : beanActionDef.getParamDefs()) {
            if (identifierParamName.equals(beanParamDef.getParamName())) {
                args.add(new BeanActionArg(beanParamDef, new StringValue(ic.getIdentifier())));
                continue;
            }
            args.add(new BeanActionArg(beanParamDef, SliceTableActionUtils.findParamValue(beanParamDef, formProperties)));
        }
        return ic.getPageRepo().getBeanRepo().asBeanReaderRepo().invokeAction(ic, btp, beanActionDef, args);
    }

    private static Value findParamValue(BeanActionParamDef beanParamDef, List<FormProperty> formProperties) {
        for (FormProperty formProperty : formProperties) {
            PageActionParamDef pageParamDef = formProperty.getFieldDef().asPageActionParamDef();
            if (!beanParamDef.getParamName().equals(pageParamDef.getParamName())) continue;
            return formProperty.getValue().asSettable().getValue();
        }
        throw new AssertionError((Object)("Could not find " + String.valueOf(beanParamDef) + " in " + String.valueOf(formProperties)));
    }
}

