/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.CustomBeanSearchResults;
import weblogic.remoteconsole.server.repo.DateValue;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SearchBeanResults;
import weblogic.remoteconsole.server.repo.SimpleSearch;
import weblogic.remoteconsole.server.repo.SimpleSearchManager;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableRow;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.SearchResponseMapper;

public class SimpleSearchMBeanCustomizer {
    private SimpleSearchMBeanCustomizer() {
    }

    public static void customizePage(InvocationContext ic, Page page) {
        String searchName = SimpleSearchMBeanCustomizer.getRecentSearchName(ic);
        if (searchName == null) {
            throw Response.notFoundException();
        }
        SimpleSearch search = SimpleSearchMBeanCustomizer.getSimpleSearchManager(ic).getSearchResults(ic, searchName).getResults();
        TreeMap<Path, TableRow> sorter = new TreeMap<Path, TableRow>();
        for (SearchBeanResults beanResults : search.getResults()) {
            TableRow row = new TableRow();
            String name = SearchResponseMapper.getBeanName(ic, beanResults);
            String path = SearchResponseMapper.getBeanPath(ic, beanResults);
            String type = SearchResponseMapper.getBeanType(ic, beanResults);
            row.getCells().add(new TableCell("Name", new StringValue(name)));
            row.getCells().add(new TableCell("Type", new StringValue(type)));
            row.getCells().add(new TableCell("Path", new StringValue(path)));
            row.getCells().add(new TableCell("identity", beanResults.getBeanTreePath()));
            sorter.put(SearchResponseMapper.getSortingKey(ic, beanResults), row);
        }
        page.asTable().getRows().addAll(sorter.values());
        page.setLocalizedIntroductionHTML(ic.getLocalizer().localizeString(page.getPageDef().getIntroductionHTML(), search.getName(), ic.getLocalizer().formatDate(search.getResultsDate())));
    }

    public static List<BeanSearchResults> getCollection(InvocationContext ic, BeanTreePath collectionPath, BeanReaderRepoSearchResults searchResults, List<BeanPropertyDef> propertyDefs) {
        BeanTypeDef typeDef = collectionPath.getTypeDef();
        ArrayList<BeanSearchResults> collectionResults = new ArrayList<BeanSearchResults>();
        String language = SimpleSearchMBeanCustomizer.getSimpleSearchManager(ic).getLanguage(ic);
        for (SimpleSearch search : SimpleSearchMBeanCustomizer.getRecentSearches(ic)) {
            String searchName = search.getName();
            BeanTreePath childPath = BeanTreePath.create(collectionPath.getBeanRepo(), collectionPath.getPath().childPath(searchName));
            CustomBeanSearchResults beanResults = new CustomBeanSearchResults(searchResults, childPath);
            beanResults.addPropertyResults(typeDef.getIdentityPropertyDef(), childPath);
            beanResults.addPropertyResults(typeDef.getPropertyDef(new Path("Name")), new StringValue(searchName));
            if (search.getResults() != null && search.getLanguage().equals(language)) {
                beanResults.addPropertyResults(typeDef.getPropertyDef(new Path("Date")), new DateValue(search.getResultsDate()));
                beanResults.addPropertyResults(typeDef.getPropertyDef(new Path("NumberOfMatches")), new LongValue(search.getResults().size()));
            }
            collectionResults.add(beanResults);
        }
        return collectionResults;
    }

    public static Value clearSearches(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        SimpleSearchMBeanCustomizer.getSimpleSearchManager(ic).clearSearches(ic);
        return null;
    }

    private static String getRecentSearchName(InvocationContext ic) {
        String search = ic.getBeanTreePath().getLastSegment().getKey();
        for (SimpleSearch s : SimpleSearchMBeanCustomizer.getRecentSearches(ic)) {
            if (!s.getName().equals(search)) continue;
            return search;
        }
        return null;
    }

    private static List<SimpleSearch> getRecentSearches(InvocationContext ic) {
        return SimpleSearchMBeanCustomizer.getSimpleSearchManager(ic).getRecentSearches(ic);
    }

    private static SimpleSearchManager getSimpleSearchManager(InvocationContext ic) {
        return ic.getPageRepo().asPageReaderRepo().getSimpleSearchManager(ic);
    }
}

