/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableRow;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestInvoker;

public class ServerRuntimeMBeanCustomizer {
    private ServerRuntimeMBeanCustomizer() {
    }

    public static List<TableRow> getJNDISliceTableRows(InvocationContext ic, BeanReaderRepoSearchResults searchResults) {
        return ServerRuntimeMBeanCustomizer.processBindings(ServerRuntimeMBeanCustomizer.getBindings(ic));
    }

    private static JsonArray getBindings(InvocationContext ic) {
        String serverName = ic.getBeanTreePath().getLastSegment().getKey();
        Path path = new Path("domainRuntime.JNDI");
        path.addComponent(serverName);
        boolean expandedValues = false;
        JsonObject getResponse = WebLogicRestInvoker.get(ic, path, expandedValues).getResults();
        return getResponse.getJsonArray("jndi");
    }

    private static List<TableRow> processBindings(JsonArray bindings) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        for (int i = 0; i < bindings.size(); ++i) {
            JsonObject binding = bindings.getJsonObject(i);
            String context = binding.getString("context");
            String name = binding.getString("name");
            String clazz = binding.getString("class");
            String toString = binding.getString("toString");
            String error = binding.getString("error", "");
            TableRow row = new TableRow();
            row.getCells().add(new TableCell("Context", new StringValue(context)));
            row.getCells().add(new TableCell("Name", new StringValue(name)));
            row.getCells().add(new TableCell("Class", new StringValue(clazz)));
            row.getCells().add(new TableCell("toString", new StringValue(toString)));
            row.getCells().add(new TableCell("error", new StringValue(error)));
            rows.add(row);
        }
        return rows;
    }
}

