/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.List;
import java.util.Map;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.customizers.HostnameVerifierCustomizer;
import weblogic.remoteconsole.customizers.ServerMBeanCreatableBeanCollectionResource;
import weblogic.remoteconsole.customizers.ServerMBeanDeletableCollectionChildBeanResource;
import weblogic.remoteconsole.customizers.Source;
import weblogic.remoteconsole.server.repo.BeanEditorRepo;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.BaseResource;

public class ServerMBeanCustomizer {
    private static final String IDENTITY = "identity";

    private ServerMBeanCustomizer() {
    }

    public static BaseResource createResource(InvocationContext ic) {
        BeanTreePath btp = ic.getBeanTreePath();
        if (btp.isCreatable() && btp.isCollection()) {
            return new ServerMBeanCreatableBeanCollectionResource();
        }
        if (btp.isDeletable() && btp.isCollectionChild()) {
            return new ServerMBeanDeletableCollectionChildBeanResource();
        }
        return null;
    }

    public static void deleteServer(InvocationContext ic, @Source(collection="/Domain/MigratableTargets", properties={"identity"}) List<Map<String, Value>> migratableTargets) {
        BeanEditorRepo beanEditorRepo = ic.getPageRepo().getBeanRepo().asBeanEditorRepo();
        String serverName = ic.getBeanTreePath().getLastSegment().getKey();
        String migratableTargetName = serverName + " (migratable)";
        for (Map<String, Value> migratableTarget : migratableTargets) {
            String name = migratableTarget.get(IDENTITY).asBeanTreePath().getLastSegment().getKey();
            if (!migratableTargetName.equals(name)) continue;
            beanEditorRepo.deleteBean(ic, migratableTarget.get(IDENTITY).asBeanTreePath()).getResults();
        }
        beanEditorRepo.deleteBean(ic, ic.getBeanTreePath()).getResults();
    }

    public static SettableValue getHostnameVerifierType(@Source(property="SSL.HostnameVerifier") SettableValue hostnameVerifier) {
        return HostnameVerifierCustomizer.getHostnameVerifierType(hostnameVerifier);
    }

    public static SettableValue getCustomHostnameVerifier(@Source(property="SSL.HostnameVerifier") SettableValue hostnameVerifier) {
        return HostnameVerifierCustomizer.getCustomHostnameVerifier(hostnameVerifier);
    }

    public static SettableValue getDomainAdministrationPortEnabled(InvocationContext ic) {
        BeanRepo beanRepo = ic.getBeanTreePath().getBeanRepo();
        BeanReaderRepoSearchBuilder builder = beanRepo.asBeanReaderRepo().createSearchBuilder(ic, false);
        BeanPropertyDef adminPortEnabledPropertyDef = beanRepo.getBeanRepoDef().getTypeDef("DomainMBean").getPropertyDef(new Path("AdministrationPortEnabled"));
        BeanTreePath domainBTP = BeanTreePath.create(beanRepo, new Path("Domain"));
        builder.addProperty(domainBTP, adminPortEnabledPropertyDef);
        BeanSearchResults searchResults = builder.search().getResults().getBean(domainBTP);
        Value administrationPortEnabledV = searchResults.getValue(adminPortEnabledPropertyDef);
        return new SettableValue(administrationPortEnabledV);
    }
}

