/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import javax.json.JsonObject;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.webapp.CreatableBeanCollectionResource;
import weblogic.remoteconsole.server.webapp.CreateHelper;

public class ServerMBeanCreatableBeanCollectionResource
extends CreatableBeanCollectionResource {
    @Override
    protected javax.ws.rs.core.Response createCollectionChild(JsonObject requestBody) {
        return new ServerMBeanCreateHelper().createBean(this.getInvocationContext(), requestBody);
    }

    private static class ServerMBeanCreateHelper
    extends CreateHelper {
        private ServerMBeanCreateHelper() {
        }

        @Override
        protected Response<Void> createBean(InvocationContext ic, List<FormProperty> formProperties) {
            Response response = new Response();
            Response<BeanTreePath> btpResponse = this.computeNewBeanPath(ic, formProperties);
            if (!btpResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(btpResponse);
            }
            BeanTreePath newServerBTP = btpResponse.getResults();
            BeanTreePath serverToCloneBTP = null;
            ArrayList<FormProperty> nonCloneFormProperties = new ArrayList<FormProperty>();
            for (FormProperty formProperty : formProperties) {
                if ("ServerToClone".equals(formProperty.getName())) {
                    serverToCloneBTP = formProperty.getValue().asSettable().getValue().asBeanTreePath();
                    continue;
                }
                nonCloneFormProperties.add(formProperty);
            }
            Response<Void> r = super.createBean(ic, nonCloneFormProperties);
            if (!r.isSuccess()) {
                return response.copyUnsuccessfulResponse(r);
            }
            if (serverToCloneBTP != null) {
                r = this.cloneBean(ic, serverToCloneBTP, newServerBTP, nonCloneFormProperties);
                if (!r.isSuccess()) {
                    this.cleanupFailedCreate(ic, newServerBTP);
                    return response.copyUnsuccessfulResponse(r);
                }
                response.addSuccessMessage(ic.getLocalizer().localizeString(LocalizedConstants.CLONED_SERVER_NOT_ALL_SETTINGS_COPIED, new Object[0]));
            }
            return response.setSuccess(null);
        }
    }
}

