/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.CustomCreateFormDef;
import weblogic.remoteconsole.common.repodef.CustomFormSectionDef;
import weblogic.remoteconsole.common.repodef.CustomFormSectionUsedIfDef;
import weblogic.remoteconsole.common.repodef.CustomLegalValueDef;
import weblogic.remoteconsole.common.repodef.CustomPagePropertyDef;
import weblogic.remoteconsole.common.repodef.CustomSliceFormDef;
import weblogic.remoteconsole.common.repodef.LegalValueDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.SliceFormDef;
import weblogic.remoteconsole.customizers.BeansCapabilitiesFinder;
import weblogic.remoteconsole.customizers.CustomizerUtils;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;

public class SecurityProviderMBeanCustomizer {
    private static final Set<String> STANDARD_SECURITY_PROVIDER_PROPERTY_NAMES = Set.of("identity", "Name", "Type", "Version", "Description", "ProviderClassName", "Realm");
    private static final Set<String> STANDARD_AUTHENTICATION_PROVIDER_PROPERTY_NAMES = Set.of("ControlFlag", "Base64DecodingRequired", "ActiveTypes", "SupportedTypes");

    public static PageDef customizeCreateAdjudicatorPageDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        return SecurityProviderMBeanCustomizer.customizeStandardCreateSecurityProviderPageDef(ic, uncustomizedPageDef, "AdjudicatorTypes");
    }

    public static PageDef customizeCreateAuditorPageDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        return SecurityProviderMBeanCustomizer.customizeStandardCreateSecurityProviderPageDef(ic, uncustomizedPageDef, "AuditorTypes");
    }

    public static PageDef customizeCreateAuthorizerPageDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        return SecurityProviderMBeanCustomizer.customizeStandardCreateSecurityProviderPageDef(ic, uncustomizedPageDef, "AuthorizerTypes");
    }

    public static PageDef customizeCreateCertPathProviderPageDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        return SecurityProviderMBeanCustomizer.customizeStandardCreateSecurityProviderPageDef(ic, uncustomizedPageDef, "CertPathProviderTypes");
    }

    public static PageDef customizeCreateCredentialMapperPageDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        return SecurityProviderMBeanCustomizer.customizeStandardCreateSecurityProviderPageDef(ic, uncustomizedPageDef, "CredentialMapperTypes");
    }

    public static PageDef customizeCreatePasswordValidatorPageDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        return SecurityProviderMBeanCustomizer.customizeStandardCreateSecurityProviderPageDef(ic, uncustomizedPageDef, "PasswordValidatorTypes");
    }

    public static PageDef customizeCreateRoleMapperPageDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        return SecurityProviderMBeanCustomizer.customizeStandardCreateSecurityProviderPageDef(ic, uncustomizedPageDef, "RoleMapperTypes");
    }

    private static PageDef customizeStandardCreateSecurityProviderPageDef(InvocationContext ic, PageDef uncustomizedPageDef, String supportedTypesPropertyName) {
        if (!SecurityProviderMBeanCustomizer.isAdminServerConnection(ic)) {
            return uncustomizedPageDef;
        }
        CustomCreateFormDef customizedCreateFormDef = new CustomCreateFormDef(uncustomizedPageDef.asCreateFormDef());
        customizedCreateFormDef.setPropertyDefs(SecurityProviderMBeanCustomizer.customizeTypeInProperties(customizedCreateFormDef.getPropertyDefs(), SecurityProviderMBeanCustomizer.getSupportedTypes(ic, supportedTypesPropertyName)));
        return customizedCreateFormDef;
    }

    public static PageDef customizeCreateAuthenticationProviderPageDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        if (!SecurityProviderMBeanCustomizer.isAdminServerConnection(ic)) {
            return uncustomizedPageDef;
        }
        CustomCreateFormDef customizedCreateFormDef = new CustomCreateFormDef(uncustomizedPageDef.asCreateFormDef());
        List<String> supportedTypes = SecurityProviderMBeanCustomizer.getSupportedTypes(ic, "AuthenticationProviderTypes");
        CustomFormSectionDef customizedMainSectionDef = new CustomFormSectionDef(customizedCreateFormDef.getSectionDefs().get(0));
        customizedMainSectionDef.setPropertyDefs(SecurityProviderMBeanCustomizer.customizeTypeInProperties(customizedMainSectionDef.getPropertyDefs(), supportedTypes));
        CustomFormSectionDef customizedAuthenticatorSectionDef = new CustomFormSectionDef(customizedCreateFormDef.getSectionDefs().get(1));
        SecurityProviderMBeanCustomizer.addAuthenticatorTypesToAuthenticatorSection(ic, customizedAuthenticatorSectionDef, supportedTypes);
        customizedCreateFormDef.setSectionDefs(List.of(customizedMainSectionDef, customizedAuthenticatorSectionDef));
        return customizedCreateFormDef;
    }

    private static void addAuthenticatorTypesToAuthenticatorSection(InvocationContext ic, CustomFormSectionDef customizedAuthenticatorSectionDef, List<String> supportedTypes) {
        if (!ic.getPageRepo().getBeanRepo().getBeanRepoDef().supportsCapabilities(List.of("BeansSupport"))) {
            return;
        }
        BeansCapabilitiesFinder authenticatorsFinder = new BeansCapabilitiesFinder();
        for (String supportedType : supportedTypes) {
            authenticatorsFinder.addPropertyCapability(supportedType, supportedType + "MBean", "controlFlag");
        }
        authenticatorsFinder.find(ic);
        ArrayList<Value> authenticatorTypes = new ArrayList<Value>();
        for (String supportedType : supportedTypes) {
            if (!authenticatorsFinder.supports(supportedType)) continue;
            authenticatorTypes.add(new StringValue(supportedType));
        }
        customizedAuthenticatorSectionDef.setUsedIfDef(new CustomFormSectionUsedIfDef(customizedAuthenticatorSectionDef.getUsedIfDef()).values(authenticatorTypes));
    }

    private static List<PagePropertyDef> customizeTypeInProperties(List<PagePropertyDef> uncustomizedPropertyDefs, List<String> supportedTypes) {
        ArrayList<PagePropertyDef> customizedPropertyDefs = new ArrayList<PagePropertyDef>();
        for (PagePropertyDef uncustomizedPropertyDef : uncustomizedPropertyDefs) {
            if ("Type".equals(uncustomizedPropertyDef.getPropertyName())) {
                customizedPropertyDefs.add(SecurityProviderMBeanCustomizer.customizeType(uncustomizedPropertyDef, supportedTypes));
                continue;
            }
            customizedPropertyDefs.add(uncustomizedPropertyDef);
        }
        return customizedPropertyDefs;
    }

    private static PagePropertyDef customizeType(PagePropertyDef uncustomizedTypePropertyDef, List<String> supportedTypes) {
        ArrayList<LegalValueDef> customizedLegalValueDefs = new ArrayList<LegalValueDef>();
        List<LegalValueDef> uncustomizedLegalValueDefs = uncustomizedTypePropertyDef.getLegalValueDefs();
        CustomPagePropertyDef customizedTypePropertyDef = new CustomPagePropertyDef(uncustomizedTypePropertyDef);
        for (String supportedType : supportedTypes) {
            customizedLegalValueDefs.add(SecurityProviderMBeanCustomizer.getTypeLegalValueDef(customizedTypePropertyDef, supportedType));
        }
        return customizedTypePropertyDef.legalValueDefs(customizedLegalValueDefs);
    }

    private static LegalValueDef getTypeLegalValueDef(PagePropertyDef customizedTypePropertyDef, String type) {
        for (LegalValueDef uncustomizedLegalValueDef : customizedTypePropertyDef.getLegalValueDefs()) {
            if (!type.equals(uncustomizedLegalValueDef.getValue())) continue;
            return new CustomLegalValueDef(uncustomizedLegalValueDef).fieldDef(customizedTypePropertyDef);
        }
        return new CustomLegalValueDef().fieldDef(customizedTypePropertyDef).value(new StringValue(type)).label(new LocalizableString(StringUtils.camelCaseToUpperCaseWords((String)StringUtils.getLeafClassName((String)type))));
    }

    private static List<String> getSupportedTypes(InvocationContext ic, String supportedTypesPropertyName) {
        BeanTreePath btp = ic.getBeanTreePath();
        Path path = btp.getPath();
        Path realmPath = path.subPath(0, 4);
        BeanTreePath realmBTP = BeanTreePath.create(btp.getBeanRepo(), realmPath);
        InvocationContext realmIC = new InvocationContext(ic, realmBTP);
        BeanReaderRepoSearchBuilder builder = realmIC.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(realmIC, false);
        BeanPropertyDef supportedTypesPropertyDef = realmIC.getBeanTreePath().getTypeDef().getPropertyDef(new Path(supportedTypesPropertyName));
        builder.addProperty(realmBTP, supportedTypesPropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        BeanSearchResults beanResults = searchResults.getBean(realmBTP);
        if (beanResults == null) {
            throw Response.notFoundException();
        }
        Value typesValue = beanResults.getValue(supportedTypesPropertyDef);
        TreeMap<String, String> sortedSupportedTypes = new TreeMap<String, String>();
        for (Value typeValue : typesValue.asArray().getValues()) {
            String type = typeValue.asString().getValue();
            sortedSupportedTypes.put(StringUtils.getLeafClassName((String)type), type);
        }
        return new ArrayList<String>(sortedSupportedTypes.values());
    }

    public static PageDef customizeUnknownSecurityProviderCommonPageDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        if (SecurityProviderMBeanCustomizer.hasCustomProperties(ic)) {
            return uncustomizedPageDef;
        }
        CustomSliceFormDef customizedSliceFormDef = new CustomSliceFormDef(uncustomizedPageDef.asSliceFormDef());
        CustomizerUtils.removeSliceIfPresent(customizedSliceFormDef, "CustomParameters");
        return customizedSliceFormDef;
    }

    public static PageDef customizeUnknownSecurityProviderCustomParametersPageDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        SliceFormDef uncustomizedSliceFormDef = uncustomizedPageDef.asSliceFormDef();
        CustomSliceFormDef customizedSliceFormDef = new CustomSliceFormDef(uncustomizedSliceFormDef);
        ArrayList<PagePropertyDef> customizedPagePropertyDefs = new ArrayList<PagePropertyDef>();
        customizedPagePropertyDefs.addAll(uncustomizedSliceFormDef.getPropertyDefs());
        for (BeanPropertyDef beanPropertyDef : SecurityProviderMBeanCustomizer.getCustomPropertyDefs(ic)) {
            CustomPagePropertyDef pagePropertyDef = new CustomPagePropertyDef(beanPropertyDef);
            pagePropertyDef.setPageDef(customizedSliceFormDef);
            customizedPagePropertyDefs.add(pagePropertyDef);
        }
        customizedSliceFormDef.setPropertyDefs(customizedPagePropertyDefs);
        return customizedSliceFormDef;
    }

    private static boolean hasCustomProperties(InvocationContext ic) {
        return !SecurityProviderMBeanCustomizer.getCustomPropertyDefs(ic).isEmpty();
    }

    private static List<BeanPropertyDef> getCustomPropertyDefs(InvocationContext ic) {
        BeanTypeDef typeDef = SecurityProviderMBeanCustomizer.getSecurityProviderTypeDef(ic);
        if (typeDef == null) {
            return List.of();
        }
        Set<String> extraPropertyNames = SecurityProviderMBeanCustomizer.getExtraStandardPropertyNames(ic);
        TreeMap<String, BeanPropertyDef> sortedCustomPropertyDefs = new TreeMap<String, BeanPropertyDef>();
        for (BeanPropertyDef propertyDef : typeDef.getPropertyDefs()) {
            String propertyName = propertyDef.getPropertyName();
            if (STANDARD_SECURITY_PROVIDER_PROPERTY_NAMES.contains(propertyName) || extraPropertyNames.contains(propertyName)) continue;
            sortedCustomPropertyDefs.put(propertyName, propertyDef);
        }
        return new ArrayList<BeanPropertyDef>(sortedCustomPropertyDefs.values());
    }

    private static BeanTypeDef getSecurityProviderTypeDef(InvocationContext ic) {
        BeanTreePath btp = ic.getBeanTreePath();
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
        BeanPropertyDef typePropertyDef = ic.getBeanTreePath().getTypeDef().getPropertyDef(new Path("Type"));
        builder.addProperty(btp, typePropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        BeanSearchResults beanResults = searchResults.getBean(btp);
        if (beanResults == null) {
            return null;
        }
        Value typeValue = beanResults.getValue(typePropertyDef);
        if (typeValue == null) {
            return null;
        }
        String typeName = typeValue.asString().getValue() + "MBean";
        return ic.getPageRepo().getBeanRepo().getBeanRepoDef().getTypeDef(typeName);
    }

    private static Set<String> getExtraStandardPropertyNames(InvocationContext ic) {
        String providerCollection = (String)ic.getBeanTreePath().getPath().getComponents().get(4);
        if ("AuthenticationProviders".equals(providerCollection)) {
            return STANDARD_AUTHENTICATION_PROVIDER_PROPERTY_NAMES;
        }
        return Set.of();
    }

    private static boolean isAdminServerConnection(InvocationContext ic) {
        return ic.getPageRepo().getBeanRepo().getBeanRepoDef().supportsCapabilities(List.of("AdminServerConnection"));
    }
}

