/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.customizers.CustomizerUtils;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.IntValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableRow;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestInvoker;

public class SAML2PartnerMBeanCustomizer {
    private SAML2PartnerMBeanCustomizer() {
    }

    public static List<TableRow> getArtifactResolutionServiceEndpointsSliceTableRows(InvocationContext ic, BeanReaderRepoSearchResults searchResults) {
        return SAML2PartnerMBeanCustomizer.getEndpointsSliceTableRows(ic, "artifactResolutionService");
    }

    public static List<TableRow> getAssertionConsumerServiceEndpointsSliceTableRows(InvocationContext ic, BeanReaderRepoSearchResults searchResults) {
        return SAML2PartnerMBeanCustomizer.getEndpointsSliceTableRows(ic, "assertionConsumerService");
    }

    public static List<TableRow> getSingleSignOnServiceEndpointsSliceTableRows(InvocationContext ic, BeanReaderRepoSearchResults searchResults) {
        return SAML2PartnerMBeanCustomizer.getEndpointsSliceTableRows(ic, "singleSignOnService");
    }

    public static List<TableRow> getSingleLogoutServiceEndpointsSliceTableRows(InvocationContext ic, BeanReaderRepoSearchResults searchResults) {
        return SAML2PartnerMBeanCustomizer.getEndpointsSliceTableRows(ic, "singleLogoutService");
    }

    public static List<TableRow> getEndpointsSliceTableRows(InvocationContext ic, String endpointsProperty) {
        return SAML2PartnerMBeanCustomizer.formatEndpoints(ic, SAML2PartnerMBeanCustomizer.getEndpoints(ic, endpointsProperty));
    }

    private static JsonArray getEndpoints(InvocationContext ic, String endpointsProperty) {
        Path cbePath = ic.getBeanTreePath().getPath();
        List cbeComponents = cbePath.getComponents();
        String realm = (String)cbeComponents.get(2);
        String providerCollection = StringUtils.getRestName((String)((String)cbeComponents.get(3)));
        String provider = (String)cbeComponents.get(4);
        String partner = (String)cbeComponents.get(6);
        Path wlsPath = new Path("serverConfig.realmsSecurityData");
        wlsPath.addComponent(realm);
        wlsPath.addComponent(providerCollection);
        wlsPath.addComponent(provider);
        wlsPath.addComponent("partners");
        wlsPath.addComponent(partner);
        JsonObject partnerJson = WebLogicRestInvoker.get(ic, wlsPath, false).getResults();
        JsonArray endpoints = partnerJson.getJsonArray(endpointsProperty);
        return endpoints;
    }

    private static List<TableRow> formatEndpoints(InvocationContext ic, JsonArray endpoints) {
        ArrayList<TableRow> rtn = new ArrayList<TableRow>();
        for (int i = 0; i < endpoints.size(); ++i) {
            rtn.add(SAML2PartnerMBeanCustomizer.formatEndpoint(ic, endpoints.getJsonObject(i)));
        }
        return rtn;
    }

    private static TableRow formatEndpoint(InvocationContext ic, JsonObject endpoint) {
        TableRow row = new TableRow();
        row.getCells().add(new TableCell("Binding", new StringValue(CustomizerUtils.getStringField(endpoint, "binding"))));
        row.getCells().add(new TableCell("Location", new StringValue(CustomizerUtils.getStringField(endpoint, "location"))));
        if (endpoint.containsKey((Object)"index")) {
            row.getCells().add(new TableCell("Index", new IntValue(endpoint.getInt("index"))));
            row.getCells().add(new TableCell("Default", new StringValue(CustomizerUtils.getStringField(endpoint, "default"))));
        }
        return row;
    }
}

