/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.json.JsonObject;
import javax.ws.rs.core.Response;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.server.repo.BeanEditorRepo;
import weblogic.remoteconsole.server.repo.BeanPropertyValue;
import weblogic.remoteconsole.server.repo.BeanPropertyValues;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.IntValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.CreatableBeanCollectionResource;
import weblogic.remoteconsole.server.webapp.CreateHelper;

public class RealmMBeanCreatableBeanCollectionResource
extends CreatableBeanCollectionResource {
    @Override
    protected Response createCollectionChild(JsonObject requestBody) {
        return new RealmMBeanCreateHelper().createBean(this.getInvocationContext(), requestBody);
    }

    private static class RealmMBeanCreateHelper
    extends CreateHelper {
        private RealmMBeanCreateHelper() {
        }

        @Override
        protected weblogic.remoteconsole.server.repo.Response<Void> createBean(InvocationContext ic, List<FormProperty> formProperties) {
            weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
            weblogic.remoteconsole.server.repo.Response<BeanTreePath> btpResponse = this.computeNewBeanPath(ic, formProperties);
            if (!btpResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(btpResponse);
            }
            BeanTreePath newRealmBTP = btpResponse.getResults();
            boolean createDefaultProviders = false;
            ArrayList<FormProperty> realmFormProperties = new ArrayList<FormProperty>();
            for (FormProperty formProperty : formProperties) {
                if ("CreateDefaultProviders".equals(formProperty.getName())) {
                    createDefaultProviders = formProperty.getValue().asSettable().getValue().asBoolean().getValue();
                    continue;
                }
                realmFormProperties.add(formProperty);
            }
            weblogic.remoteconsole.server.repo.Response<Void> r = super.createBean(ic, realmFormProperties);
            if (!r.isSuccess()) {
                return response.copyUnsuccessfulResponse(r);
            }
            if (createDefaultProviders && !(r = this.createDefaultProviders(new InvocationContext(ic, newRealmBTP))).isSuccess()) {
                this.cleanupFailedCreate(ic, newRealmBTP);
                return response.copyUnsuccessfulResponse(r);
            }
            return response.setSuccess(null);
        }

        private weblogic.remoteconsole.server.repo.Response<Void> createDefaultProviders(InvocationContext newRealmIC) {
            weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
            weblogic.remoteconsole.server.repo.Response<BeanTreePath> cr = null;
            cr = this.createProvider(newRealmIC, "AuthenticationProviders", "DefaultAuthenticator", "weblogic.security.providers.authentication.DefaultAuthenticator");
            if (!cr.isSuccess()) {
                return response.copyUnsuccessfulResponse(cr);
            }
            cr = this.createProvider(newRealmIC, "AuthenticationProviders", "DefaultIdentityAsserter", "weblogic.security.providers.authentication.DefaultIdentityAsserter");
            if (!cr.isSuccess()) {
                return response.copyUnsuccessfulResponse(cr);
            }
            cr = this.createProvider(newRealmIC, "Authorizers", "XACMLAuthorizer", "weblogic.security.providers.xacml.authorization.XACMLAuthorizer");
            if (!cr.isSuccess()) {
                return response.copyUnsuccessfulResponse(cr);
            }
            cr = this.createProvider(newRealmIC, "RoleMappers", "XACMLRoleMapper", "weblogic.security.providers.xacml.authorization.XACMLRoleMapper");
            if (!cr.isSuccess()) {
                return response.copyUnsuccessfulResponse(cr);
            }
            cr = this.createProvider(newRealmIC, "Adjudicator", "DefaultAdjudicator", "weblogic.security.providers.authorization.DefaultAdjudicator");
            if (!cr.isSuccess()) {
                return response.copyUnsuccessfulResponse(cr);
            }
            cr = this.createProvider(newRealmIC, "CredentialMappers", "DefaultCredentialMapper", "weblogic.security.providers.credentials.DefaultCredentialMapper");
            if (!cr.isSuccess()) {
                return response.copyUnsuccessfulResponse(cr);
            }
            cr = this.createProvider(newRealmIC, "CertPathProviders", "WebLogicCertPathProvider", "weblogic.security.providers.pk.WebLogicCertPathProvider");
            if (!cr.isSuccess()) {
                return response.copyUnsuccessfulResponse(cr);
            }
            BeanTreePath cppBTP = cr.getResults();
            weblogic.remoteconsole.server.repo.Response<Void> ur = this.getEditorRepo(newRealmIC).updateBean(newRealmIC, this.createPropertyValues(newRealmIC.getBeanTreePath(), Map.of("CertPathBuilder", cppBTP)));
            if (!ur.isSuccess()) {
                return response.copyUnsuccessfulResponse(ur);
            }
            cr = this.createProvider(newRealmIC, "PasswordValidators", "SystemPasswordValidator", "com.bea.security.providers.authentication.passwordvalidator.SystemPasswordValidator");
            if (!cr.isSuccess()) {
                return response.copyUnsuccessfulResponse(cr);
            }
            BeanTreePath pvBTP = cr.getResults();
            InvocationContext pvIC = new InvocationContext(newRealmIC, pvBTP);
            weblogic.remoteconsole.server.repo.Response<Void> ur2 = this.getEditorRepo(pvIC).updateBean(pvIC, this.createPropertyValues(pvBTP, this.getTypeDef(pvIC, "SystemPasswordValidatorMBean"), Map.of("MinPasswordLength", new IntValue(8), "MinNumericOrSpecialCharacters", new IntValue(1))));
            if (!ur2.isSuccess()) {
                return response.copyUnsuccessfulResponse(ur2);
            }
            return response.setSuccess(null);
        }

        private weblogic.remoteconsole.server.repo.Response<BeanTreePath> createProvider(InvocationContext realmIC, String childName, String providerName, String providerType) {
            weblogic.remoteconsole.server.repo.Response<BeanTreePath> response = new weblogic.remoteconsole.server.repo.Response<BeanTreePath>();
            BeanTreePath realmBTP = realmIC.getBeanTreePath();
            BeanTypeDef realmTypeDef = realmBTP.getTypeDef();
            BeanTreePath childBTP = realmBTP.childPath(new Path(childName));
            InvocationContext childIC = new InvocationContext(realmIC, childBTP);
            BeanPropertyValues values = this.createPropertyValues(childBTP, Map.of("Name", new StringValue(providerName), "Type", new StringValue(providerType)));
            weblogic.remoteconsole.server.repo.Response<Void> cr = this.getEditorRepo(realmIC).createBean(childIC, values);
            if (!cr.isSuccess()) {
                return response.copyUnsuccessfulResponse(cr);
            }
            BeanTreePath spBTP = null;
            spBTP = childBTP.isCollection() ? BeanTreePath.create(realmBTP.getBeanRepo(), childBTP.getPath().childPath(providerName)) : childBTP;
            return response.setSuccess(spBTP);
        }

        private BeanPropertyValues createPropertyValues(BeanTreePath btp, Map<String, Value> values) {
            return this.createPropertyValues(btp, btp.getTypeDef(), values);
        }

        private BeanPropertyValues createPropertyValues(BeanTreePath btp, BeanTypeDef typeDef, Map<String, Value> values) {
            BeanPropertyValues rtn = new BeanPropertyValues(btp);
            for (Map.Entry<String, Value> e : values.entrySet()) {
                rtn.addPropertyValue(new BeanPropertyValue(typeDef.getPropertyDef(new Path(e.getKey())), new SettableValue(e.getValue())));
            }
            return rtn;
        }

        private BeanTypeDef getTypeDef(InvocationContext ic, String typeName) {
            return ic.getPageRepo().getBeanRepo().getBeanRepoDef().getTypeDef(typeName);
        }

        private BeanEditorRepo getEditorRepo(InvocationContext ic) {
            return ic.getPageRepo().getBeanRepo().asBeanEditorRepo();
        }
    }
}

