/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.customizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.ActionInputFormDef;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.CustomActionInputFormDef;
import weblogic.remoteconsole.common.repodef.CustomLegalValueDef;
import weblogic.remoteconsole.common.repodef.CustomPageActionParamDef;
import weblogic.remoteconsole.common.repodef.LegalValueDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageActionParamDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.customizers.CustomizerUtils;
import weblogic.remoteconsole.server.repo.BeanActionArg;
import weblogic.remoteconsole.server.repo.BeanReaderRepo;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.Form;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.PropertiesValue;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;

public class ProviderSecurityDataMBeanCustomizer {
    public static PageDef customizeExportDataActionInputFormDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        return ProviderSecurityDataMBeanCustomizer.customizeMigrateDataActionInputFormDef(ic, uncustomizedPageDef, true);
    }

    public static PageDef customizeImportDataActionInputFormDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        return ProviderSecurityDataMBeanCustomizer.customizeMigrateDataActionInputFormDef(ic, uncustomizedPageDef, false);
    }

    private static PageDef customizeMigrateDataActionInputFormDef(InvocationContext ic, PageDef uncustomizedPageDef, boolean isExport) {
        MigrationProviderInfo providerInfo = new MigrationProviderInfo(ic, isExport);
        ActionInputFormDef uncustomizedInputFormDef = uncustomizedPageDef.asActionInputFormDef();
        CustomActionInputFormDef customizedInputFormDef = new CustomActionInputFormDef(uncustomizedInputFormDef);
        ArrayList<PageActionParamDef> customizedParamDefs = new ArrayList<PageActionParamDef>();
        for (PageActionParamDef uncustomizedParamDef : uncustomizedInputFormDef.getParamDefs()) {
            String name = uncustomizedParamDef.getParamName();
            if ("Format".equals(name)) {
                if (providerInfo.getSupportedFormats().size() <= 1) continue;
                customizedParamDefs.add(ProviderSecurityDataMBeanCustomizer.customizeFormatParamDef(uncustomizedParamDef, customizedInputFormDef, providerInfo.getSupportedFormats()));
                continue;
            }
            if ("Constraints".equals(name)) {
                if (providerInfo.getSupportedConstraints().isEmpty()) continue;
                customizedParamDefs.add(uncustomizedParamDef);
                continue;
            }
            customizedParamDefs.add(uncustomizedParamDef);
        }
        customizedInputFormDef.setParamDefs(customizedParamDefs);
        return customizedInputFormDef;
    }

    private static CustomPageActionParamDef customizeFormatParamDef(PageActionParamDef uncustomizedFormatDef, CustomActionInputFormDef customizedInputFormDef, List<String> supportedFormats) {
        CustomPageActionParamDef customizedFormatDef = new CustomPageActionParamDef(uncustomizedFormatDef).inputFormDef(customizedInputFormDef);
        ArrayList<LegalValueDef> legalValueDefs = new ArrayList<LegalValueDef>();
        for (String supportedFormat : supportedFormats) {
            legalValueDefs.add(new CustomLegalValueDef().fieldDef(customizedFormatDef).value(new StringValue(supportedFormat)).label(new LocalizableString(supportedFormat)));
        }
        return customizedFormatDef.legalValueDefs(legalValueDefs);
    }

    public static void customizeExportDataActionInputForm(InvocationContext ic, Page page) {
        ProviderSecurityDataMBeanCustomizer.customizeMigrateDataActionInputForm(ic, page, true);
    }

    public static void customizeImportDataActionInputForm(InvocationContext ic, Page page) {
        ProviderSecurityDataMBeanCustomizer.customizeMigrateDataActionInputForm(ic, page, false);
    }

    private static void customizeMigrateDataActionInputForm(InvocationContext ic, Page page, boolean isExport) {
        MigrationProviderInfo providerInfo = new MigrationProviderInfo(ic, isExport);
        ProviderSecurityDataMBeanCustomizer.customizePageIntro(ic, page, isExport, providerInfo.getSupportedConstraints());
        ArrayList<FormProperty> customizedProperties = new ArrayList<FormProperty>();
        Form form = page.asForm();
        for (FormProperty uncustomizedProperty : form.getProperties()) {
            String name = uncustomizedProperty.getName();
            if ("FileName".equals(name)) {
                String fullTypeName = ProviderSecurityDataMBeanCustomizer.getSecurityProviderTypeDef(ic).getTypeName();
                String providerType = StringUtils.removeSuffix((String)StringUtils.getLeafClassName((String)fullTypeName), (String[])new String[]{"MBean"});
                customizedProperties.add(new FormProperty(uncustomizedProperty.getFieldDef(), new StringValue(providerType + ".dat")));
                continue;
            }
            if ("Format".equals(name)) {
                customizedProperties.add(new FormProperty(uncustomizedProperty.getFieldDef(), new StringValue(providerInfo.getSupportedFormats().get(0))));
                continue;
            }
            if ("Constraints".equals(name)) {
                customizedProperties.add(new FormProperty(uncustomizedProperty.getFieldDef(), new PropertiesValue(new Properties())));
                continue;
            }
            customizedProperties.add(uncustomizedProperty);
        }
        form.getProperties().clear();
        form.getProperties().addAll(customizedProperties);
    }

    private static void customizePageIntro(InvocationContext ic, Page page, boolean isExport, List<String> supportedConstraints) {
        Object intro = ic.getLocalizer().localizeString(page.getPageDef().getIntroductionHTML(), new Object[0]);
        if (!supportedConstraints.isEmpty()) {
            LocalizableString ls = isExport ? LocalizedConstants.EXPORT_SECURITY_DATA_CONSTRAINTS_INTRO : LocalizedConstants.IMPORT_SECURITY_DATA_CONSTRAINTS_INTRO;
            String constraintsIntro = ic.getLocalizer().localizeString(ls, ProviderSecurityDataMBeanCustomizer.formatSupportedConstraints(supportedConstraints));
            intro = (String)intro + constraintsIntro;
        }
        page.setLocalizedIntroductionHTML((String)intro);
    }

    private static String formatSupportedConstraints(List<String> supportedConstraints) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String supportedConstraint : supportedConstraints) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("<code>").append(supportedConstraint).append("</code>");
            first = false;
        }
        return sb.toString();
    }

    public static Value exportData(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        return ProviderSecurityDataMBeanCustomizer.migrateData(ic, pageActionDef, formProperties, true);
    }

    public static Value importData(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        return ProviderSecurityDataMBeanCustomizer.migrateData(ic, pageActionDef, formProperties, false);
    }

    public static Value migrateData(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties, boolean isExport) {
        MigrationProviderInfo providerInfo = new MigrationProviderInfo(ic, isExport);
        Value filenameValue = CustomizerUtils.findRequiredFormProperty("FileName", formProperties).getValue().asSettable().getValue();
        Value formatValue = ProviderSecurityDataMBeanCustomizer.getFormatValue(formProperties, providerInfo.getSupportedFormats());
        Value constraintsValue = ProviderSecurityDataMBeanCustomizer.getConstraintsValue(formProperties);
        String actionName = isExport ? "exportData" : "importData";
        BeanTreePath providerBTP = ProviderSecurityDataMBeanCustomizer.getSecurityProviderBTP(ic);
        BeanActionDef actionDef = ProviderSecurityDataMBeanCustomizer.getSecurityProviderTypeDef(ic).getActionDef(actionName);
        List<BeanActionArg> args = List.of(new BeanActionArg(actionDef.getParamDef("format"), formatValue), new BeanActionArg(actionDef.getParamDef("filename"), filenameValue), new BeanActionArg(actionDef.getParamDef("constraints"), constraintsValue));
        return ic.getPageRepo().getBeanRepo().asBeanReaderRepo().invokeAction(ic, providerBTP, actionDef, args).getResults();
    }

    private static Value getFormatValue(List<FormProperty> formProperties, List<String> supportedFormats) {
        FormProperty prop = CustomizerUtils.findOptionalFormProperty("Format", formProperties);
        if (prop != null) {
            return prop.getValue().asSettable().getValue();
        }
        return new StringValue(supportedFormats.get(0));
    }

    private static Value getConstraintsValue(List<FormProperty> formProperties) {
        FormProperty prop = CustomizerUtils.findOptionalFormProperty("Constraints", formProperties);
        if (prop != null) {
            return prop.getValue().asSettable().getValue();
        }
        return new PropertiesValue(new Properties());
    }

    private static BeanTypeDef getSecurityProviderTypeDef(InvocationContext ic) {
        BeanTreePath providerBTP = ProviderSecurityDataMBeanCustomizer.getSecurityProviderBTP(ic);
        BeanPropertyDef typePropertyDef = providerBTP.getTypeDef().getPropertyDef("Type");
        BeanReaderRepo beanReader = ic.getPageRepo().getBeanRepo().asBeanReaderRepo();
        BeanReaderRepoSearchBuilder builder = beanReader.createSearchBuilder(ic, false);
        builder.addProperty(providerBTP, typePropertyDef);
        BeanReaderRepoSearchResults searchResults = builder.search().getResults();
        BeanSearchResults providerResults = searchResults.getBean(providerBTP);
        if (providerResults == null) {
            throw Response.notFoundException();
        }
        Value typeValue = providerResults.getValue(typePropertyDef);
        if (typeValue != null) {
            String typeName = StringUtils.nonEmpty((String)typeValue.asString().getValue()) + "MBean";
            return beanReader.getBeanRepoDef().getTypeDef(typeName);
        }
        throw Response.notFoundException();
    }

    private static BeanTreePath getSecurityProviderBTP(InvocationContext ic) {
        Path securityDataProviderPath = ic.getBeanTreePath().getPath();
        Path realmsRelativeProviderPath = securityDataProviderPath.subPath(2, securityDataProviderPath.length());
        Path securityProviderPath = new Path("Domain.SecurityConfiguration.Realms").childPath(realmsRelativeProviderPath);
        return BeanTreePath.create(ic.getBeanTreePath().getBeanRepo(), securityProviderPath);
    }

    private static class MigrationProviderInfo {
        private List<String> supportedFormats = new ArrayList<String>();
        private List<String> supportedConstraints = new ArrayList<String>();

        private MigrationProviderInfo(InvocationContext ic, boolean isExport) {
            String supportedFormatsPropertyName = isExport ? "SupportedExportFormats" : "SupportedImportFormats";
            String supportedConstraintsPropertyName = isExport ? "SupportedExportConstraints" : "SupportedImportConstraints";
            BeanTreePath providerBTP = ProviderSecurityDataMBeanCustomizer.getSecurityProviderBTP(ic);
            BeanTypeDef providerTypeDef = ProviderSecurityDataMBeanCustomizer.getSecurityProviderTypeDef(ic);
            BeanPropertyDef supportedFormatsPropertyDef = providerTypeDef.getPropertyDef(supportedFormatsPropertyName);
            BeanPropertyDef supportedConstraintsPropertyDef = providerTypeDef.getPropertyDef(supportedConstraintsPropertyName);
            BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, false);
            builder.addProperty(providerBTP, supportedFormatsPropertyDef);
            builder.addProperty(providerBTP, supportedConstraintsPropertyDef);
            BeanReaderRepoSearchResults searchResults = builder.search().getResults();
            BeanSearchResults providerResults = searchResults.getBean(providerBTP);
            if (providerResults == null) {
                throw Response.notFoundException();
            }
            this.supportedFormats = this.getRequiredStringsProperty(providerResults, supportedFormatsPropertyDef);
            this.supportedConstraints = this.getRequiredStringsProperty(providerResults, supportedConstraintsPropertyDef);
        }

        private List<String> getRequiredStringsProperty(BeanSearchResults providerResults, BeanPropertyDef propertyDef) {
            Value valuesValue = providerResults.getValue(propertyDef);
            if (valuesValue == null) {
                throw new AssertionError((Object)(String.valueOf(providerResults.getBeanTreePath()) + " does not support " + String.valueOf(propertyDef)));
            }
            ArrayList<String> rtn = new ArrayList<String>();
            for (Value value : valuesValue.asArray().getValues()) {
                String val = value.asString().getValue();
                if (StringUtils.isEmpty((String)val)) continue;
                rtn.add(val);
            }
            return rtn;
        }

        private List<String> getSupportedFormats() {
            return this.supportedFormats;
        }

        private List<String> getSupportedConstraints() {
            return this.supportedConstraints;
        }
    }

    private static class ImportProviderInfo
    extends MigrationProviderInfo {
        private ImportProviderInfo(InvocationContext ic) {
            super(ic, false);
        }
    }

    private static class ExportProviderInfo
    extends MigrationProviderInfo {
        private ExportProviderInfo(InvocationContext ic) {
            super(ic, true);
        }
    }
}

